proc format;
value $auth
"1" = "Deny"  /* explicit Deny */
"2" = "Grant" /* explicit Grant */
"4" = "ACT DENY"
"8" = "ACT GRANT"
"16" = "Indirect DENY"
"32" = "Indirect GRANT"
;
value $auth_short
"1" = "D"
"2" = "G"
;

run;



data &aciOLAPTable(compress=yes);

  keep fullname olapschema cube dimension items permission perm_type mdx_condition  remove_ace;
  length fullname $32;
  length olapschema $64;
  length cube $32;
  length dimension $32;
  length items $32;
  length permission $32;
  length perm_type $2;
  length mdx_condition $32000;
  length remove_ace $1;

  length dt $1; dt='';

  length uri schema_uri cube_uri dim_uri meas_uri hier_uri lev_uri owndim_uri   $256; /* omr id vars */
  uri='';schema_uri='';cube_uri='';dim_uri='';meas_uri='';hier_uri='';lev_uri=''; owndim_uri=''; 
  length cube_name dim_name meas_name item_name dimMeasName $32;
  cube_name='';dim_name='';meas_name='';item_name=''; dimMeasName='';
   

  fullname='';
  olapschema='';
  cube='';
  dimension='';
  items='';
  permission='';
  perm_type='';
  mdx_condition='';
  remove_ace='';

 if "&olapschema" ne "" then do;
   
  	/* Get Schema */
     
  	schema_uri = "omsobj:OLAPSchema?OLAPSchema[@Name='" || "&olapschema."  || "']"; 
  	rc = metadata_getattr(schema_uri, 'ID', schema_uri); uri=schema_uri; link checkrc;   

  	/* Get cubes */
  	crc = 1;
  	cn = 1;
  	do while (crc > 0);
         
      	/* for single cube */
    	if "&cubename" ne "" then do;
	  	cube_uri =
      	"omsobj:Cube?Cube[@Name='"
      	|| "&cubename."
      	|| "'][AssociatedOLAPSchema/OLAPSchema[@ID='"
      	|| trim(left(schema_uri))
      	|| "']]";  
        
	  	rc = metadata_getnobj(cube_uri, 1, cube_uri); uri=schema_uri; link checkrc;     
      	rc = metadata_getattr(cube_uri, "Name", cube_name);
      	crc = -4;
		end;

		/* for all cubes in schema */
    	else do; 
	  	cube_name='';
      	crc = metadata_getnass(schema_uri,"Cubes", cn,  cube_uri);  
      	if crc > 0 then do;
        	drc = metadata_getattr(cube_uri, 'Name', cube_name);
        	cn = cn+1;
      	end; 
	  	else return;
    	end;  /* end of the else do  */

	    uri = cube_uri; 
	    dt='C';
	    dim_name='';
	    item_name=''; 
	    link GETPERM; 
 
	    /* Get Dimensions */
	    drc = 1;
	    dn = 1; 
        onceThrough = 1;
	    finishMeasures = 1;
	    do while (drc > -1);
	      
	      fullname='';
              olapschema='';
	      cube='';
	      dimension='';
	      items='';
	      permission='';
	      perm_type='';
	      mdx_condition='';
	      remove_ace='';
	      mrc = 1;
	      mn = 1; 
          if (finishMeasures = 1) then do;   
	       do while (mrc > -1);
		         
	       		mrc = metadata_getnass(cube_uri, 'Measures', mn, meas_uri);
	       		 
	       		if (mrc >= 0) then do;
	       		    mrc = metadata_getattr(meas_uri, 'Name', item_name);
	       		    
					if (mrc >=0) then do;
					    if (onceThrough = 1) then do;
					         
	           				dimensionrc = metadata_getnass(meas_uri, 'OwningDimension', 1, owndim_uri);
	           			 
	           				dnamerc = metadata_getattr(owndim_uri,'Name', dim_name); 
	           				 
							dimMeasName = dim_name;
							uri=owndim_uri; dt='D'; link GETPERM;
						end;
						onceThrough = 2;
						 
	           			uri=meas_uri; dt='M'; link GETPERM; item_name = ''; 
	       	    	end; /* if (mrc >=0) */
	       	   end; /* while (mrc > 0) */
			    
              mn = mn+1;
			  
	    	 end;
	    	end;
			 
	      finishMeasures = 2;	
	      dim_name = '';	 
	      drc = metadata_getnass(cube_uri, 'Dimensions', dn, dim_uri);
	 
		  if (drc >= 0) then do;
	        drc = metadata_getattr(dim_uri, 'Name', dim_name);
	       
			 
             
            /* if measures dimension go get another */
			 
            if (dimMeasName = dim_name ) then do;
			   dn = dn + 1;
               continue;
			end;
            uri=dim_uri; dt='D'; link GETPERM;
	         
	 
	        /* Get Hierarchies */
	        hrc = 1;
	        hn = 1; * hierarchy counter;
	
	        do while (hrc > -1);
	        
	          hrc = metadata_getnass(dim_uri, 'Hierarchies', hn, hier_uri);
	          if (hrc >= 0) then do;
	            hnrc = metadata_getattr(hier_uri, 'Name', item_name); 
	               
		        uri=hier_uri; dt='H'; link GETPERM; item_name = '';
	
	            /* Get Levels */
	            lrc = 1;
	            ln = 1;
	            do while (lrc > -1);
				 
	              lrc = metadata_getnass(hier_uri, 'Levels', ln, lev_uri);
	              if (lrc >=0) then do;
	                lnrc = metadata_getattr(lev_uri, 'Name', item_name); 
	               
		            uri=lev_uri; dt='L'; link GETPERM; item_name = '';
	
	              end; /* if (lrc >=0) */
	              ln = ln+1;
	            end; /* while (lrc > 0) */
	          end; /* if (hrc >= 0) */
	          hn = hn+1;
	        end; /* while (hrc > 0) */
	       dn = dn+1;  
	    end; /* while (drc > 0) */  
      end; /* while (drc > 0) */ 
  end; /* while (crc > 0) */   
 end;/* olapschema != null */
  stop; 
  

GETPERM:
  /* get permissions */
  length type $13; /* "Person" or "IdentityGroup" */
  length auth $2;  /* 1,2,4,8,16,32 - see $auth. format */
  length user_name perm $256;
  length condition $32000;
  type='';user_name='';perm='';auth='';condition='';	

  n =1;
  do until (rc ne 0);
    type='';user_name='';auth='';Perm='';condition='';	

    rc = METASEC_GETNAUTH("",           /* transaction context - not needed */
                          uri,          /* target object (e.g. cube, dimension, etc. */
                          n,            /* nth ace for that object */
                          type,         /* IdentityGroup or Person */
                          user_name,    /* unique name of identity (user) */
                          auth ,        /* GRANT/DENY */
                          Perm ,        /* name of Permission (Read, Administer, etc.) */
                          condition);   /* optional MDX Permission Condition */ 
   if rc ne 0 then return;

   if band(input(auth,2.),1) then
	   auth='1';
   else if band(input(auth,2.),2) then
	   auth='2';
   if auth in ('1' '2') then do;  /* only direct, non-inherited GRANT and DENY */
      fullname =  user_name;
      olapschema = "&olapschema";
      cube = cube_name;
      dimension = dim_name;
      items = item_name;
	  permission = perm;
      perm_type = put(auth,$auth_short.) || dt;
      if finishMeasures=1 and dt='D' then items="";
	  if Perm = 'Read' then 
        mdx_condition = condition ;
	  else 
	    mdx_condition = '';

      remove_ace = 'N';

      output;

    end;

  
    n = n+1;
  end;
return;

checkrc:
  select (rc);
    when (-1) put "&noConnectMsg";
    when (-2) put "&noAttrMsg" uri;
    when (-3) put "&noMatch" uri;
    when (-4) put "&notFound" uri;
     otherwise;
  end;
  if rc < 0 then stop;
return;

run;

