<?xml version='1.0'?>
<!--  Change History -->
<!--   vekada: 16Aug2006 Remove TP_ID and DLV_ID -->
<!--   sdksvh: 05May2006 Apply Formats for both SAS and non SAS DBMS -->
<!--   sdksvh: 25Oct2005 Finalized Implementing Defect S0199360 from May2003-->
<!--   sdksvh: 21Oct2005 Implementing Intelligent Lengths for Numeric Columns-->
<!--   vekada: 17Jun2005 Removed text "Library" from name of Library -->
<!--   vekada: 02Jun2005 ID for Key Association, Column Formats based on FieldNames for SAS Datasets, Lengths restricted only for SAS -->
<!--   vekada: 23May2005 Restrict numeric lengths in the range of 3-8 and Character field lengths of 1-32768 -->
<!--   vekada: 10May2005 Changed column id to be XMI ID.  Previously it was concatenation of name twice with XMI_ID -->
<!--   vekada: 10May2005 Changed order of OwningPhysicalTable in Indexes. Hierarchy id not change.  This is for processing using XML Libname Engine -->
<!--   vekada: 09May2005 added Numeric Precision (Lengths for Numeric Fields) -->
<!--   vekada: 09May2005 added Id for Indexes -->
<!--   sascxr: 04mar2002 added support for non-primary unique keys -->
<!--   elmcin: 14Mar2002 changed deployedComponent to ServerContext and ServerComponent   -->
<!--   elmcin: 18Mar2002 changed to use {$paraname} instead of hard coding element names   -->
<!--   elmcin: 04Apr2002 copied and changed for CWM1.0 -->
<!--   elmcin: 25Oct2002 S0169793: Table description processed twice -->
<!--   elmcin: 31Oct2002 S0170491: Column descriptions not being processed -->
<!--   elmcin: 07Nov2002 S0168839: Add properties for DBMS special char to tables -->
<!--   elmcin: 07Nov2002 S0170101: SASTableName not included on views -->
<!--   elmcin: 25Nov2002 S0160689: Create metadata for SAS or DBMS based upon importType param -->
<!--   elmcin: 07Jan2003 S0176666: Need to use pre-defined library to ensure all necessary info is defined -->
<!--                               SAS/Share also should use pre-defined library instead of new schema -->
<!--   elmcin: 24Jan2003 S0180432: views are not imported into the library, but need to be -->
<!--   elmcin: 07Feb2003 S0183287: import should set ColumnName for Columns to be consistent with ETL -->
<!--   elmcin: 05Sep2003 S0218776: dbms names properties -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:CWM="org.omg.CWM1.0"
xmlns:CWMRDB="org.omg.CWM1.0/Relational"
exclude-result-prefixes="CWM CWMRDB"
version="1.0">
<xsl:output method="xml" omit-xml-declaration="yes" />
<xsl:param name="repid">A0000001.A5YV3Z62</xsl:param>
<xsl:param name="treeid"></xsl:param>

<!-- sascxr: support for building engine -->
<xsl:param name="engine">ODBC</xsl:param>               <!-- engine for the library definition -->
<xsl:param name="connid">error</xsl:param>      <!-- the connection id to attach the library to -->
<xsl:param name="conntype">error</xsl:param>    <!-- the connection type to create -->
<!-- <xsl:param name="loginId"></xsl:param>     -->                             <!-- don't think we need -->
<xsl:param name="dbid">error</xsl:param>                        <!-- the database to connect the schema to -->
<xsl:param name="appid">error</xsl:param>  <!-- app server id, the sas session that should be used -->
<xsl:param name="apptype">ServerContext</xsl:param>  <!-- app server type to create -->
<!-- sascxr: end -->

<!--   elmcin: 07Nov2002 S0168839: Add properties for DBMS special char to tables -->
<xsl:param name="specchar">N</xsl:param>
<xsl:param name="case">N</xsl:param>
<!-- S0160689: DBMS will be the default, SAS if it is SAS datasets, SHARE if SAS/Share -->
<xsl:param name="importType">DBMS</xsl:param>
<!-- S0176666: Need to use pre-defined library to ensure all necessary info is defined -->
<xsl:param name="libid">error</xsl:param>
<!-- schemaid is the location where tables will reside for SHARE -->
<xsl:param name="schemaid">error</xsl:param>
<xsl:param name="schematype">error</xsl:param>  <!-- I also need to know the type of schema; library or db -->
<xsl:param name="createremote">false</xsl:param>


<!-- This template will take the input metadata in CWM format
     and convert it into a format that can be read into OMR, v2.0 of the model-->

<xsl:key name="dataType" match="//CWMRDB:SQLSimpleType|//CWMRDB:SQLDistinctType" use="@xmi.id"/>
<xsl:key name="uniqueKeys" match="//CWMRDB:PrimaryKey|//CWMRDB:UniqueKey|//CWMRDB:UniqueConstraint" use="@xmi.id"/>
<xsl:key name="columns" match="//CWMRDB:Column" use="@xmi.id"/>
<xsl:key name="tables" match="//CWMRDB:BaseTable|//CWMRDB:Table" use="@xmi.id"/>
<xsl:key name="notes" match="//CWM:Description" use="@modelElement"/>

<xsl:variable name="sastype">C</xsl:variable>

<xsl:template match="/">
<!-- for testing only; need one top level element -->
<!-- <xsl:element name="TEST"> -->

<!-- adding two property types to support the table properties -->
<xsl:element name="PropertyType">
   <xsl:attribute name="Name">Case</xsl:attribute>
   <xsl:attribute name="SQLType">12</xsl:attribute>
   <xsl:attribute name="Id">$caseType</xsl:attribute>
</xsl:element>
<xsl:element name="PropertyType">
   <xsl:attribute name="Name">SpecChar</xsl:attribute>
   <xsl:attribute name="SQLType">12</xsl:attribute>
   <xsl:attribute name="Id">$speccharType</xsl:attribute>
</xsl:element>

<!--putting this here so it is evaluated only once, removed it from CWMRDB:Schema template -->
     <xsl:if test="$importType='SHARE'">
          <xsl:if test="$createremote!='false'">
             <xsl:call-template name="SHAREData"/>
          </xsl:if>
     </xsl:if>

<xsl:apply-templates select="//CWMRDB:Schema" />
<!-- BaseTable was changed to Table in CWM1.0 -->
<xsl:apply-templates select="//CWMRDB:BaseTable|//CWMRDB:Table" />
<xsl:apply-templates select="//CWMRDB:View" />
<xsl:apply-templates select="//CWMRDB:SQLIndex" />


<!-- </xsl:element>                              -->

</xsl:template>

<!--  ****************************************** -->
<!--  Template for a Schema                      -->
<!--  ****************************************** -->
<xsl:template match="//CWMRDB:Schema">
   <xsl:choose>
     <xsl:when test="$importType='DBMS'">
          <xsl:call-template name="DBMSData"/>
     </xsl:when>

     <xsl:otherwise>
        <!-- do nothing here, if it is SAS then the tables will be set to the pre-defined library in the -->
        <!-- table template                                                                              -->
     </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<!--  ****************************************** -->
<!--  Template for a DBMSData                    -->
<!--  ****************************************** -->
<xsl:template name="DBMSData">
<xsl:element name="DatabaseSchema">
                            <!-- <xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute>-->
                            <xsl:call-template name="getNameAttribute"/>
<!-- sascxr: have to build the SchemaName attribute -->
<!-- sascxr: What is this in the input CWM file??? -->
                            <xsl:attribute name="SchemaName">
<!-- sascxr: not sure what this should be.  It looks like often the schema name is "logical view", which isn't the real schema name.
                  see notes in design spec on this...
   -->

                          <xsl:if test="@name">
                               <xsl:choose>

                                        <xsl:when test="(contains(@name,'MIMBDerivedSchema'))">
                                             <!-- the schema name is derived so we will not set a name -->
                                        </xsl:when>

                                        <xsl:when test="not(contains(@name,' '))">

                                                <xsl:value-of select="@name"/>

                                        </xsl:when>
                                        <xsl:otherwise>
                                                <!-- set SchemaName to null if name contains blanks -->
                                        </xsl:otherwise>
                                </xsl:choose>
                          </xsl:if>
                          <xsl:if test="./CWM:ModelElement.name">
                          <xsl:variable name="theName"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:variable>
                          <xsl:choose>
                              <xsl:when test="(contains(@name,'MIMBDerivedSchema'))">
                              <!-- the schema name is derived so we will not set a name -->
                              </xsl:when>

                              <xsl:when test="not(contains($theName,' '))">
                                    <xsl:value-of select="./CWM:ModelElement.name"/>
                              </xsl:when>
                              <xsl:otherwise>
                              <!-- set SchemaName to null if name contains blanks -->
                              </xsl:otherwise>
                          </xsl:choose>
                          </xsl:if>

                        </xsl:attribute>

<!-- sascxr: Build the library object that goes with this schema -->
                        <xsl:element name="UsedByPackages">
                                <xsl:element name="SASLibrary">
                                        <xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute>
                                        <xsl:attribute name="Engine"><xsl:value-of select="$engine"/></xsl:attribute>
                                        <xsl:attribute name="IsDBMSLibname">1</xsl:attribute>
                                        <!--  remove any special characters (or at least the list I could think of) and make it 8 or less chars-->
                                        <xsl:attribute name="Libref"><xsl:value-of select="substring(translate(@name,' ~!@#$%^&amp;*()-+={}[];:&lt;&gt;?/\|,.',''),1,8)"/></xsl:attribute>
                                        <xsl:element name="DeployedComponents">
                             <xsl:element name="{$apptype}">
                                                <xsl:attribute name="ObjRef"><xsl:value-of select="$appid"/></xsl:attribute>
                                     </xsl:element>
                                        </xsl:element>
                                        <xsl:element name="LibraryConnection">
                                                        <xsl:element name="{$conntype}">
                                                                <xsl:attribute name="ObjRef"><xsl:value-of select="$connid"/></xsl:attribute>
                                                        </xsl:element>
                                        </xsl:element>
                                </xsl:element>
                        </xsl:element>
                        <xsl:element name="DeployedComponents">
                                <xsl:element name="ServerComponent">
                                        <xsl:attribute name="ObjRef"><xsl:value-of select="$dbid"/></xsl:attribute>
                                </xsl:element>
                        </xsl:element>

<!-- sascxr: end -->
                        <xsl:element name="Tables">
                                         <xsl:for-each select="CWM:Namespace.ownedElement/CWMRDB:Table|CWM:Namespace.ownedElement/CWMRDB:View">
                                                <xsl:element name="PhysicalTable">
                                                        <xsl:attribute name="Objref">$<xsl:value-of select="@xmi.id"/></xsl:attribute>
                                                </xsl:element>
                                        </xsl:for-each>
                        </xsl:element>

                        </xsl:element>

</xsl:template>

<!--  ****************************************** -->
<!--  Template for a SHAREData                   -->
<!--  ****************************************** -->
<xsl:template name="SHAREData">
<xsl:element name="SASLibrary">


       <xsl:attribute name="Name"><xsl:value-of select="$createremote"/></xsl:attribute>
       <xsl:attribute name="Engine">REMOTE</xsl:attribute>
       <xsl:attribute name="IsDBMSLibname">0</xsl:attribute>
       <!--  remove any special characters (or at least the list I could think of) and make it 8 or less chars-->
       <xsl:attribute name="Libref"><xsl:value-of select="$createremote"/></xsl:attribute>
       <!--  we are not going to ask for or create a link to a SAS app for the SHARE case
             in the future we may want to have the ability to select 0..n SAS apps
       <xsl:element name="DeployedComponents">
               <xsl:element name="{$apptype}">
                      <xsl:attribute name="ObjRef"><xsl:value-of select="$appid"/></xsl:attribute>
               </xsl:element>
       </xsl:element>
       -->
       <xsl:element name="LibraryConnection">
             <xsl:element name="{$conntype}">
                  <xsl:attribute name="ObjRef"><xsl:value-of select="$connid"/></xsl:attribute>
             </xsl:element>
       </xsl:element>
       <xsl:element name="UsingPackages">
             <xsl:element name="SASLibrary">
                  <xsl:attribute name="Objref"><xsl:value-of select="$libid"/></xsl:attribute>
             </xsl:element>
       </xsl:element>

</xsl:element>

</xsl:template>

<!--  This template no longer used.  The pre-defined library objref is added to each table definition since -->
<!--  the server will not accept an objref as a top level object in the add request.                        -->
<!--  ****************************************** -->
<!--  Template for a SASData                    -->
<!--  ****************************************** -->
<xsl:template name="SASData">

      <xsl:element name="SASLibrary">
          <xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute>
          <xsl:attribute name="Engine"><xsl:value-of select="$engine"/></xsl:attribute>
          <xsl:attribute name="IsDBMSLibname">1</xsl:attribute>
          <!--  remove any special characters (or at least the list I could think of) and make it 8 or less chars-->
          <xsl:attribute name="Libref"><xsl:value-of select="substring(translate(@name,' ~!@#$%^&amp;*()-+={}[];:&lt;&gt;?/\|,.',''),1,8)"/></xsl:attribute>

          <xsl:element name="DeployedComponents">
             <xsl:element name="{$apptype}">
                   <xsl:attribute name="ObjRef"><xsl:value-of select="$appid"/></xsl:attribute>
             </xsl:element>
          </xsl:element>

          <xsl:element name="Tables">
               <xsl:for-each select="CWM:Namespace.ownedElement/CWMRDB:Table|CWM:Namespace.ownedElement/CWMRDB:View">
                   <xsl:element name="PhysicalTable">
                       <xsl:attribute name="Objref">$<xsl:value-of select="@xmi.id"/></xsl:attribute>
                   </xsl:element>
               </xsl:for-each>
         </xsl:element>
     </xsl:element>

</xsl:template>

<!--  ****************************************** -->
<!--  Template for a Table                       -->
<!--  ****************************************** -->

<xsl:template match="//CWMRDB:BaseTable|//CWMRDB:Table">

   <xsl:element name="PhysicalTable">

<!-- This should be the value of the Id attribute (@xmi.id)but I am using Name so it will be easier to merge :sascxr -->
<!-- We can't use only the table name because the name is not guarenteed to be unique within the doucment and the symbolic reference must be unique -->
                                                <xsl:attribute name="Id">$<xsl:value-of select="@xmi.id"/></xsl:attribute>
      <!-- name could be an attribute or it could be stored in an element: ejm-->
      <xsl:if test="./CWM:ModelElement.name">
           <xsl:attribute name="Name"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
           <xsl:attribute name="TableName"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
           <xsl:attribute name="SASTableName"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="@name">
         <xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute>
         <xsl:attribute name="TableName"><xsl:value-of select="@name"/></xsl:attribute>
         <xsl:attribute name="SASTableName"><xsl:value-of select="@name"/></xsl:attribute>
      </xsl:if>
      <xsl:attribute name="Desc">
           <!-- S0169793:  Description is processed twice.      -->
           <!-- I only need to look for the indexed description -->
           <!--
                 <xsl:if test="CWM:Namespace.ownedElement/CWM:Description">
                    <xsl:value-of select="CWM:Namespace.ownedElement/CWM:Description/@body"/>
                 </xsl:if>
              -->
            <!-- or search for a description -->
            <xsl:if test="(key('notes',@xmi.id))">
               <xsl:value-of select="key('notes',@xmi.id)/@body"/>
            </xsl:if>
      </xsl:attribute>
      <!-- <xsl:attribute name="SASTableName"><xsl:value-of select="@name"/></xsl:attribute> -->

      <xsl:attribute name="MemberType">DATA</xsl:attribute>

        <xsl:choose>

        <xsl:when test="$engine='DB2'">
               <xsl:attribute name="DBMSType"><xsl:value-of select="$engine"/></xsl:attribute>
        </xsl:when>
        <xsl:when test="$engine='SQLSVR'">
               <xsl:attribute name="DBMSType">SQLServer</xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
               <xsl:attribute name="DBMSType"><xsl:value-of select="$engine"/></xsl:attribute>
        </xsl:otherwise>

        </xsl:choose>

        <xsl:if test="$treeid != ''">

        <xsl:element name="Trees">
        <xsl:element name="Tree">
        <xsl:attribute name="ObjRef"><xsl:value-of select="$treeid"/></xsl:attribute>
        </xsl:element>

        </xsl:element>

        </xsl:if>

        <!-- if the type is SHARE or SAS then a pre-defined library for the tables has been supplied -->
        <!-- If it is DBMS, a new Schema object was created to contain the tables.                   -->
        <xsl:if test="$importType = 'SAS' ">
             <xsl:element name="TablePackage">
                <xsl:element name="{$schematype}">
                   <xsl:attribute name="Objref"><xsl:value-of select="$libid"/></xsl:attribute>
                </xsl:element>
             </xsl:element>
        </xsl:if>
        <xsl:if test="$importType = 'SHARE' ">
             <xsl:element name="TablePackage">
                <xsl:element name="{$schematype}">  <!-- could be saslibrary or databaseschema -->
                   <xsl:attribute name="Objref"><xsl:value-of select="$schemaid"/></xsl:attribute>
                </xsl:element>
             </xsl:element>
        </xsl:if>


      <xsl:element name="Columns">
         <xsl:apply-templates select="CWM:Classifier.feature/CWMRDB:Column"/>
      </xsl:element>

       <!--lets take a look at keys -->
       <xsl:element name="UniqueKeys">
             <xsl:apply-templates select="CWM:Namespace.ownedElement/CWMRDB:PrimaryKey|CWM:Namespace.ownedElement/CWMRDB:UniqueConstraint" />
       </xsl:element>
       <xsl:element name="ForeignKeys">
             <xsl:apply-templates select="CWM:Namespace.ownedElement/CWMRDB:ForeignKey" />
       </xsl:element>

   <!--   elmcin: 07Nov2002 S0168839: Add properties for DBMS special char to tables -->
   <xsl:call-template name="tblProps"/>

   </xsl:element>

</xsl:template>

<!--  ****************************************** -->
<!--  Template for a View                        -->
<!--  ****************************************** -->

<xsl:template match="//CWMRDB:View">

   <xsl:element name="PhysicalTable">

<!--- This should be the value of the Id attribute (@xmi.id)but I am using Name so it will be easier to merge  -->

      <xsl:attribute name="Id">$<xsl:value-of select="@xmi.id"/></xsl:attribute>

      <!-- name could be an attribute or it could be stored in an element: ejm-->
      <xsl:if test="./CWM:ModelElement.name">
           <xsl:attribute name="Name"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
           <xsl:attribute name="TableName"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="@name">
         <xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute>
         <xsl:attribute name="TableName"><xsl:value-of select="@name"/></xsl:attribute>
      </xsl:if>

      <xsl:attribute name="Desc">
               <xsl:if test="(key('notes',@xmi.id))">
                     <xsl:value-of select="key('notes',@xmi.id)/@body"/>
               </xsl:if>
      </xsl:attribute>
      <xsl:attribute name="MemberType">VIEW</xsl:attribute>
      <xsl:attribute name="TableName"><xsl:value-of select="@name"/></xsl:attribute>
      <!--  S0170101:  SASTableName not included on views -->
      <xsl:attribute name="SASTableName"><xsl:value-of select="@name"/></xsl:attribute>

        <!-- S0180432: views are not imported into the library, but need to be -->
        <!-- if the type is SHARE or SAS then a pre-defined library for the tables has been supplied -->
        <!-- If it is DBMS, a new Schema object was created to contain the tables.                   -->
        <xsl:if test="$importType = 'SAS' ">
             <xsl:element name="TablePackage">
                <xsl:element name="{$schematype}">
                   <xsl:attribute name="Objref"><xsl:value-of select="$libid"/></xsl:attribute>
                </xsl:element>
             </xsl:element>
        </xsl:if>
        <xsl:if test="$importType = 'SHARE' ">
             <xsl:element name="TablePackage">
                <xsl:element name="{$schematype}">  <!-- could be saslibrary or databaseschema -->
                   <xsl:attribute name="Objref"><xsl:value-of select="$schemaid"/></xsl:attribute>
                </xsl:element>
             </xsl:element>
        </xsl:if>



      <xsl:element name="Columns">
         <xsl:apply-templates select="CWM:Classifier.feature/CWMRDB:Column"/>
      </xsl:element>

      <!--   elmcin: 07Nov2002 S0168839: Add properties for DBMS special char to tables -->
      <xsl:call-template name="tblProps"/>


   </xsl:element>

</xsl:template>

<!--  ****************************************** -->
<!--  Template for SpecChar and Case properties  -->
<!--  ****************************************** -->
<xsl:template name="tblProps">
     <xsl:element name="PropertySets">
         <xsl:element name="PropertySet">
              <xsl:attribute name="Name">DBMSNames</xsl:attribute>
              <xsl:attribute name="SetRole">DBMSNames</xsl:attribute>
            <xsl:element name="Properties">
              <xsl:element name="Property">
                  <xsl:attribute name="Name">Case</xsl:attribute>
                  <xsl:attribute name="UseValueOnly">1</xsl:attribute>
                  <xsl:attribute name="PropertyName">Case</xsl:attribute>
                  <xsl:attribute name="DefaultValue"><xsl:value-of select="$case"/></xsl:attribute>
                  <xsl:element name="OwningType">
                      <xsl:element name="PropertyType">
                            <xsl:attribute name="Objref">$caseType</xsl:attribute>
                      </xsl:element>
                  </xsl:element>
              </xsl:element>
              <xsl:element name="Property">
                  <xsl:attribute name="Name">SpecChar</xsl:attribute>
                  <xsl:attribute name="UseValueOnly">1</xsl:attribute>
                  <xsl:attribute name="PropertyName">SpecChar</xsl:attribute>
                  <xsl:attribute name="DefaultValue"><xsl:value-of select="$specchar"/></xsl:attribute>
                  <xsl:element name="OwningType">
                      <xsl:element name="PropertyType">
                            <xsl:attribute name="Objref">$speccharType</xsl:attribute>
                      </xsl:element>
                  </xsl:element>
              </xsl:element>
            </xsl:element> <!-- setProperties -->
         </xsl:element>
     </xsl:element>
</xsl:template>


<!--  ****************************************** -->
<!--  Template for a Column                      -->
<!--  ****************************************** -->

<xsl:template match="CWMRDB:Column">

   <xsl:element name="Column">

<!--- This should be the value of the Id attribute (@xmi.id)but I am using Name so it will be easier to merge  -->
         <!-- adding xmi.id to the Id to make sure column names are unique ejm-->
         <xsl:attribute name="Id">$<xsl:value-of select="@xmi.id"/></xsl:attribute>

         <xsl:if test="./CWM:ModelElement.name">
              <xsl:attribute name="Name"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
              <xsl:attribute name="SASColumnName"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
              <xsl:attribute name="ColumnName"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
         </xsl:if>
         <xsl:if test="@name">
              <xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute>
              <xsl:attribute name="SASColumnName"><xsl:value-of select="@name"/></xsl:attribute>
              <xsl:attribute name="ColumnName"><xsl:value-of select="@name"/></xsl:attribute>
       </xsl:if>


         <xsl:attribute name="Desc">
            <!--  S0170491: locating column description -->
            <xsl:if test="(key('notes',@xmi.id))">

                <xsl:variable name="v_text">
                     <xsl:value-of select="key('notes',@xmi.id)/@body"/>
                </xsl:variable>

                <xsl:variable name="v_hasLabel">
                     <xsl:choose>
                        <xsl:when test="contains($v_text,'label=')">Y</xsl:when>
                        <xsl:otherwise>N</xsl:otherwise>
                     </xsl:choose>
                </xsl:variable>

                <xsl:if test="$v_hasLabel='Y'">
                   <xsl:value-of select="substring-after($v_text,'label=')"/>
                </xsl:if>

                <xsl:if test="$v_hasLabel='N'">
                   <xsl:value-of select="$v_text"/>
                </xsl:if>
            </xsl:if>
         </xsl:attribute>

         <xsl:attribute name="IsNullable">
             <xsl:choose>
                <xsl:when test="@isNullable='columnNullable'">1</xsl:when>
                <xsl:otherwise>0</xsl:otherwise>
             </xsl:choose>
         </xsl:attribute>


         <!--  Need to look up the type information -->
         <xsl:variable name="type" select="@type" />
         <xsl:if test="@length">
             <xsl:attribute name="ColumnLength"><xsl:value-of select="@length"/></xsl:attribute>
             <xsl:attribute name="SASColumnLength"><xsl:value-of select="@length"/></xsl:attribute>
         </xsl:if>
         <xsl:variable name="blength">
              <xsl:choose>
                 <xsl:when test="@length">0</xsl:when>
                 <xsl:otherwise>1</xsl:otherwise>
              </xsl:choose>
         </xsl:variable>

        <xsl:apply-templates select="key('dataType',$type)">
            <xsl:with-param name="findlength" select="$blength"/>

            <!-- Convert name to uppercase -->
            <xsl:with-param name="v_colname" select="translate(@name,
                                            'abcdefghijklmnopqrstuvwxyz',
                                            'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
            <xsl:with-param name="v_sasformat" select="@SASFormat"/>
            <xsl:with-param name="v_length" select="@length"/>
        </xsl:apply-templates>
    </xsl:element>

</xsl:template>

<!--  **************************************************************** -->
<!--  Template for a SQLDistinctType | CWMRDB:SQLSimpleType            -->
<!--  **************************************************************** -->

<xsl:template match="CWMRDB:SQLDistinctType|CWMRDB:SQLSimpleType">

   <!-- this param informs us if we should check the data type for the length -->
   <xsl:param name="findlength" />
   <xsl:param name="v_colname" />
   <xsl:param name="v_sasformat" />
   <xsl:param name="v_length" />

   <!-- the typeNumber should match a standard SQL type -->

   <xsl:variable name="type" select="@typeNumber"/>

      <xsl:attribute name="ColumnType"><xsl:value-of select="@typeNumber"/></xsl:attribute>

         <xsl:variable name="v_columntype">
             <xsl:choose>
                <!-- these are the standard SQL types that I know are character data, there are probably more -->
                <xsl:when test="$type=-1 or $type=-4 or $type=-3 or $type=-2 or $type=-1 or $type=1 or $type=12">C</xsl:when>
                <xsl:otherwise>N</xsl:otherwise>
             </xsl:choose>
         </xsl:variable>

         <xsl:variable name="v_sas">
             <xsl:choose>
                <xsl:when test="$importType='SAS'">Y</xsl:when>
                <xsl:otherwise>N</xsl:otherwise>
             </xsl:choose>
         </xsl:variable>


   <!-- Character Type Fields -->
   <!-- if columntype -->
   <xsl:if test="$v_columntype='C'">

      <xsl:attribute name="SASColumnType">C</xsl:attribute>

      <!-- Formats if SAS DBMS -->
      <!-- if SAS -->
      <xsl:if test="$v_sas='Y'">
         <xsl:choose>
             <xsl:when test="string-length($v_sasformat)>0">
                <xsl:attribute name="SASFormat"><xsl:value-of select="$v_sasformat"/></xsl:attribute>
             </xsl:when>
             <xsl:otherwise>
             </xsl:otherwise>
         </xsl:choose>
      </xsl:if>
      <!-- if SAS -->


      <!-- Formats if non SAS DBMS -->
      <xsl:if test="$v_sas='N'">
         <xsl:if test="string-length($v_sasformat)>0">
            <xsl:attribute name="SASFormat"><xsl:value-of select="$v_sasformat"/></xsl:attribute>
         </xsl:if>
      </xsl:if>

      <!-- sometimes the column length is found in the dataType, check for it here if requested -->
      <!-- Character field lengths for SAS DBMS -->
      <xsl:if test="$v_sas='Y'">
         <xsl:choose>
            <xsl:when test="@characterMaximumLength &gt; 0 and @characterMaximumLength &lt; 32769">
                <xsl:attribute name="ColumnLength"><xsl:value-of select="@characterMaximumLength"/></xsl:attribute>
                <xsl:attribute name="SASColumnLength"><xsl:value-of select="@characterMaximumLength"/></xsl:attribute>
            </xsl:when>
            <xsl:when test= "$v_length &gt; 0 and $v_length &lt; 32769">
                <xsl:attribute name="ColumnLength"><xsl:value-of select="$v_length"/></xsl:attribute>
                <xsl:attribute name="SASColumnLength"><xsl:value-of select="$v_length"/></xsl:attribute>
            </xsl:when>
            <xsl:when test= "$v_length &gt; 32768 or @characterMaximumLength &gt; 32768">
                <xsl:attribute name="ColumnLength">32768</xsl:attribute>
                <xsl:attribute name="SASColumnLength">32768</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="ColumnLength">255</xsl:attribute>
                <xsl:attribute name="SASColumnLength">255</xsl:attribute>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:if>

      <!-- Character field lengths for non SAS DBMS -->
      <xsl:if test="$v_sas='N'">

           <xsl:choose>
              <xsl:when test="@characterMaximumLength &gt; 0 ">
                 <xsl:attribute name="ColumnLength"><xsl:value-of select="@characterMaximumLength"/></xsl:attribute>
                 <xsl:attribute name="SASColumnLength"><xsl:value-of select="@characterMaximumLength"/></xsl:attribute>
              </xsl:when>
              <xsl:when test= "$v_length &gt; 0 ">
                 <xsl:attribute name="ColumnLength"><xsl:value-of select="$v_length"/></xsl:attribute>
                 <xsl:attribute name="SASColumnLength"><xsl:value-of select="$v_length"/></xsl:attribute>
              </xsl:when>
              <xsl:otherwise>
                 <xsl:attribute name="ColumnLength">255</xsl:attribute>
                 <xsl:attribute name="SASColumnLength">255</xsl:attribute>
              </xsl:otherwise>
           </xsl:choose>
      </xsl:if>

   </xsl:if>
   <!-- if columntype -->
   <!-- Numeric Type Fields -->
      <xsl:if test="$v_columntype='N'">

      <xsl:attribute name="SASColumnType">N</xsl:attribute>

      <!-- Formats if non SAS DBMS -->
      <xsl:if test="$v_sas='N'">
         <xsl:if test="string-length($v_sasformat)>0">
            <xsl:attribute name="SASFormat"><xsl:value-of select="$v_sasformat"/></xsl:attribute>
         </xsl:if>
      </xsl:if>
      <!-- Formats if SAS DBMS, based on Column Names (colname). Can be dangerous. Consider making this a parameter sdksvh-->
      <!--   Commented out, because formats are good for SAS and non SAS DBMS xsl:if test="$v_sas='Y'" -->
         <xsl:choose>
            <xsl:when test="string-length($v_sasformat)>0">
                  <xsl:attribute name="SASFormat"><xsl:value-of select="$v_sasformat"/></xsl:attribute>
            </xsl:when>
            <xsl:when test="$type = 6">
                <xsl:attribute name="SASFormat">COMMA22.2</xsl:attribute>
            </xsl:when>
            <xsl:when test="substring($v_colname, string-length($v_colname) - string-length('_DATE')+1) = '_DATE'">
                  <xsl:attribute name="SASFormat">NLDATE21.</xsl:attribute>
            </xsl:when>
            <xsl:when test="substring($v_colname, string-length($v_colname) - string-length('_DT')+1) = '_DT'">
                  <xsl:attribute name="SASFormat">NLDATE21.</xsl:attribute>
            </xsl:when>
            <xsl:when test="substring($v_colname, string-length($v_colname) - string-length('_DTTM')+1) = '_DTTM'">
                  <xsl:attribute name="SASFormat">NLDATM30.</xsl:attribute>
            </xsl:when>
            <xsl:when test="substring($v_colname, string-length($v_colname) - string-length('_AMT')+1) = '_AMT'">
                  <xsl:attribute name="SASFormat">DOLLAR22.2</xsl:attribute>
            </xsl:when>
            <xsl:when test="substring($v_colname, string-length($v_colname) - string-length('_ID')+1) = '_ID'">
                  <xsl:attribute name="SASFormat">BEST15.</xsl:attribute>
            </xsl:when>
            <xsl:when test="substring($v_colname, string-length($v_colname) - string-length('_RK')+1) = '_RK'">
                  <xsl:attribute name="SASFormat">15.</xsl:attribute>
            </xsl:when>
            <xsl:when test="$type = 91">
                  <xsl:attribute name="SASFormat">NLDATE21.</xsl:attribute>
            </xsl:when>
            <xsl:when test="$type = 92">
                  <xsl:attribute name="SASFormat">NLTIME20.</xsl:attribute>
            </xsl:when>
            <xsl:when test="$type = 93">
                  <xsl:attribute name="SASFormat">NLDATM30.</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                  <xsl:attribute name="SASFormat">BEST15.</xsl:attribute>
            </xsl:otherwise>
         </xsl:choose>
      <!-- END: Apply formats for both SAS and non SAS /xsl:if    -->

      <xsl:if test="$findlength='1'">

         <!-- Numeric field lengths for SAS DBMS -->
         <xsl:if test="$v_sas='Y'">
            <xsl:choose>
               <xsl:when test="@numericPrecision &gt; 2 and @numericPrecision &lt; 9">
                  <xsl:attribute name="ColumnLength"><xsl:value-of select="@numericPrecision"/></xsl:attribute>
                  <xsl:attribute name="SASColumnLength"><xsl:value-of select="@numericPrecision"/></xsl:attribute>
               </xsl:when>
               <xsl:when test="@precision &gt; 2 and @precision &lt; 9">
                  <xsl:attribute name="ColumnLength"><xsl:value-of select="@precision"/></xsl:attribute>
                  <xsl:attribute name="SASColumnLength"><xsl:value-of select="@precision"/></xsl:attribute>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:attribute name="ColumnLength">8</xsl:attribute>
                  <xsl:attribute name="SASColumnLength">8</xsl:attribute>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:if>


         <!-- Numeric field lengths for non SAS DBMS -->
         <xsl:if test="$v_sas='N'">
            <!-- Numeric Lengths for non-SAS databases -->
            <xsl:choose>
               <xsl:when test="@numericPrecision">
                  <xsl:attribute name="ColumnLength"><xsl:value-of select="@numericPrecision"/></xsl:attribute>
                  <xsl:attribute name="SASColumnLength"><xsl:value-of select="@numericPrecision"/></xsl:attribute>
               </xsl:when>
               <xsl:when test="@precision">
                  <xsl:attribute name="ColumnLength"><xsl:value-of select="@precision"/></xsl:attribute>
                  <xsl:attribute name="SASColumnLength"><xsl:value-of select="@precision"/></xsl:attribute>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:attribute name="ColumnLength">8</xsl:attribute>
                  <xsl:attribute name="SASColumnLength">8</xsl:attribute>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:if>
         <!-- BEGIN: Code to get right Lengths for Numeric fields nomatter if it is SAS or non SAS DBMS (vekada + sdksvh) -->
         <!-- DECIMAL=3, NUMERIC=2  -->
         <xsl:if test="$type=2 or $type=3">
           <xsl:choose>
              <xsl:when test="@precision &gt; 13">
                 <xsl:attribute name="ColumnLength">8</xsl:attribute>
                 <xsl:attribute name="SASColumnLength">8</xsl:attribute>
              </xsl:when>
              <xsl:when test="@precision &gt; 11">
                 <xsl:attribute name="ColumnLength">7</xsl:attribute>
                 <xsl:attribute name="SASColumnLength">7</xsl:attribute>
              </xsl:when>
              <xsl:when test="@precision &gt; 8">
                 <xsl:attribute name="ColumnLength">6</xsl:attribute>
                 <xsl:attribute name="SASColumnLength">6</xsl:attribute>
              </xsl:when>
              <xsl:when test="@precision &gt; 6">
                 <xsl:attribute name="ColumnLength">5</xsl:attribute>
                 <xsl:attribute name="SASColumnLength">5</xsl:attribute>
              </xsl:when>
              <xsl:when test="@precision &gt; 3">
                 <xsl:attribute name="ColumnLength">4</xsl:attribute>
                 <xsl:attribute name="SASColumnLength">4</xsl:attribute>
              </xsl:when>
              <xsl:when test="@precision &gt; 1">
                 <xsl:attribute name="ColumnLength">3</xsl:attribute>
                 <xsl:attribute name="SASColumnLength">3</xsl:attribute>
              </xsl:when>
              <xsl:otherwise>
                 <xsl:attribute name="ColumnLength">8</xsl:attribute>
                 <xsl:attribute name="SASColumnLength">8</xsl:attribute>
              </xsl:otherwise>
           </xsl:choose>
         </xsl:if>
         <!-- Reset Length if Scale is more than 0 -->
         <xsl:choose>
           <xsl:when test="@scale &gt; 0">
              <xsl:attribute name="ColumnLength">8</xsl:attribute>
              <xsl:attribute name="SASColumnLength">8</xsl:attribute>
              <xsl:attribute name="SASFormat">
                 <!-- This is how to concatenate precision.scale getting a SASFormat like 10.2 -->
                 <xsl:value-of select="@precision"/>.<xsl:value-of select="@scale"/>
              </xsl:attribute>
           </xsl:when>
         </xsl:choose>
         <!-- TINYINT -128 to 127  -->
         <xsl:if test="$type=-6">
            <xsl:attribute name="ColumnLength">3</xsl:attribute>
            <xsl:attribute name="SASColumnLength">3</xsl:attribute>
         </xsl:if>
         <!-- BIGINT  -->
         <xsl:if test="$type=-5">
            <xsl:attribute name="ColumnLength">8</xsl:attribute>
            <xsl:attribute name="SASColumnLength">8</xsl:attribute>
         </xsl:if>
         <!-- FLOAT=6, REAL=7, DOUBLE=8  -->
         <xsl:if test="$type=6 or $type=7 or $type=8">
            <xsl:attribute name="ColumnLength">8</xsl:attribute>
            <xsl:attribute name="SASColumnLength">8</xsl:attribute>
         </xsl:if>
         <!-- INTEGER  -->
         <xsl:if test="$type=4">
            <xsl:attribute name="ColumnLength">6</xsl:attribute>
            <xsl:attribute name="SASColumnLength">6</xsl:attribute>
         </xsl:if>
         <!-- SMALLINT  -->
         <xsl:if test="$type=5">
            <xsl:attribute name="ColumnLength">4</xsl:attribute>
            <xsl:attribute name="SASColumnLength">4</xsl:attribute>
         </xsl:if>
         <!-- DATE  -->
         <xsl:if test="$type=91">
            <xsl:attribute name="ColumnLength">5</xsl:attribute>
            <xsl:attribute name="SASColumnLength">5</xsl:attribute>
         </xsl:if>
         <!-- TIME  for Integer 4 is enough eg. 582:32:32 but since time normally has scale use 8-->
         <xsl:if test="$type=92">
            <xsl:attribute name="ColumnLength">8</xsl:attribute>
            <xsl:attribute name="SASColumnLength">8</xsl:attribute>
         </xsl:if>
         <!-- TIMESTAMP  -->
         <xsl:if test="$type=93">
            <xsl:attribute name="ColumnLength">8</xsl:attribute>
            <xsl:attribute name="SASColumnLength">8</xsl:attribute>
         </xsl:if>
         <!-- END: Code to get right Lengths  -->

      </xsl:if> <!-- END: findlength -->
   </xsl:if>
   <!-- END: if columntype = Numeric Type Fields -->


</xsl:template>


<!--  **************************************************************** -->
<!--  Template for a  CWM:Namespace.ownedElement/CWMRDB:PrimaryKey     -->
<!--  **************************************************************** -->
<xsl:template match="CWM:Namespace.ownedElement/CWMRDB:PrimaryKey|CWM:Namespace.ownedElement/CWMRDB:UniqueConstraint">

   <xsl:element name="UniqueKey">
         <xsl:attribute name="Id">$<xsl:value-of select="@xmi.id"/></xsl:attribute>
         <!-- <xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute> -->
         <xsl:call-template name="getNameAttribute"/>

         <!-- If this is a primary key, set the IsPrimary attribute, otherwise set it to zero -->
         <xsl:choose>
              <xsl:when test="name(.)='CWMRDB:PrimaryKey'">
                   <xsl:attribute name="IsPrimary">1</xsl:attribute>
              </xsl:when>
              <xsl:otherwise>
                   <xsl:attribute name="IsPrimary">0</xsl:attribute>
              </xsl:otherwise>
         </xsl:choose>
         <xsl:element name="KeyedColumns">
              <xsl:if test="@feature">
                  <!-- feature could contain one or more columns -->
                  <xsl:call-template name="feature">
                      <xsl:with-param name="featurelist" select="@feature"/>
                  </xsl:call-template>
              </xsl:if>
              <xsl:apply-templates select="CWM:UniqueKey.feature/*" />
         </xsl:element>
    </xsl:element>

</xsl:template>

<!--  **************************************************************** -->
<!--  Template for feature, there could be multiple idrefs             -->
<!--  **************************************************************** -->

<xsl:template name="feature">

          <xsl:param name="featurelist"/>

                        <xsl:variable name="nlist" select="concat(normalize-space($featurelist),' ')"/>
                        <xsl:variable name="first" select="substring-before($nlist,' ')"/>
                        <xsl:variable name="rest" select="substring-after($nlist,' ')"/>
                                <xsl:element name="Column">
        <xsl:variable name="objid" select="$first"      />
        <xsl:attribute name="Objref">$<xsl:value-of select="key('columns',$objid)/@xmi.id"/></xsl:attribute>
    </xsl:element>
                                <xsl:if test="$rest">
                                    <xsl:call-template name="feature">
                                                                     <xsl:with-param name="featurelist" select="$rest"/>
                                                                </xsl:call-template>
                                </xsl:if>

        </xsl:template>

<!--  **************************************************************** -->
<!--  Template for a  CWM:UniqueKey.feature/CWMRDB:Column              -->
<!--  **************************************************************** -->

<xsl:template match="CWM:UniqueKey.feature/CWMRDB:Column|CWM:ForeignKey.feature/CWMRDB:Column|CWM:UniqueKey.feature/CWM:StructuralFeature">

   <xsl:element name="Column">
        <xsl:variable name="objid" select="@xmi.idref"  />
        <xsl:attribute name="Objref">$<xsl:value-of select="key('columns',$objid)/@xmi.id"/>
        </xsl:attribute>
          <!-- xsl:value-of select="@xmi.idref"/ -->
   </xsl:element>

</xsl:template>

<!--  **************************************************************** -->
<!--  Template for getNameAttribute                                    -->
<!--  **************************************************************** -->
<xsl:template name="getNameAttribute">

           <xsl:if test="./CWM:ModelElement.name">
                <xsl:attribute name="Name"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
           </xsl:if>
           <xsl:if test="@name">
                <xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute>
           </xsl:if>


</xsl:template>

<!--  **************************************************************** -->
<!--  Template for a  CWM:Namespace.ownedElement/CWMRDB:ForeignKey     -->
<!--  **************************************************************** -->

<xsl:template match="CWM:Namespace.ownedElement/CWMRDB:ForeignKey">
   <xsl:element name="ForeignKey">
        <xsl:attribute name="Id">$<xsl:value-of select="@xmi.id"/></xsl:attribute>
        <xsl:call-template name="getNameAttribute"/>
        <!--<xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute>-->
        <xsl:if test="@uniqueKey">
           <xsl:element name="PartnerUniqueKey">
                <xsl:element name="UniqueKey">
                    <xsl:attribute name="Objref">$<xsl:value-of select="@uniqueKey"/></xsl:attribute>
                    <!--<xsl:call-template name="getNameAttribute"/>-->

                 </xsl:element>
            </xsl:element>
         </xsl:if>
         <xsl:if test="./CWM:KeyRelationship.uniqueKey">
               <xsl:element name="PartnerUniqueKey">
                  <xsl:for-each select="./CWM:KeyRelationship.uniqueKey/CWM:UniqueKey">
                  <xsl:element name="UniqueKey">
                     <xsl:attribute name="Objref">$<xsl:value-of select="@xmi.idref"/></xsl:attribute>
                  </xsl:element>  <!-- UniqueKey -->
                  </xsl:for-each>
               </xsl:element> <!-- PartnerUniqueKey -->
            <!-- <xsl:element name="UniqueKey">
                  <xsl:attribute name="Objref">$<xsl:value-of select="./CWM:KeyRelationship.uniqueKey/CWM:uniqueKey[@xmi.idref]"/></xsl:attribute>
             </xsl:element>
             -->

         </xsl:if>
         <xsl:element name="KeyedColumns">
            <xsl:if test="@feature">
                 <xsl:call-template name="feature">
                     <xsl:with-param name="featurelist" select="@feature"/>
                  </xsl:call-template>
             </xsl:if>
             <!--assuming here that if they use @feature they will not use this element -->
             <xsl:for-each select="CWM:ForeignKey.feature/CWMRDB:Column|CWM:KeyRelationship.feature/CWM:StructuralFeature">
                    <xsl:element name="Column">
                          <xsl:variable name="objid" select="@xmi.idref"       />
                          <xsl:attribute name="Objref">$<xsl:value-of select="key('columns',$objid)/@xmi.id"/></xsl:attribute>
                          <xsl:attribute name="SASColumnName">$<xsl:value-of select="key('columns',$objid)/@xmi.id"/></xsl:attribute>
                    </xsl:element>
             </xsl:for-each>
          </xsl:element>
          <xsl:element name="KeyAssociations">
                 <!-- we need a KeyAssociation for each column in the key -->
                 <!-- we are not sure if they will be listed in @feature or under the ForeignKey.feature element -->

                 <xsl:if test="@feature">
                      <xsl:element name="KeyAssociation">
                            <!-- <xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute> -->
                            <xsl:attribute name="Id">$_<xsl:value-of select="generate-id()"/></xsl:attribute>
                            <xsl:call-template name="getNameAttribute"/>
                            <xsl:element name="ForeignKeyColumn">
                                  <xsl:element name="Column">
                                        <xsl:if test="@feature">
                                            <xsl:variable name="objid" select="@feature"    />
                                            <xsl:attribute name="Objref">$<xsl:value-of select="key('columns',$objid)/@xmi.id"/></xsl:attribute>
                                            <!-- xsl:value-of select="@feature"/ -->
                                        </xsl:if>
                                   </xsl:element>       <!-- Column -->
                              </xsl:element>                                       <!-- ForeignKeyColumn -->
                              <xsl:element name="UniqueKeyColumn">
                                   <!-- here we reference the uniqueKey and then get the column -->
                                   <xsl:apply-templates select="key('uniqueKeys',@uniqueKey)" mode="keyAssoc" />
                              </xsl:element> <!-- UniqueKeyColumn -->
                        </xsl:element> <!-- KeyAssociation -->
                    </xsl:if>
                    <!-- assuming again that @feature and ForeignKey.feature are exclusive -->
                    <!-- still have not addressed a set of idrefs -->
                    <xsl:variable name="uk">
                       <xsl:if test="@uniqueKey">
                           <xsl:value-of select="@uniqueKey" />
                       </xsl:if>
                       <xsl:for-each select="./CWM:KeyRelationship.uniqueKey/CWM:UniqueKey">
                           <xsl:value-of select="@xmi.idref" />
                       </xsl:for-each>
                    </xsl:variable>
                    <xsl:for-each select="CWM:ForeignKey.feature/CWMRDB:Column|CWM:KeyRelationship.feature/CWM:StructuralFeature">
                              <!-- <xsl:param name="colOffset"><xsl:value-of select="position()"/></xsl:param> -->
                              <xsl:element name="KeyAssociation">
                                      <xsl:attribute name="Id">$_<xsl:value-of select="generate-id()"/></xsl:attribute>
                                      <xsl:attribute name="Name">unnamed<xsl:value-of select="@xmi.idref"/></xsl:attribute>
                                      <xsl:element name="ForeignKeyColumn">
                                         <xsl:element name="Column">
                                               <xsl:variable name="objid" select="@xmi.idref"  />
                                               <xsl:attribute name="Objref">$<xsl:value-of select="key('columns',$objid)/@xmi.id"/></xsl:attribute>
                                                 <!-- xsl:value-of select="@xmi.idref"/ -->
                                          </xsl:element> <!-- Column -->
                                       </xsl:element>               <!-- ForeignKeyColumn -->
                                       <!-- now we need the corresponding uniqueKey -->
                                       <xsl:element name="UniqueKeyColumn">
                                              <xsl:variable name="offset" select="position()"/>
                                              <xsl:apply-templates select="key('uniqueKeys',$uk)" mode="keyAssocs">
                                                  <xsl:with-param name="colOffset" select="$offset" />
                                              </xsl:apply-templates>
                                        </xsl:element> <!-- UniqueKeyColumn -->
                             </xsl:element>          <!-- KeyAssociation -->
                    </xsl:for-each>
              </xsl:element> <!-- KeyAssociations -->
      </xsl:element>          <!-- ForeignKey -->
</xsl:template>

<!--  ********************************************************************* -->
<!--  Template for //CWMRDB:UniqueKey|//CWMRDB:PrimaryKey  mode="keyAssoc"  -->
<!--  ********************************************************************* -->
<xsl:template match="//CWMRDB:UniqueKey|//CWMRDB:PrimaryKey|//CWMRDB:UniqueConstraint" mode="keyAssoc">

      <xsl:if test="@feature">
            <xsl:element name="Column">
               <xsl:variable name="objid" select="@feature"    />
               <xsl:attribute name="Objref">$<xsl:value-of select="key('columns',$objid)/@xmi.id"/></xsl:attribute>
               <!-- xsl:value-of select="@feature"/ -->
            </xsl:element>
      </xsl:if>


</xsl:template>

<!--  ********************************************************************* -->
<!--  Template for //CWMRDB:UniqueKey|//CWMRDB:PrimaryKey  mode="keyAssocs" -->
<!--  ********************************************************************* -->
<xsl:template match="//CWMRDB:PrimaryKey|//CWMRDB:UniqueKey|//CWMRDB:UniqueConstraint" mode="keyAssocs" >
                                        <xsl:param name="colOffset"/>
       <xsl:apply-templates select="CWM:UniqueKey.feature/CWMRDB:Column[$colOffset]|CWM:UniqueKey.feature/CWM:StructuralFeature[$colOffset]" mode="col" />
</xsl:template>

<!--  ********************************************************************* -->
<!--  Template for CWM:UniqueKey.feature/CWMRDB:Column  mode="col"          -->
<!--  ********************************************************************* -->
<xsl:template match="CWM:UniqueKey.feature/CWMRDB:Column|CWM:UniqueKey.feature/CWM:StructuralFeature" mode="col" >
             <xsl:element name="Column">
<xsl:variable name="objid" select="@xmi.idref"  />
<xsl:attribute name="Objref">$<xsl:value-of select="key('columns',$objid)/@xmi.id"/></xsl:attribute>

<!-- xsl:value-of select="@xmi.idref" /-->
                                                </xsl:element>
</xsl:template>

<!--  ********************************************************************* -->
<!--  Template for CWMRDB:SQLIndex                                             -->
<!--  ********************************************************************* -->
<xsl:template match="CWMRDB:SQLIndex" >
   <xsl:element name="Index">
        <xsl:attribute name="Id">$<xsl:value-of select="@xmi.id"/></xsl:attribute>

            <xsl:if test="./CWM:ModelElement.name">
                 <xsl:attribute name="Name"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
                 <xsl:attribute name="IndexName"><xsl:value-of select="./CWM:ModelElement.name"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="@name">
                 <xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute>
                 <xsl:attribute name="IndexName"><xsl:value-of select="@name"/></xsl:attribute>
          </xsl:if>

            <xsl:if test="@isUnique='true'">
                        <xsl:attribute name="IsUnique">1</xsl:attribute>
                  </xsl:if>
           <xsl:element name="OwningPhysicalTable">
                <xsl:element name="PhysicalTable">
                    <xsl:variable name="objid">
                        <xsl:if test="@spannedClass">
                            <xsl:value-of select="@spannedClass"/>
                        </xsl:if>
                        <xsl:for-each select="./CWM:Index.spannedClass/CWM:Class">
                             <xsl:value-of select="@xmi.idref"/>
                        </xsl:for-each>
                     </xsl:variable>
                    <xsl:attribute name="Objref">$<xsl:value-of select="key('tables',$objid)/@xmi.id"/></xsl:attribute>

                     <!-- xsl:value-of select="@spannedClass"/ -->
                </xsl:element>  <!-- PhysicalTable -->
            </xsl:element>  <!-- OwningPhysicalTable -->
           <xsl:element name="Columns">
             <xsl:for-each select="CWM:Index.indexedFeature/CWMRDB:SQLIndexColumn">
                  <xsl:element name="Column">
                    <xsl:variable name="objid">
                        <xsl:if test="@feature">
                            <xsl:value-of select="@feature"/>
                        </xsl:if>
                        <xsl:for-each select="./CWM:IndexedFeature.feature/CWM:StructuralFeature">
                             <xsl:value-of select="@xmi.idref"/>
                        </xsl:for-each>
                    </xsl:variable>
                    <xsl:attribute name="Objref">$<xsl:value-of select="key('columns',$objid)/@xmi.id"/></xsl:attribute>

                    <!-- xsl:value-of select="@feature"/ -->
                  </xsl:element> <!-- Column -->
             </xsl:for-each>
           </xsl:element> <!-- Columns -->
    </xsl:element> <!-- Index -->

</xsl:template>


<xsl:template match="*">
<!--
<xsl:element name="Skipped">
<xsl:attribute name="type"><xsl:value-of select="name(.)"/></xsl:attribute>
</xsl:element>

-->

</xsl:template>
</xsl:stylesheet>