<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
<xsl:output method="html" encoding="UTF-8" omit-xml-declaration="yes"/>

<xsl:param name="file">this file</xsl:param>
<xsl:param name="date">na</xsl:param>


<!--  ****************************************** -->
<!--  Template Main                              -->
<!--  ****************************************** -->
<xsl:template match="/">

  <html>
    <head>
       <title>Metadata Deployment</title>
     </head>
   <body>
   <h1>Metadata Deployment</h1>
   <xsl:if test="not($date='na')">
       <h3><xsl:value-of select="$date"/></h3>
   </xsl:if>

  <xsl:apply-templates select="//Metadata/Objects"/>
  <!-- <xsl:apply-templates select="//Metadata/Connections"/> -->
   </body>

 </html>

</xsl:template>

<!--  ****************************************** -->
<!--  Template //Metadata/Objects                -->
<!--  ****************************************** -->
<xsl:template match="//Metadata/Objects">

  <p>The deployment of <xsl:value-of select="$file"/> added
  <xsl:value-of select="count(*)"/> new items to the target repository. </p>

  <lh>The following items were added:</lh>
  <xsl:apply-templates select="*"/>

</xsl:template>

<!--  ****************************************** -->
<!--  Template *: to list children               -->
<!--  ****************************************** -->
<xsl:template match="*">

   <li><xsl:value-of select="@ExtractTemplate"/>:<xsl:value-of select="@Name"/></li>


</xsl:template>

<!--  ****************************************** -->
<!--  Template //Metadata/Connections            -->
<!--  ****************************************** -->
<xsl:template match="//Metadata/Connections">

  <p/>
  <lh>The following connections were made:</lh>

  <xsl:call-template name="connection"/>

</xsl:template>

<!--  ****************************************** -->
<!--  Named Template - connection                -->
<!--  ****************************************** -->
<xsl:template name="connection">

  <xsl:for-each select="*">
     <li><xsl:value-of select="name()"/>:<xsl:value-of select="@Name"/></li>


  </xsl:for-each>

</xsl:template>




</xsl:stylesheet>