<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
    <xsl:output method="html" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"/>
    <xsl:template match="/">
        <xsl:param name="mybreak"><![CDATA[<br/>]]></xsl:param>
        <html xmlns="http://www.w3.org/1999/xhtml">
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>                
            <head>
                <title>
                    <xsl:value-of select="Log/@Name"/>
                </title>
                <style type="text/css">
                    body{
                        font-size:100%;
                    }
                    p{
                        font-family:"Lucida Console", "Courier New", "Monospace";
                    }
                    p.TypeMainHeader{
                        font-size:2.0em;
                    }
                    p.TypeHeader{
                        font-size:1.5em;
                        font-weight:bold;
                    }
                    p.TypeFooter{
                        font-size:1.5em;
                    }</style>
            </head>
            <body>
                <h1>@@LogReportToken.reportheading.txt@@ <xsl:value-of select="Log/@Name"/></h1>
                <h2>@@LogReportToken.reportdate.txt@@ <xsl:value-of select="Log/@CreatedDate"/></h2>
                <h2>@@LogReportToken.reportowner.txt@@ <xsl:value-of select="Log/@Owner"/>&nbsp;&nbsp;&nbsp;@@LogReportToken.reportapplication.txt@@
                        <xsl:value-of select="Log/@Application"/></h2>
                <xsl:for-each select="Log/Classifier"><br/><h2><xsl:value-of select="@Name"/></h2>
                    <xsl:for-each select="LogItem">
                        <xsl:choose>
                            <xsl:when test="Properties/Property[@Value='enumeration']"><xsl:value-of select="."/><xsl:value-of select="$mybreak" disable-output-escaping="yes"/></xsl:when>
                            <xsl:otherwise>
                                        <xsl:value-of select="@Date"/>&nbsp; <xsl:choose>
                                            <xsl:when test="@Priority=0"> @@LogReportToken.reportlevelfatal.txt@@ </xsl:when>
                                            <xsl:when test="@Priority &lt;= 100"> @@LogReportToken.reportlevelerror.txt@@ </xsl:when>
                                            <xsl:when test="@Priority &lt;= 200"> @@LogReportToken.reportlevelwarn.txt@@ </xsl:when>
                                            <xsl:when test="@Priority &lt;= 400"> @@LogReportToken.reportlevelinfo.txt@@ </xsl:when>
                                            <xsl:otherwise> @@LogReportToken.reportLeveldebug.txt@@ </xsl:otherwise>
                                        </xsl:choose>
                                        <xsl:for-each select="Properties/Property">
                                            <xsl:value-of select="@Name"/>=<xsl:value-of
                                                select="@Value"/>&nbsp; </xsl:for-each>
                                        <xsl:value-of select="."/><xsl:value-of select="$mybreak" disable-output-escaping="yes"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </xsl:for-each>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
