<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
<xsl:output
   method="xml"
   omit-xml-declaration="no"
   encoding="utf-8"
   standalone="yes" />

<!-- Build document structure and static content -->

<xsl:template match="/">

<!--     Build Wrapper -->

<xsl:apply-templates select="*"/>

</xsl:template>

<!-- For the elements in the xml that correspond to parameters, just copy the element and it's value -->

<xsl:template match="ReposId">
<xsl:copy><xsl:value-of select="."/></xsl:copy>
</xsl:template>

<xsl:template match="Type">
<xsl:copy><xsl:value-of select="."/></xsl:copy>
</xsl:template>

<!--  For a UsingComponents element, just keep the references to objects, not the whole thing -->

<xsl:template match="UsingComponents">
<xsl:copy>
<xsl:for-each select="*">

<xsl:copy>
<xsl:attribute name="Id"><xsl:value-of select="@Id"/></xsl:attribute>
</xsl:copy>

</xsl:for-each>
</xsl:copy>

</xsl:template>

<!--  For each attribute, just copy it -->

<xsl:template match="@*">
<xsl:copy/>
</xsl:template>

<!-- For each element, copy it, all of it's attributes and and all of it's subelements -->

<xsl:template match="*">

<xsl:copy>

<xsl:apply-templates select="@*"/>

<xsl:apply-templates select="*"/>

</xsl:copy>

</xsl:template>

</xsl:stylesheet>