//RES3UNIX JOB (XXXXX),'Your Name',NOTIFY=,TIME=2
//*
//*--------------------------------------------------------------------
//* Restore of the pax archive directly from tape
//* with the owning userid (uid) and group (gid)
//* being set to that of the submitter of this job.
//*
//* Change these 3 'SET' statements
//*--------------------------------------------------------------------
//*
//  SET TAPEUNIT='3590-1'             <== 3590B unit or estoeric
//  SET PAXSCRPT='/tmp/pax_tape.sh'   <== pax restore script location
//  SET  MOUNTPT='/usr/lpp/SAS/SAS93' <== Location of SAS USS install
//*
//*--------------------------------------------------------------------
//* Do not change these 'SET' statements
//*--------------------------------------------------------------------
//*
//  SET  TAPEVOL='000000'             <== Tape volser from SAS
//  SET  TAPEDS3='SAS.V000000.PAX'    <== Tape dataset name for pax
//*
//*===================================================================*
//* Create Script to restore the pax file from tape (or disk)         *
//*===================================================================*
//GENER    EXEC PGM=IEBGENER
//SYSPRINT DD SYSOUT=*
//SYSIN    DD DUMMY
//SYSUT1   DD *
#!/bin/sh
mkdir -p $1
if [ ! -d "$1" ]; then
  echo "$1 directory does not exist - exiting"
  exit 10
fi
cd $1
/bin/pax -pp -x os390 -rvf //DD:PAXIN  .
/*
//SYSUT2   DD PATHOPTS=(OWRONLY,OCREAT),FILEDATA=TEXT,
//            PATHMODE=(SIRUSR,SIWUSR,SIXUSR),
//            PATH='&PAXSCRPT'
//*
//*===================================================================*
//* Execute script to restore the pax file from tape (or disk)        *
//*===================================================================*
//PAXTAPE  EXEC PGM=BPXBATCH,DYNAMNBR=20,COND=(0,NE),
//         PARM='PGM &PAXSCRPT &MOUNTPT'
//*
//PAXIN    DD DSN=&TAPEDS3,
//            UNIT=&TAPEUNIT,
//            LABEL=(3,SL,EXPDT=98000),
//            VOL=SER=&TAPEVOL,
//            DISP=OLD
//STDOUT   DD SYSOUT=*
//STDERR   DD SYSOUT=*
//STDENV   DD *
_BPX_SHAREAS=YES
/*
//*
//*===================================================================*
//* Delete the pax restore shell script                               *
//*===================================================================*
//DELSCRPT EXEC PGM=BPXBATCH,DYNAMNBR=20,COND=(0,NE),
//         PARM='SH rm -rf &PAXSCRPT'
//*
//
