//RES2CZFS JOB (XXXXX),'Your Name',NOTIFY=,TIME=2
//*
//*--------------------------------------------------------------------
//* Allocate a zFS dataset and format in compatibility mode to hold the
//* UNIX filesystem for the SAS image.
//*
//* Change the 4 'SET' statements
//* Change the zFS dataset name -zFS- in the:
//*  - NAME keyword in the SYSIN to IDCAMS (step ALLOCZFS)
//*  - FILESYSTEM keyword in the SYSTSIN to IKJEFT01 (step MOUNTZFS)
//* Change the Volume assignment -VOLSER- in the:
//*  - VOLSER keyword in the SYSIN to IDCAMS (step ALLOCZFS)
//* Change the mount point -mountpoint- in the:
//*  - MOUNTPOINT keyword in the SYSTSIN to IKJEFT01 (step MOUNTZFS)
//*--------------------------------------------------------------------
//*
//  SET      ZFS='-HLQ-.ZFS'          <== Dataset name of the zFS
//  SET       SU='BPXROOT'            <== UserID with UID=0 authority
//  SET SASADMIN='sasadm'             <== UserID owning the filesystem
//  SET  MOUNTPT='/usr/lpp/SAS/SAS93' <== Location of SAS USS install
//*
//*
//*--------------------------------------------------------------------
//* Allocate the ZFS filesystem.
//*--------------------------------------------------------------------
//ALLOCZFS EXEC PGM=IDCAMS
//SYSPRINT DD SYSOUT=*
//SYSUDUMP DD SYSOUT=*
//AMSDUMP  DD SYSOUT=*
//SYSIN    DD     *
  DEFINE CLUSTER (NAME(-zFS-) VOLUME(-VOLSER-)                        -
         LINEAR CYL(4000 50) SHAREOPTIONS(2))
/*
//*
//*--------------------------------------------------------------------
//* Format the ZFS filesystem.
//*--------------------------------------------------------------------
//FORMAT   EXEC PGM=IOEAGFMT,REGION=0M,COND=(0,NE),
//         PARM=('-aggregate &ZFS -compat -owner &SASADMIN')
//SYSPRINT DD SYSOUT=*
//STDOUT   DD SYSOUT=*
//STDERR   DD SYSOUT=*
//SYSUDUMP DD SYSOUT=*
//CEEDUMP  DD SYSOUT=*
//*
//*--------------------------------------------------------------------
//* Create the mount point for the new zFS
//*--------------------------------------------------------------------
//MKDIR    EXEC PGM=BPXBATCH,DYNAMNBR=20,COND=(0,NE),
//         PARM='SH mkdir &MOUNTPT'
//STDOUT   DD SYSOUT=*
//*
//*--------------------------------------------------------------------
//* Set the permissions for the new zFS to prevent write access
//*--------------------------------------------------------------------
//CHMOD    EXEC PGM=BPXBATCH,DYNAMNBR=20,COND=(0,NE),
//         PARM='SH chmod 777 &MOUNTPT'
//STDOUT   DD SYSOUT=*
//*
//*
//*--------------------------------------------------------------------
//* Set the ownership to superuser
//*--------------------------------------------------------------------
//CHOWN    EXEC PGM=BPXBATCH,DYNAMNBR=20,COND=(0,NE),
//         PARM='SH chown &SU &MOUNTPT'
//STDOUT   DD SYSOUT=*
//*
//*--------------------------------------------------------------------
//* Mount the filesystem.
//*--------------------------------------------------------------------
//MOUNTZFS EXEC PGM=IKJEFT01,REGION=4096K,COND=(0,NE)
//SYSTSPRT DD SYSOUT=*,DCB=(RECFM=VA,LRECL=125)
//SYSPRINT DD SYSOUT=*,DCB=(RECFM=VA,LRECL=125)
//SYSUDUMP DD SYSOUT=*,DCB=(RECFM=VA,LRECL=125)
//SYSTSIN  DD *
 MOUNT FILESYSTEM('-zFS-')                             +
   TYPE(ZFS) MODE(RDWR)                                +
   MOUNTPOINT('-mountpoint-')
/*
//
