/* connect 'SharedServices.fdb' ; */

/* ----------------------------------------------------------------------- */
/* SAS_KEYGEN */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_KEYGEN
(
    IDENTIFIER_CD VARCHAR(60) NOT NULL,
    KEY_CNT BIGINT NOT NULL,
    PRIMARY KEY (IDENTIFIER_CD)
);

/* ----------------------------------------------------------------------- */
/* SAS_ALERT */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_ALERT
(
    ALERT_ID BIGINT NOT NULL,
    EVENT_NM VARCHAR(100) NOT NULL,
    SUBSCRIBER_NM VARCHAR(60) NOT NULL,
    SUBSCRIBER_TYPE_CD SMALLINT DEFAULT 0 NOT NULL,
    DELIVERY_TYPE_CD SMALLINT NOT NULL,
    ACTIVE_STATE_FLG SMALLINT DEFAULT 1 NOT NULL,
    ALERT_NM VARCHAR(100) NOT NULL,
    SRC_COMPONENT VARCHAR(60) NOT NULL,
    SRC_DIRECTIVE VARCHAR(60),
    SRC_PARMS VARCHAR(255),
    TARGET_DIRECTIVE VARCHAR(60),
    TARGET_PARMS VARCHAR(255),
    TARGET_URL VARCHAR(255),
    REGISTRATION_TYPE_CD SMALLINT DEFAULT 0 NOT NULL,
    HOLD_INTERVAL BIGINT DEFAULT 0 NOT NULL,
    CREATED_DTTM TIMESTAMP,
    UPDATED_DTTM TIMESTAMP,
    PRIMARY KEY (ALERT_ID)
);

CREATE INDEX SAS_ALERT_IX01 ON SAS_ALERT (SUBSCRIBER_NM);

/* ----------------------------------------------------------------------- */
/* SAS_ALERT_CONDITION */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_ALERT_CONDITION
(
    ALERT_ID BIGINT NOT NULL,
    ATTRIBUTE_NM VARCHAR(200) NOT NULL,
    OPERATOR_CD SMALLINT NOT NULL,
    VALUE_TXT VARCHAR(255) NOT NULL,
    TYPE_CD SMALLINT NOT NULL
);

CREATE INDEX SAS_ALERT_CONDITION_IX01 ON SAS_ALERT_CONDITION (ALERT_ID);

/* ----------------------------------------------------------------------- */
/* SAS_ALERT_NOTIFICATION */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_ALERT_NOTIFICATION
(
    ALERT_NOTIFICATION_ID BIGINT NOT NULL,
    RECIPIENT_NM VARCHAR(60) NOT NULL,
    ALERT_NOTIFICATION_NM VARCHAR(255) NOT NULL,
    ALERT_NOTIFICATION_DESC VARCHAR(255),
    ALERT_NOTIFICATION_TYPE_CD SMALLINT NOT NULL,
    EVENT_NM VARCHAR(100) NOT NULL,
    READ_FLG SMALLINT DEFAULT 0 NOT NULL,
    DELIVERY_TYPE_CD SMALLINT NOT NULL,
    TARGET_DIRECTIVE VARCHAR(60),
    TARGET_PARMS VARCHAR(255),
    TARGET_URL VARCHAR(255),
    SRC_ALERT_ID BIGINT,
    CREATED_DTTM TIMESTAMP,
    EXPIRATION_DTTM TIMESTAMP,
    PRIMARY KEY (ALERT_NOTIFICATION_ID)
);

/* ----------------------------------------------------------------------- */
/* SAS_ALERT_NOTIFICATION_TYPE */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_ALERT_NOTIFICATION_TYPE
(
    ALERT_NOTIFICATION_TYPE_CD SMALLINT NOT NULL,
    ALERT_NOTIFICATION_TYPE_NM VARCHAR(100) NOT NULL
);

/* ----------------------------------------------------------------------- */
/* SAS_ALERT_NOTIFICATION_HOLD */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_ALERT_NOTIFICATION_HOLD
(
    ALERT_ID BIGINT NOT NULL,
    NOTIFICATION_DTTM TIMESTAMP NOT NULL,
    PRIMARY KEY (ALERT_ID)
);

/* ----------------------------------------------------------------------- */
/* SAS_COMMENT */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_COMMENT
(
    COMMENT_ID BIGINT NOT NULL,
    OBJECT_TYPE_ID BIGINT NOT NULL,
    OBJECT_ID VARCHAR(36) NOT NULL,
    PARENT_ID BIGINT DEFAULT 0 NOT NULL,
    AUTHOR_ID VARCHAR(60) NOT NULL,
    SUBJECT_TXT VARCHAR(255) NOT NULL,
    COMMENT_TXT VARCHAR(32765) NOT NULL,
    CREATED_DTTM TIMESTAMP,
    RETIRED_DTTM TIMESTAMP,
    PRIMARY KEY (COMMENT_ID)
);

/* ----------------------------------------------------------------------- */
/* SAS_ATTACHMENT */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_ATTACHMENT
(
    ATTACHMENT_ID BIGINT NOT NULL,
    ATTACHMENT_NM VARCHAR(255) NOT NULL,
    ATTACHMENT_DESC VARCHAR(255),
    ATTACHMENT_TYPE_CD VARCHAR(255),
    DOC_TYPE_CD VARCHAR(255),
    OBJECT_ID VARCHAR(36) NOT NULL,
    OBJECT_TYPE_ID BIGINT NOT NULL,
    ATTACHMENT_PATH VARCHAR(255) NOT NULL,
    PRIMARY KEY (ATTACHMENT_ID)
);

/* ----------------------------------------------------------------------- */
/* SAS_AUDIT */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_AUDIT
(
    AUDIT_ID BIGINT NOT NULL,
    OBJECT_TYPE_ID BIGINT,
    OBJECT_ID VARCHAR(36),
    USER_ID VARCHAR(60) NOT NULL,
    ACTION_TYPE_ID BIGINT NOT NULL,
    ACTION_SUCCESS_FLG SMALLINT DEFAULT 1 NOT NULL,
    TIMESTAMP_DTTM TIMESTAMP NOT NULL,
    SESSION_ID VARCHAR(60),
    TRANSACTION_ID BIGINT,
    CORRELATION_ID VARCHAR(64),
    PRIMARY KEY (AUDIT_ID)
);

/* ----------------------------------------------------------------------- */
/* SAS_AUDIT_ENTRY */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_AUDIT_ENTRY
(
    AUDIT_ID BIGINT NOT NULL,
    PROPERTY_NM VARCHAR(60) NOT NULL,
    OLD_VALUE_TXT VARCHAR(32000),
    NEW_VALUE_TXT VARCHAR(32000) NOT NULL
);

/* ----------------------------------------------------------------------- */
/* SAS_ACTION_EXECUTOR */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_ACTION_EXECUTOR
(
    AUDIT_ID BIGINT NOT NULL,
    EXECUTOR_NM VARCHAR(60) NOT NULL,
    EXECUTOR_TYPE_NM VARCHAR(60),
    EXECUTOR_VERSION_NO VARCHAR(20)
);

/* ----------------------------------------------------------------------- */
/* SAS_TYPE_OBJECT */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_TYPE_OBJECT
(
    TYPE_OBJECT_ID BIGINT NOT NULL,
    TYPE_OBJECT_CD VARCHAR(60) NOT NULL,
    PRIMARY KEY (TYPE_OBJECT_CD)
);

/* ----------------------------------------------------------------------- */
/* SAS_TYPE_ACTION */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_TYPE_ACTION
(
    TYPE_ACTION_ID BIGINT NOT NULL,
    TYPE_ACTION_CD VARCHAR(60) NOT NULL,
    PRIMARY KEY (TYPE_ACTION_CD)
);

/* ----------------------------------------------------------------------- */
/* SAS_SCHEMA_INFO */
/* ----------------------------------------------------------------------- */

CREATE TABLE SAS_SCHEMA_INFO
(
    SCHEMA_VERSION_NO INTEGER NOT NULL
);

ALTER TABLE SAS_ALERT_CONDITION
    ADD CONSTRAINT SAS_ALERT_CONDITION_FK01 FOREIGN KEY (ALERT_ID) REFERENCES SAS_ALERT (ALERT_ID);

ALTER TABLE SAS_ALERT_NOTIFICATION_HOLD
    ADD CONSTRAINT SAS_ALERT_NOTIF_ATION_HOLD_FK01 FOREIGN KEY (ALERT_ID) REFERENCES SAS_ALERT (ALERT_ID);

ALTER TABLE SAS_AUDIT_ENTRY
    ADD CONSTRAINT SAS_AUDIT_ENTRY_FK01 FOREIGN KEY (AUDIT_ID) REFERENCES SAS_AUDIT (AUDIT_ID);

ALTER TABLE SAS_ACTION_EXECUTOR
    ADD CONSTRAINT SAS_ACTION_EXECUTOR_FK01 FOREIGN KEY (AUDIT_ID) REFERENCES SAS_AUDIT (AUDIT_ID);

