/*
 * ValidateAutoLoadFolderStructure
 *
 * Purpose: This macro validates that the folder structure under the ROOTDIR
 * 			specified contains sufficient content for autoload to function
 * 			properly.
 *
 * Params: 	ROOTDIR	The autoload root directory to check.
 *
 * Returns: The macro variable LASTSTEPRC will contain 0 if successful, and 1
 *			if there was a failure.
 *
 */
/* ############################################################################## */
/* Copyright (c) 2013-2025, SAS Institute Inc., Cary, NC, USA. All Rights Reserved. */
/* ############################################################################## */
%macro ValidateAutoLoadFolderStructure(ROOTDIR);

	%GLOBAL LASTSTEPRC;
	%LET LASTSTEPRC=0;

	%macro CheckFolderExistence(DIR);
	   %GLOBAL LASTSTEPRC;
		%IF ( %SYSFUNC(FILEEXIST("&DIR.")) eq 0 ) %THEN %DO;
			%msg( type=ERROR, msg=%str(&AL_PRODNAME. directory &DIR. does not exist.));
			%LET LASTSTEPRC=1;
			%return;
		%END;
	%mend;

	/* Validate folder existence */
	%LET LOGSDIR=&ROOTDIR.&OSSLASH.Logs;
	%LET APNDDIR=&ROOTDIR.&OSSLASH.Append;
	%LET UNLDDIR=&ROOTDIR.&OSSLASH.Unload;
	%LET FMTSDIR=&ROOTDIR.&OSSLASH.Formats;
	%CheckFolderExistence(&ROOTDIR.);
	%CheckFolderExistence(&LOGSDIR.);
	%CheckFolderExistence(&APNDDIR.);
	%CheckFolderExistence(&UNLDDIR.);
	/* Enable this validation to require formats dir */
	/* %CheckFolderExistence(&FMTSDIR.); */

%mend;
