/*
 * SetSASOptions
 *
 * Purpose: Establishes global SAS options to be used during the AutoLoad session.
 *
 */
/* ############################################################################## */
/* Copyright (c) 2013-2025, SAS Institute Inc., Cary, NC, USA. All Rights Reserved. */
/* ############################################################################## */
%macro SetSASOptions;

	/* --------- FORMATS --------- */

	%if (%sysfunc(libref(dbformat)) eq 0) %then %do;
		%let formatstable=work.formatslist;
		%GetTablesListFromLibrary(data=&formatstable., inlibref=dbformat, type=CATALOG, rename=YES);
	   	%let NOBS=%DataSetNumObs(&formatstable.);

		%if ( %eval(&NOBS.) > 0) %then %do;
			%setoption(off,notes);
			%let fmtsearchstring=;
			proc sql noprint;
			   	select fullref into :fmtsearchstring
			   	separated by '/LOCALE ' 
			   	from &formatstable. 
				order by LastModified desc;
			quit;
			%setoption(restore,notes);

			%let fmtsearchstring=&fmtsearchstring./LOCALE;
			option APPEND=(FMTSEARCH=(&fmtsearchstring.));
		%end;
	%end;

	%msg( msg=%str(FMTSEARCH=%SYSFUNC(getoption(FMTSEARCH))) );

	/* ------------------------- */

%mend;
