/*
 * NormalizeSASNamesInDataSet
 *
 * Purpose: Normalizes the content of a data set column so that the content conforms to 
 * 			the following rules:
 *			
 * Parms:
 *	DATA=		The data set name to process.
 *	COLUMN=		The input column to read.
 *	OUTCOLUMN=	The output column into which to place the normalized result.
 *
 * Results:	Adds OUTCOLUMN to the data set.  OUTCOLUMN contains the normalized version of
 *			COLUMN.
 */
/* ############################################################################## */
/* Copyright (c) 2013-2025, SAS Institute Inc., Cary, NC, USA. All Rights Reserved. */
/* ############################################################################## */
%macro normalizeSASNamesInDataSet( DATA=, COLUMN=filename, OUTCOLUMN=_normalname );

	%let DATA=%SUPERQ(DATA);

	/* First, create initial normalized name proposal */
	data &DATA.;
		drop _norm_len _norm_firstchar;
		length &OUTCOLUMN. $256;
		set &DATA.;

		_norm_len=klength(&COLUMN.);

		if (_norm_len>0) then do;
			/* Remove invalid characters */
			&OUTCOLUMN.=ktranslate(&COLUMN.,'___________', '/\*?<>|:-".');
			_norm_firstchar=ksubstr(&OUTCOLUMN.,1,1);
			/* Remove starting periods */
			do while ( (klength(&OUTCOLUMN.) > 0)  and
				 	  ((_norm_firstchar eq '.'      ) or
                       (_norm_firstchar eq ' '      )) );
				&OUTCOLUMN.=ksubstr(&OUTCOLUMN.,2);
				_norm_firstchar=ksubstr(&OUTCOLUMN.,1,1);
			end;
			/* Shorten to 32 characters */
			&OUTCOLUMN.=ksubstr(&OUTCOLUMN.,1,32);

		end;
	run;

%mend;
