/*
    Name: TimeStamp

    Purpose: Used to display a timestamp message in the log, using a standard format.

    Parameters:
		level=		Level associated with the timestamp.  Anything can be used here, but INFO
					is the default.  Other useful values are WARN, ERROR, EVENT, etc.
        msg         The message to store in the timestamp dataset.
        clear=      Clear the existing timestamp log before adding this message?  Defaults to NO.
        show=       Set to YES if the message should be shown to the user.  NO otherwise.  Defaults to NO.
 */
/* ############################################################################## */
/* Copyright (c) 2013-2025, SAS Institute Inc., Cary, NC, USA. All Rights Reserved. */
/* ############################################################################## */
%macro TimeStamp( msg, level=INFO, clear=NO, show=NO );

	%LET MSG=%SUPERQ(MSG);
	/* Abort if log library is not assigned */
	%if (%sysfunc(libref(DBLOG)) ne 0) %then %return;

    %let show=%UPCASE(&show.);
    %SetOption(ON, nostimer);
    %SetOption(ON, nonotes);
    /* Now output an entry in the times data set to track date/time stamps */
    data &AL_LOGDATASET.;

    drop oldstamp;
    oldstamp=0;

    %if (%DataSetNumObs(&AL_LOGDATASET.) eq 0) or (%upcase(&clear.) eq YES) %then %do;
        attrib  
                date format=date9. label="Date"              /* i18nOK:Line */
                time format=timeampm. label="Time"              /* i18nOK:Line */
				level format=$8.          label="Level"                 /* i18nOK:EMS */
                desc format=$256.         label="Description"                 /* i18nOK:EMS */
                stamp format=datetime21.2 label="Date/Time"              /* i18nOK:Line */
                elapsed format=time11.2   label="Time Since Last Event"             /* i18nOK:Line */
                totaltime format=time11.2 label="Time Since Log Start";                 /* i18nOK:Line */

		level="&level.";				   /* i18nOK:EMS */
		desc="&msg.";                      /* i18nOK:EMS */
        stamp=datetime();
		date=date();
		time=time();
        elapsed=0;
        totaltime=0;
        output;
    %end;
    %else
        %do;
            set &AL_LOGDATASET. end=last;
            output;

            if last then do;
                oldstamp=stamp;
				level="&level.";		  /* i18nOK:EMS */
                desc="&msg.";             /* i18nOK:EMS */
                stamp=datetime();
				date=date();
				time=time();
                elapsed=stamp-oldstamp;
                totaltime=totaltime+elapsed;
                output;
            end;
        %end;
    run;
    %SetOption(RESTORE, nostimer);
    %SetOption(RESTORE, nonotes);
    %if %str(&show.) eq %str(YES) %then %do;
        %PUT %str(&msg.);
    %end;
%mend;
