/*
 * GetLoadedLASRTablesList
 * 
 * Purpose: Takes information needed to assign a LASR library, and returns the list of
 *			LASR tables loaded in that library.
 *
 * Parms:
 * 		data= The output data set to create.  If unspecified, defaults to work.loadedtables.
 *      libref= The libref to assign for the library.  Defaults to TMPLASR.
 *		host= The LASR Server Host
 *      port= The LASR Server Port
 *		tag= The LASR Server tag
 *		signer= The signer URL
 */
/* ############################################################################## */
/* Copyright (c) 2013-2025, SAS Institute Inc., Cary, NC, USA. All Rights Reserved. */
/* ############################################################################## */
%macro GetLoadedLASRTablesList	( data=WORK.loadedtables, libref=TMPLASR, host=, port=, tag=WORK
								, signer=);

	%if ("&host." eq "" ) %then %do;
	   %put ERROR: Host name must be specified with HOST=;
	   %return;
	%end;

	%if ("&port." eq "" ) %then %do;
	   %put ERROR: Port must be specified with HOST=;
	   %return;
	%end;

	/* Assign LASR Library */
	libname &LIBREF. SASIOLA HOST="&HOST." PORT=&PORT. TAG="&TAG."

	%IF ("&SIGNER." ne "") %THEN %DO;
	   SIGNER="&SIGNER."
	%END;

	;

	/* Get Tables List */
	PROC DATASETS LIBRARY=&LIBREF. MEMTYPE=DATA noprint;
	quit;
/*NOPRINT */
%mend;
