/*
 * DataSetVarsToMacroVars
 * 
 * Purpose: Converts values of columns in a data set to macro variables values.
 *
 * Parms:
 * 		data= The data set library.tablename specfication.  Omitted library yields WORK.
 *		varlist= Optional list of columns to convert.  Omitted varlist yields all columns.
 *		prefix= Optional prefix to place on macro variable names.  Omitted prefix yields table name.
 *
 */
/* ############################################################################## */
/* Copyright (c) 2013-2025, SAS Institute Inc., Cary, NC, USA. All Rights Reserved. */
/* ############################################################################## */
%macro DataSetVarsToMacroVars(data=, varlist=, prefix=);

	/* Break apart data specification */
    %let dot=%index(&data.,.);
	%if ( &dot. eq 0 ) %then %do;
	   %let lib=WORK;
	   %let tbl=&data.;
	%end;
	%else %do;
	   %let lib=%scan(&data.,1,.);
	   %let tbl=%scan(&data.,2,.);
	%end;
	%let lib=%upcase(&lib.);
	%let tbl=%upcase(&tbl.);

	/* Generate full varlist if none specified */
	%if ( "&varlist." eq "" ) %then %do;
		proc sql noprint;

		select name into :varlist separated by ' '
			from sashelp.vcolumn
		where upcase(libname)="&lib." and upcase(memname) = "&tbl.";

		quit;
	%end;

	/* Use table name as prefix if no prefix specified */

	%if ("&prefix." eq "" ) %then %let prefix=%upcase(&tbl.)_;

	%if (%str(&varlist.) eq %str()) %then %do;
		%msg( type=ERROR, %str(No columns to load from &lib..&tbl..));
		%return;
	%end;

   /* Globalize vars */
   %LET pos=1;
   %let var=%SCAN(&varlist.,&pos.);
   %DO %WHILE ("&VAR." ne ""); 
      %global &PREFIX.&VAR.;
	  %let pos = %eval(&pos.+1);
      %let var=%SCAN(&varlist.,&pos.);
   %END;

	proc sql noprint;
	   select 

   /* List data set vars */
   %LET pos=1;
   %let var=%SCAN(&varlist.,&pos.);
   %DO %WHILE ("&VAR." ne "");
   	  %if (%eval(&pos.>1)) %then %do;
	     %str(,)
	  %end;
      %str(&VAR. )
	  %let pos = %eval(&pos.+1);
      %let var=%SCAN(&varlist.,&pos.);
   %END;

   into

   /* List macro vars */
   %LET pos=1;
   %let var=%SCAN(&varlist.,&pos.);
   %DO %WHILE ("&VAR." ne "");
   	  %if (%eval(&pos.>1)) %then %do;
	     %str(,)
	  %end;
      %str(:&PREFIX.&VAR.)
	  %let pos = %eval(&pos.+1);
      %let var=%SCAN(&varlist.,&pos.);
   %END;

   from &data.;

   quit;

   /* Output macros values created */
   %LET pos=1;
   %let var=%SCAN(&varlist.,&pos.);
   %DO %WHILE ("&VAR." ne "");
      %msg( type=OTHER, msg=%str(%kupcase(%ktrim(&PREFIX.&VAR.)) = %ktrim(&&&PREFIX.&VAR.)));
	  %let pos = %eval(&pos.+1);
      %let var=%SCAN(&varlist.,&pos.);
   %END;
%mend;
