/* ############################################################################## */
/* Copyright (c) 2013-2025, SAS Institute Inc., Cary, NC, USA. All Rights Reserved. */
/* ############################################################################## */
%macro LeftJoinByLastModified	( A=, B=, OUT=
								, ONA=name, 			ONB=name
								, WHEREA=LastModified, 	WHEREB=LastModified
								, SELECTINSERT=,		DROP= );

   	%let NOBSL=%DataSetNumObs(&A.);
   	%let NOBSR=%DataSetNumObs(&B.);

	create table &OUT. 
		%if ( %eval(&NOBSR.) > 0) %then %do;
			%IF ( "&DROP." ne "" ) %then %do;
				(DROP=&DROP.) 
			%end;
		%end;
		as 
	   	 
		%if ( "&SELECTINSERT." ne "" ) %then %do;
			select %UNQUOTE(&SELECTINSERT.), * 
		%end;
		%else %do;
			select *
		%end;
			 FROM	&A. as A
		LEFT JOIN 	&B. as B
		ON 
			lowcase(A.&ONA.) = lowcase(B.&ONB.)
		/* Only compare left and right via where if both have observations */
   		%if (%eval(&NOBSL. > 0) and %eval(&NOBSR. > 0)) %then %do;
 			WHERE (A.&WHEREA. > B.&WHEREB.)
	    %end;
   ;

%mend;

%macro BuildSyncTables;

	%GLOBAL AL_OPTION_ROS_ENABLED;
	%GLOBAL AL_FILESTOSYNC;
	%LET AL_FILESTOSYNC=0;

	%msg( type=NOTE, msg=%str(SCANNING INPUT FOLDERS));

	/* Retrieve list of import files in the autoload and append folders */
	%GetFilesListFromFolder(folder=%nrbquote(&AL_AUTOLOAD_DIR.), data=&ROOTFLLIST.);
	%NormalizeSASNamesInDataSet(data=&ROOTFLLIST., COLUMN=filename);

	/* Retrieve list of tables in the autoload folder */
	%GetTablesListFromLibrary(inlibref=db, data=&ROOTTBLIST., rename=YES);

	/* Retrieve list of tables in the autoload append folder */
	%GetFilesListFromFolder(folder=%nrbquote(&AL_AUTOLOAD_APPEND_DIR.), data=&APNDFLLIST.);
	%NormalizeSASNamesInDataSet(data=&APNDFLLIST., COLUMN=filename);

	%msg(msg=%str(Examining LASR tables to append));
	%msg(msg=%str(If no append tables are present, it is normal to receive a WARNING here.));
	%GetTablesListFromLibrary(inlibref=dbappend, data=&APNDTBLIST., rename=YES);

	/* Retrieve list of tables in the autoload unload folder */
	%GetFilesListFromFolder(folder=%nrbquote(&AL_AUTOLOAD_UNLOAD_DIR.), data=&UNLDFLLIST.);
	%NormalizeSASNamesInDataSet(data=&UNLDFLLIST., COLUMN=filename);

	%msg(msg=%str(Examining LASR tables to unload));
	%msg(msg=%str(If no unload tables are present, it is normal to receive a WARNING here.));
	%GetTablesListFromLibrary(inlibref=dbunload, data=&UNLDTBLIST., rename=YES);

	/* Build tables containing reload-on-start information if reload-on-start is enabled */
	%DeleteDataSetIfExists(data=&ROSLIBLIST.);
	%DeleteDataSetIfExists(data=&ROSLIBS.);
	%if ( %ISYES(AL_OPTION_ROS_ENABLED) ) %then %do;

		%msg(msg=%str(Examining LASR libraries to reload-on-start));

		/* Get all library names associated with LASR server */
		%GetLASRServerLibrariesList(data=&ROSLIBLIST., name=%str(%qktrim(&AL_SERVNAME.)));

		/* Filter only those libraries which are eligible for reload-on-start */
		%FilterReloadOnStartLibraries( data=&ROSLIBLIST., out=&ROSLIBS.);

		/* Cycle through reload-on-start libraries */
		%IF %SYMEXIST(ROSLIBRARIES) %THEN %DO; %SYMDEL ROSLIBRARIES; %END;
		options nonotes;
		proc sql noprint;
		   select libname
			into :ROSLIBRARIES separated by '|'
			from &ROSLIBS. 
			;
		quit;
		options notes;
		%if %SYMEXIST(ROSLIBRARIES) %THEN %DO;
			%put NOTE: SCANNING %nrbquote(&ROSLIBRARIES.);
			%let libpos=1;
			%let ROSLIB=%QSCAN(%nrbquote(&ROSLIBRARIES.),&libpos.,|);

			/* FOR EACH LASR RELOAD-ON-START LIBRARY FOUND */
		   	%DO %WHILE ("%nrbquote(&ROSLIB.)" ne "");
				%msg(msg=%str(SCANNING RELOAD-ON-START LIBRARY &ROSLIB.));

				%let THISROSMETA=WORK.METAROS&LIBPOS.;
				%let RSPREFIX=RS&LIBPOS._;

				/* Cleanup prior data sets, if any */
				%DeleteDataSetIfExists(data=&THISROSMETA.);	/* LASR library metadata */
				%DeleteDataSetIfExists(data=&ROSTBLLIST.&LIBPOS.); /* LASR tables metadata */
				%DeleteDataSetIfExists(data=&ROSLIST.&LIBPOS.); /* Reload-onstart tables list */

				/* Load the metadata for this reload-on-start LASR library */
				%LASRLibraryMetadataToDataSet(data=&THISROSMETA., name=%str(&ROSLIB.));
				%DataSetVarsToMacroVars(data=&THISROSMETA., prefix=&RSPREFIX.);

				/* Get all tables associated with this LASR library */
				%GetMetadataTablesList( data=&ROSTBLLIST.&LIBPOS., name=%str(&ROSLIB.), libref=&&&RSPREFIX.DPLIBREF. );

				/* Assign the data provider library so we can filter properly*/
			  	libname &&&RSPREFIX.DPLIBREF. &&&RSPREFIX.DPLIBENGINE. "&&&RSPREFIX.DPPATH.";

				/* Filter only those eligible to reload-on-start that also exist in the data provider library */
				%FilterReloadOnStartTables( data=&ROSTBLLIST.&LIBPOS., OUT=&ROSLIST.&LIBPOS.
		                                  , ros_lib_method=&&&RSPREFIX.ROS_METHOD., ros_lib_tabledefault=&&&RSPREFIX.ROS_TBLDEFAULT. );

				/* Clear the libref */
			  	libname &&&RSPREFIX.DPLIBREF. clear;

				%LET NOBS=%DataSetNumObs(&ROSLIST.&LIBPOS.);
   				%IF (%eval(&NOBS.>0)) %THEN %LET AL_FILESTOSYNC=1;

				%let LIBPOS=%eval(&libpos.+1);
				%let ROSLIB=%QSCAN(%nrbquote(&ROSLIBRARIES.),&libpos.,|);
			%END;
		%END;
		%IF (%eval(&AL_FILESTOSYNC.=0)) %THEN %LET AL_OPTION_ROS_ENABLED=NO;
	%end;

	/* Make sure there are files to synchronize */
	%LET NOBS=%DataSetNumObs(&ROOTFLLIST.);
   	%IF (%eval(&NOBS.>0)) %THEN %LET AL_FILESTOSYNC=1;
	%LET NOBS=%DataSetNumObs(&ROOTTBLIST.);
  	%IF (%eval(&NOBS.>0)) %THEN %LET AL_FILESTOSYNC=1;
	%LET NOBS=%DataSetNumObs(&APNDFLLIST.);
   	%IF (%eval(&NOBS.>0)) %THEN %LET AL_FILESTOSYNC=1;
	%LET NOBS=%DataSetNumObs(&APNDTBLIST.);
  	%IF (%eval(&NOBS.>0)) %THEN %LET AL_FILESTOSYNC=1;
	%LET NOBS=%DataSetNumObs(&UNLDFLLIST.);
   	%IF (%eval(&NOBS.>0)) %THEN %LET AL_FILESTOSYNC=1;
	%LET NOBS=%DataSetNumObs(&UNLDTBLIST.);
  	%IF (%eval(&NOBS.>0)) %THEN %LET AL_FILESTOSYNC=1;
	%LET NOBS=%DataSetNumObs(&ROSLIST.);
  	%IF (%eval(&NOBS.>0)) %THEN %LET AL_FILESTOSYNC=1;
 	%IF (&AL_FILESTOSYNC. eq 0) %THEN %RETURN;

	%msg(msg=%str(Examining loaded LASR tables));
	%msg(msg=%str(If no tables are loaded, it is normal to receive a WARNING here.));
	/* Retrieve list of loaded LASR tables */
	%AssignLASRLibrary	( libref=&AL_LIBREF.
						, host=&AL_LASRHOST., port=&AL_LASRPORT., tag=&AL_LIBTAG.
						, signer=&AL_SIGNER. );
	%GetTablesListFromLibrary(data=&LASRTBLIST., inlibref=&AL_LIBREF.);

	%msg(msg=%str(Building actions list));

	/* Build sync tables indicating actions to perform */
	%setoption(off,notes);

	/* First, remove any pre-existing sync tables */
	%DeleteDataSetIfExists(data=&IMPLIST.);
	%DeleteDataSetIfExists(data=&ADDLIST.);
	%DeleteDataSetIfExists(data=&UPDLIST.);
	%DeleteDataSetIfExists(data=&APNLIST.);
	%DeleteDataSetIfExists(data=&UNLLIST.);
	%DeleteDataSetIfExists(data=&UNKLIST.);

	/* If LASR Table List exists, compare */
	%if %sysfunc(exist(&LASRTBLIST.)) %then %do;
		proc sql noprint nowarn;

			/****** IMPORT FILES ******/

		   /* Files in ROOT folder newer than data set (import) */
			%LeftJoinByLastModified	( A=&ROOTFLLIST., B=&ROOTTBLIST., OUT=&IMPLIST.
									, ONA=_normalname, ONB=name
									, WHEREA=LastModified, 	WHEREB=LastModified
									, SELECTINSERT=%nrbquote("DBOUT" as outlib length=8),		DROP=%str(MemType Filesize Num) );

			/* Files in APPEND folder newer than data set (import append) */
			%LeftJoinByLastModified	( A=&APNDFLLIST., B=&APNDTBLIST., OUT=&IMPLIST._FIL
									, ONA=_normalname, ONB=name
									, WHEREA=LastModified, 	WHEREB=LastModified
									, SELECTINSERT=%nrbquote("DBAPPOUT" as outlib),		DROP=%str(MemType Filesize Num) );

		   /* If append import files are found, add them to import list */
		   %let NOBS=%DataSetNumObs(&IMPLIST._FIL);
		   %if (%eval(&NOBS. > 0)) %then %do;
		   		insert into &IMPLIST. select * from &IMPLIST._FIL;
		   %end;

		   /****** LOAD AND REFRESH TABLES ******/

			/* Tables on disk, but not in LASR (to add) */
			create table &ADDLIST. as
			 select * from &ROOTTBLIST. as A
			 LEFT OUTER JOIN &LASRTBLIST. as B
			 on A.name = B.name
			 WHERE missing(B.name);

			/* Tables already in LASR, but newer than LASR version (refresh) */
		   create table &UPDLIST. as 
		   	select * from &ROOTTBLIST. as A
			INNER JOIN &LASRTBLIST as B
			on A.name = B.name
		   %let NOBS=%DataSetNumObs(&ROOTTBLIST.);
		   %if (%eval(&NOBS. > 0)) %then %do;
		 	where (A.LastModified > B.MDATE)
		   %end;
		   ;
		   /****** APPEND TABLES ******/

		   /* Tables in LASR with an Append file present */
			%LeftJoinByLastModified	( A=&APNDTBLIST., B=&ROOTTBLIST., OUT=&APNLIST.
									, ONA=name, ONB=name
									, WHEREA=LastModified, 	WHEREB=LastModified );

		   /****** UNLOAD TABLES ******/

		   /* Tables in LASR and in unload folder (to unload) */
		   create table &UNLLIST. as 
		   	select * from &LASRTBLIST as A
			INNER JOIN &UNLDTBLIST. as B
			on A.name = B.name;

		   /* Tables in LASR with a file in the unload folder (to unload) */
			create table &UNLLIST._FIL as
			 select * from &LASRTBLIST. as A
			 INNER JOIN &UNLDFLLIST. (KEEP=_normalname) as B
			 on lowcase(A.name) = lowcase(B._normalname); 

		   /* If unload files are found, add them to unload list */
		   %let NOBS=%DataSetNumObs(&UNLLIST._FIL);
		   %if (%eval(&NOBS. > 0)) %then %do;
		   		data &UNLLIST.;
					set &UNLLIST. &UNLLIST._FIL; 
				run;
		   %end;

		quit;

	%end;
	/* Otherwise, all tables need to be loaded */
	%else %do;
		data &Addlist.;
			set &ROOTTBLIST.;
		run;
	%end;

	%setoption(restore,notes);
%mend;
