/* ############################################################################## */
/* Copyright (c) 2013-2025, SAS Institute Inc., Cary, NC, USA. All Rights Reserved. */
/* ############################################################################## */

%macro ActionSummaryPreview	( data=, msgfound=, msgmissing=, cols=name );

	%IF ("&data." eq "") %then return;

	%IF (%SYSFUNC(exist(&data.))) %THEN %DO;
		data _null_;
			if _n_=1 then do;
				if last then put "&msgmissing.";
				else put "&msgfound.";
			end;
			set &data. end=last;
			put @7 &cols.;
		run;
	%END;
	%ELSE %PUT &msgmissing.;
%mend;

%macro NormalizedNamePreview	( data=, msgfound=, msgmissing=BLANK, origcol=filename, normcol=_normalname );

	%IF ("&data." eq "") %then return;

	%LET NORMTEMP=work.tmp_normprev;

	%IF (%SYSFUNC(exist(&data.))) %THEN %DO;
		/* Select only the records that normalized the name */
		proc sql noprint nowarn;
			create table &NORMTEMP. as
			select * from &data.
			where ( &origcol. ne &normcol. );
		quit;

		/* Output any normalized names */
		data _null_;
			if _n_=1 then do;
			    if last then stop;
				else do;
					put / @3 "&msgfound." /;
					put @7 "SAS Table Name" @42 "Original File Name";
					put @7 "--------------" @42 "------------------";
				end;
			end;
			set &NORMTEMP. end=last;
			if last then put @7 &normcol. @42 &origcol. /;
			else		 put @7 &normcol. @42 &origcol. ;
		run;

		%DeleteDataSetIfExists( data=&NORMTEMP.);
	%END;
%mend;

%macro OutputHeader(msg);
	%let oldsetting=%sysfunc(getoption(notes));
	option notes;
	%put --------------------------------------------------------;
	%PUT NOTE: &MSG.;
	option &oldsetting.;
%mend;

%macro OutputSummary;
	%setoption(off,notes);

	/*** First, output input files and tables found ***/
	%OutputHeader(SCANNING &AL_AUTOLOAD_DIR.);
	%IF (%SYSFUNC(exist(&ROOTFLLIST.))) %THEN %DO;
		%ActionSummaryPreview	( data=&ROOTFLLIST.
								, msgfound=%STR(FILES:)
								, msgmissing=%STR(NO FILES)
								, cols=fullname
								);
		%NormalizedNamePreview	( data=&ROOTFLLIST.
								, msgfound=%STR(Adjusting filenames to valid SAS table names:)
								, origcol=filename
								, normcol=_normalname
								);
	%END;

	%IF (%SYSFUNC(exist(&ROOTTBLIST.))) %THEN %DO;
		%ActionSummaryPreview	( data=&ROOTTBLIST.
								, msgfound=%STR(TABLES:)
								, msgmissing=%STR(NO TABLES)
								);
	%END;

	%OutputHeader(SCANNING &AL_AUTOLOAD_APPEND_DIR.);
	%IF (%SYSFUNC(exist(&APNDFLLIST.))) %THEN %DO;
		%ActionSummaryPreview	( data=&APNDFLLIST.
								, msgfound=%STR(FILES:)
								, msgmissing=%STR(NO FILES)
								, cols=fullname
								);
		%NormalizedNamePreview	( data=&APNDFLLIST.
								, msgfound=%STR(Adjusting filenames to valid SAS table names:)
								, origcol=filename
								, normcol=_normalname
								);
	%END;

	%IF (%SYSFUNC(exist(&APNDTBLIST.))) %THEN %DO;
		%ActionSummaryPreview	( data=&APNDTBLIST.
								, msgfound=%STR(TABLES:)
								, msgmissing=%STR(NO TABLES)
								);
	%END;

	%OutputHeader(SCANNING &AL_AUTOLOAD_UNLOAD_DIR.);
	%IF (%SYSFUNC(exist(&UNLDFLLIST.))) %THEN %DO;
		%ActionSummaryPreview	( data=&UNLDFLLIST.
								, msgfound=%STR(FILES:)
								, msgmissing=%STR(NO FILES)
								, cols=fullname
								);
		%NormalizedNamePreview	( data=&UNLDFLLIST.
								, msgfound=%STR(Adjusting filenames to valid SAS table names:)
								, origcol=filename
								, normcol=_normalname
								);
	%END;

	%IF (%SYSFUNC(exist(&UNLDTBLIST.))) %THEN %DO;
		%ActionSummaryPreview	( data=&UNLDTBLIST.
								, msgfound=%STR(TABLES:)
								, msgmissing=%STR(NO TABLES)
								);
	%END;

	%OutputHeader( SCANNING LASR SERVER );
	%ActionSummaryPreview	( data=&LASRTBLIST.
							, msgfound=%STR(TABLES:)
							, msgmissing=%STR(NO LASR TABLES ARE CURRENTLY LOADED)
							);

	/*** Now list actual actions that will be performed ***/

	%IF (%ISYES(AL_OPTION_SYNC_IMPORT)) %THEN %DO;
		%OutputHeader(IMPORT);
		%ActionSummaryPreview	( data=&IMPLIST.
								, msgfound=%STR(FILES TO IMPORT:)
								, msgmissing=%STR(NO NEW FILES TO IMPORT)
								, cols=%str(filename)
								);
	%END;

	%IF (%ISYES(AL_OPTION_SYNC_LOAD)) %THEN %DO;
		%OutputHeader(LOAD);
		%ActionSummaryPreview	( data=&ADDLIST.
								, msgfound=%STR(TABLES TO LOAD:)
								, msgmissing=%STR(NO NEW TABLES TO LOAD TO LASR)
								);
	%END;

	%IF (%ISYES(AL_OPTION_SYNC_REFRESH)) %THEN %DO;
		%OutputHeader(REFRESH);
		%ActionSummaryPreview	( data=&UPDLIST.
								, msgfound=%STR(TABLES TO REFRESH:)
								, msgmissing=%STR(NO TABLES TO REFRESH IN LASR)
								);
	%END;

	%IF (%ISYES(AL_OPTION_SYNC_APPEND)) %THEN %DO;
		%OutputHeader(APPEND);
		%ActionSummaryPreview	( data=&APNLIST.
								, msgfound=%STR(TABLES TO APPEND:)
								, msgmissing=%STR(NO TABLES TO APPEND TO LASR)
								);
	%END;

	%IF (%ISYES(AL_OPTION_SYNC_UNLOAD)) %THEN %DO;
		%OutputHeader(UNLOAD);
		%ActionSummaryPreview	( data=&UNLLIST.
								, msgfound=%STR(TABLES CURRENTLY LOADED TO UNLOAD:)
								, msgmissing=%STR(NO CURRENTLY LOADED LASR TABLES TO UNLOAD)
								);
	%END;

	%IF (%ISYES(AL_OPTION_ROS_ENABLED)) %THEN %DO;
		%OutputHeader(RELOAD-ON-START);

		/* Cycle through reload-on-start libraries */
		%IF %SYMEXIST(ROSLIBRARIES) %THEN %DO; %SYMDEL ROSLIBRARIES; %END;
		options nonotes;
		proc sql noprint;
		   select libname
			into :ROSLIBRARIES separated by '|'
			from &ROSLIBS. 
			;
		quit;
		options notes;
		%if %SYMEXIST(ROSLIBRARIES) %THEN %DO;
			%let libpos=1;
			%let ROSLIB=%QSCAN(%nrbquote(&ROSLIBRARIES.),&libpos.,|);

			/* FOR EACH LASR RELOAD-ON-START LIBRARY FOUND */
		   	%DO %WHILE ("%nrbquote(&ROSLIB.)" ne "");
				%ActionSummaryPreview	( data=&ROSLIST.&LIBPOS.
										, msgfound=%STR(Library: &ROSLIB.:)
										, msgmissing=%STR(NO TABLES TO RELOAD-ON-START)
										, cols=sastblname
										);

				%let LIBPOS=%eval(&libpos.+1);
				%let ROSLIB=%QSCAN(%nrbquote(&ROSLIBRARIES.),&libpos.,|);
			%END;
		%END;
	%END;

	%setoption(restore,notes);
%mend;
