#!/bin/sh

################################################################################
# Copyright (c) 2013-2025, SAS Institute Inc., Cary, NC, USA. All Rights Reserved.
################################################################################

# Set GEODE to the product toplevel directory.
GEODE=$LOCATOR_HOME
GEODE_JARS=$GEODE/lib/geode-dependencies.jar

if [ "x$CLASSPATH" != "x" ]; then
  GEODE_JARS=$GEODE_JARS:$CLASSPATH
fi

GEODE_ARGS="$LOCATOR_HOST-$LOCATOR_PORT --port=$LOCATOR_PORT"

JAVA_ARGS="-Xms128m -Xmx512m --add-exports=java.base/sun.nio.ch=ALL-UNNAMED --add-exports=java.management/com.sun.jmx.remote.security=ALL-UNNAMED --add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=java.base/java.nio=ALL-UNNAMED --add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED -Dgemfire.log-file=$LOCATOR_INSTANCE_HOME/gemfire.log -Dgemfire.mcast-port=0 -Djava.net.preferIPv4Stack=$USE_IPV4_STACK -Djava.net.preferIPv6Addresses=$USE_IPv6_ADDRESS -Dgemfire.locators=$LOCATORS -Dgemfire.enable-network-partition-detection=false"
echo $GEODE_ARGS
echo $GEODE_JARS
GEODE_LOCATOR_COMMAND="cd $LOCATOR_INSTANCE_HOME; nohup -- $GF_JAVA $JAVA_ARGS -classpath $GEODE_JARS org.apache.geode.distributed.LocatorLauncher start $GEODE_ARGS 2>&1 1>$LOCATOR_INSTANCE_HOME/gemfireCommand.log & sleep 1"
echo $GEODE_LOCATOR_COMMAND
eval $GEODE_LOCATOR_COMMAND
