@echo off

REM *** ------------------------------------------------------------------------------
REM *** Copyright (c) 2013 - 2025 by SAS Institute Inc., Cary, NC USA 27513
REM *** ------------------------------------------------------------------------------
REM ***
REM *** Invoke Tomcat's catalina shell script to control the web application server.
REM ***
REM *** ------------------------------------------------------------------------------

setlocal EnableDelayedExpansion

set ERROR_STATE=0
set DEBUG_MODE=0

set ARG_COUNT=0
for %%i in (%*) do (
    if "%%i" == "-debug" (
        set DEBUG_MODE=1
        echo DEBUG mode is enabled for the script only.
    ) else (
        set /a ARG_COUNT+=1
        set argVec[!ARG_COUNT!]=%%i
    )
)


set "SRC_DIR=%~dp0%"
pushd .
cd %SRC_DIR%
set "SRC_DIR=%cd%"
popd
if %DEBUG_MODE% NEQ 0 ( echo DEBUG: SRC_DIR = %SRC_DIR% )


set RUN_SETENV=0
if "%CATALINA_HOME%" == "" set RUN_SETENV=1
if "%CATALINA_BASE%" == "" set RUN_SETENV=1
if "%JAVA_HOME%"     == "" set RUN_SETENV=1
if %RUN_SETENV% NEQ 0 (
   if exist %SRC_DIR%\setenv.bat (
      if %DEBUG_MODE% NEQ 0 ( echo DEBUG: calling %SRC_DIR%\setenv.bat )
      call %SRC_DIR%\setenv.bat
   ) else (
      echo ERROR: File not found: %SRC_DIR%\setenv.bat
   )
)

if "%CATALINA_HOME%" == "" (
   set ERROR_STATE=1
   echo ERROR: The CATALINA_HOME environment variable is not defined
   goto END
) else (
   if %DEBUG_MODE% NEQ 0 ( echo DEBUG: CATALINA_HOME = %CATALINA_HOME% )
)


if "%CATALINA_BASE%" == "" (
   set ERROR_STATE=1
   echo ERROR: The CATALINA_BASE environment variable is not defined
   goto END
) else (
   if %DEBUG_MODE% NEQ 0 ( echo DEBUG: CATALINA_BASE = %CATALINA_BASE% )
)


if "%JAVA_HOME%" == "" (
   set ERROR_STATE=1
   echo ERROR: The JAVA_HOME environment variable is not defined
   goto END
) else (
   if %DEBUG_MODE% NEQ 0 ( echo DEBUG: JAVA_HOME = %JAVA_HOME% )
)


if %ERROR_STATE% EQU 0 (

   if "%1" == "start" (

      REM *** Determine the size of the server's log file before startup.    
      set "SERVER_LOG_FILE=%CATALINA_BASE%\logs\server.log"

      if exist !SERVER_LOG_FILE! (
         for %%A in ( !SERVER_LOG_FILE! ) do (
            set "SERVER_LOG_SIZE=%%~zA"
         )
      ) else (
         set "SERVER_LOG_SIZE="
      )
      if %DEBUG_MODE% NEQ 0 ( echo DEBUG: Log file !SERVER_LOG_FILE! size = !SERVER_LOG_SIZE! )


      REM *** Invoke the vendor shell script to start the server.
      call catalina.bat start


      call :SET_CLASSPATH

      "%JAVA_HOME%\bin\java" -classpath !CLASSPATH! ^
                             -Dcatalina.home=%CATALINA_HOME% ^
                             -Dcatalina.base=%CATALINA_BASE% ^
                             -Dsas.vfabrictcsvr.execution.properties.file="%CATALINA_BASE%\conf\vfabrictcsvr.properties" ^
                             -Dsas.vfabrictcsvr.execution.log.size=!SERVER_LOG_SIZE! ^
                             com.sas.vfabrictcsvr.execution.ExecutionInterface -wpr -verbose
   goto END
   )

   if "%1" == "stop" (

      call :SET_CLASSPATH

   	  "%JAVA_HOME%\bin\java" -classpath !CLASSPATH! ^
                             -Dcatalina.home=%CATALINA_HOME% ^
                             -Dcatalina.base=%CATALINA_BASE% ^
                             -Dsas.vfabrictcsvr.execution.properties.file="%CATALINA_BASE%\conf\vfabrictcsvr.properties" ^
                             com.sas.vfabrictcsvr.execution.ExecutionInterface -wps -verbose
   goto END
   )

   if "%1" == "status" (
      REM *** Tomcat on Windows does not record or share the process ID of the
      REM *** server when it starts, even if the CATALINA_PID environment variable
      REM *** is defined, so you cannot determine the process ID on a Windows host.
      REM *** Without a process ID, no status check is possible.   
      echo The 'status' action is not supported on Windows.
      goto END
   )

   if "%1" == "restart" (
      echo The 'restart' action is not supported.  To restart the server
      echo use the 'stop' action and wait for the server to complete the
      echo shutdown process, and then follow up with a 'start' action.
      goto END
   )

   if "%1" == "configtest" (
      call %SRC_DIR%\catalina.bat configtest
      if not %ERRORLEVEL% == 0 ( set ERROR_STATE=1 )
      goto END
   )

   if "%1" == "version" (
      call %SRC_DIR%\catalina.bat version
      if not %ERRORLEVEL% == 0 ( set ERROR_STATE=1 )
      goto END
   )

   if "%1" == "help" (
      goto SHOW_HELP
   )

   if "%1" == "" (
      echo ERROR: An action command is required
      set ERROR_STATE=1
      goto END
   ) else (
      echo ERROR: Invalid action command:  %1
      goto SHOW_HELP
   )
)
goto END


:SHOW_HELP

echo+
echo Usage: tcruntime-ctl.sh ^<command^>
echo commands:
echo    start       Start the web application server and wait for it to report ready
echo    stop        Stop the web application server and wait for the process to end
echo    status      Not supported on Windows
echo    restart     Not supported on Windows
echo    configtest  Run a basic syntax check on server.xml - check exit code for result
echo    version     What version of tomcat are you running?
echo+
goto END


:SET_CLASSPATH

set CLASSPATH=
for %%f in (%CATALINA_BASE%\bin\*.jar) do call :APPEND_TO_CLASSPATH %%f
for %%f in (%CATALINA_BASE%\lib\*.jar) do call :APPEND_TO_CLASSPATH %%f
for %%f in (%CATALINA_HOME%\lib\*.jar) do call :APPEND_TO_CLASSPATH %%f

pushd .
cd %SRC_DIR%\..\log4j2
set "LOG4J_DIR=%cd%"
popd
if %DEBUG_MODE% NEQ 0 ( echo LOG4J_DIR = %LOG4J_DIR% )

for %%f in (%LOG4J_DIR%\lib\*.jar) do call :APPEND_TO_CLASSPATH %%f
set CLASSPATH=%CLASSPATH%%LOG4J_DIR%\conf\log4j2.xml

if %DEBUG_MODE% NEQ 0 ( 
   echo DEBUG: CLASSPATH:

   set t=%CLASSPATH%
   :loop
   for /f "tokens=1* Delims=;" %%a in ("%t%") do (
      echo    ^>^> %%a
      set t=%%b
   )
   if defined t goto :loop
)
exit /b 0


:APPEND_TO_CLASSPATH
set FILENAME=%~1
set SUFFIX=%FILENAME:~-4%
if %SUFFIX% equ .jar ( set "CLASSPATH=%CLASSPATH%%FILENAME%;" )
goto:EOF


:END

endlocal
exit /b %ERROR_STATE%
