@echo off

REM *** ------------------------------------------------------------------------
REM *** Copyright(c) 2013 - 2025 by SAS Institute Inc., Cary, NC USA 27513
REM *** ------------------------------------------------------------------------
REM ***
REM *** Invoke Java functionality to encrypt and base64 encode a value.
REM ***
REM *** Environment variables JAVA_HOME and CATALINA_HOME must already be defined.
REM ***
REM *** ------------------------------------------------------------------------


setlocal EnableDelayedExpansion

set ERROR_STATE=0
set DEBUG_MODE=0


set ARG_COUNT=0
for %%i in (%*) do (
    if "%%i" == "-debug" (
        set DEBUG_MODE=1
        echo DEBUG mode is enabled for the script only.
        echo Use log4j.xml to enable debug messages for Java.
    ) else (
        set /a ARG_COUNT+=1
        set argVec[!ARG_COUNT!]=%%i
    )
)


if %DEBUG_MODE% NEQ 0 (
    echo DEBUG: Number of command line arguments = %ARG_COUNT%
    for /L %%i in (1,1,%ARG_COUNT%) do (
        echo   %%i = !argVec[%%i]!
    )
)


if "%JAVA_HOME%" == "" (
    set ERROR_STATE=1
    echo ERROR: The JAVA_HOME environment variable is not defined
    goto END
) else (
    if %DEBUG_MODE% NEQ 0 ( echo DEBUG: JAVA_HOME = %JAVA_HOME% )
)


if "%CATALINA_HOME%" == "" (
    set ERROR_STATE=1
    echo ERROR: The CATALINA_HOME environment variable is not defined
    goto END
) else (
    if %DEBUG_MODE% NEQ 0 ( echo DEBUG: CATALINA_HOME = %CATALINA_HOME% )
)


set SRC_DIR=%~dp0%

pushd .
cd %SRC_DIR%..\lib
set LIB_DIR=%cd%
popd
if %DEBUG_MODE% NEQ 0 ( echo LIB_DIR = %LIB_DIR% )


SET HOME_LIB=%CATALINA_HOME%\lib
if %DEBUG_MODE% NEQ 0 ( echo HOME_LIB = %HOME_LIB% )

set LOG4J_DIR=%~dp0%..\log4j2

set CLASSPATH=%SRC_DIR%*;%LIB_DIR%\*;%HOME_LIB%\*;%LOG4J_DIR%\lib\*;%LOG4J_DIR%\conf\log4j2.xml

:CONTINUE


if %DEBUG_MODE% NEQ 0 ( echo DEBUG: CLASSPATH = %CLASSPATH% )

if %ARG_COUNT% EQU 0 ( set HELP=-help )

"%JAVA_HOME%\bin\java" -classpath "%CLASSPATH%" com.sas.vfabrictcsvr.decoder.RunDecoder %HELP% %*

if %DEBUG_MODE% NEQ 0 ( echo DEBUG: ERRORLEVEL = %ERRORLEVEL% )

if %ERRORLEVEL% NEQ 0 (
    set ERROR_STATE=1
    echo Run with no arguments or the --help switch to see usage information )
)


:END

endlocal
exit /b %ERROR_STATE%
