/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.builder.sfx;

import com.sas.tools.installs.builder.sfx.Command;
import com.sas.tools.installs.builder.sfx.Platform;
import com.sas.tools.installs.builder.sfx.SFXBuilder;
import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class Controller
implements Runnable {
    private static HashMap<String, Platform> _platforms = new HashMap();
    static Logger logger = (Logger)LogManager.getLogger(Controller.class);
    private String _sourceDirectory;
    private String _targetDirectory;
    private String _platform;
    private String _executeScript;
    private String _name;
    private String _dataDirectory;
    private String _realDestDirectory;

    public void setLevel(String level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(Level.getLevel(level.toUpperCase()));
    }

    public int init(String[] args) {
        if (!this.configure(args)) {
            logger.error("Controller configuration has failed to to improper arguments.");
            return -1;
        }
        logger.info("Controller has been configured.");
        if (!this.loadPlatforms()) {
            logger.error("Controller failed to load the platform definitions");
            return -1;
        }
        return 0;
    }

    private boolean configure(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-executeScript")) {
                try {
                    this._executeScript = args[i + 1];
                    ++i;
                }
                catch (Exception e) {
                    logger.error("You must specify the fully qualified path for the execution script when using the -executeScript argument");
                }
                continue;
            }
            if (arg.equals("-sourceDirectory")) {
                try {
                    this._sourceDirectory = args[i + 1];
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    logger.error("You must specify the directory location for the input when using the -sourceDirectory argument");
                    return false;
                }
            }
            if (arg.equals("-targetDirectory")) {
                try {
                    this._targetDirectory = args[i + 1];
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    logger.error("You must specify the directory location for the output when using the -targetDirectory argument");
                    return false;
                }
            }
            if (arg.equals("-platform")) {
                try {
                    this._platform = args[i + 1];
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    logger.error("You must specify a valid platform when using the -platform argument.");
                    return false;
                }
            }
            if (arg.equals("-name")) {
                try {
                    this._name = args[i + 1];
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    logger.error("You must specify a valid name when using the -name argument.");
                    return false;
                }
            }
            if (arg.equals("-dataDirectory")) {
                try {
                    this._dataDirectory = args[i + 1];
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    logger.error("You must specify a valid dataDirectory when using the -dataDirectory argument.");
                    return false;
                }
            }
            if (arg.equals("-realDestinationDirectory")) {
                try {
                    this._realDestDirectory = args[i + 1];
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    logger.error("You must specify a valid realDestinationDirectory when using the -realDestinationDirectory argument.");
                    return false;
                }
            }
            if (!arg.equals("-help")) continue;
            StringBuffer help = new StringBuffer();
            help.append("Welcome to the Bundle Creation Tool v1.0\n");
            System.out.println(help.toString());
            System.exit(0);
        }
        return true;
    }

    @Override
    public void run() {
        int returnCode = 0;
        Command c = new Command();
        c.setPlatform(this._platform);
        c.setSourceDirectory(this._sourceDirectory);
        c.setTargetDirectory(this._targetDirectory);
        c.setExecuteScript(this._executeScript);
        c.setDataDirectory(this._dataDirectory);
        c.setRealDestDir(this._realDestDirectory);
        c.setName(this._name);
        SFXBuilder builder = new SFXBuilder(c);
        builder.execute();
        logger.info("Bundler has completed. rc=(" + returnCode + ")");
        System.exit(returnCode);
    }

    public static String getLauncher(String platformStr) {
        Platform platform = null;
        logger.info("###############################\n");
        logger.info("getLauncher() - searching for  " + platformStr);
        logger.info("###############################\n");
        platform = _platforms.get(platformStr);
        if (platform != null) {
            return platform.getLauncher();
        }
        platform = _platforms.get(platformStr.toLowerCase());
        if (platform != null) {
            return platform.getLauncher();
        }
        return null;
    }

    public static String getSFX(String platformStr) {
        Platform platform = null;
        platform = _platforms.get(platformStr);
        if (platform != null) {
            return platform.getSFX();
        }
        platform = _platforms.get(platformStr.toLowerCase());
        if (platform != null) {
            return platform.getSFX();
        }
        return null;
    }

    public static String getSFXExtension(String platformStr) {
        Platform platform = null;
        platform = _platforms.get(platformStr);
        if (platform != null) {
            return platform.getExtension();
        }
        platform = _platforms.get(platformStr.toLowerCase());
        if (platform != null) {
            return platform.getExtension();
        }
        return null;
    }

    public static HashMap<String, Platform> getPlatforms() {
        return _platforms;
    }

    public static String getPlatform(String key) {
        Platform platform = _platforms.get(key);
        if (platform != null) {
            return platform.getName();
        }
        return null;
    }

    private boolean loadPlatforms() {
        block8: {
            try {
                File inputFile = new File(this._dataDirectory + File.separator + "platform_definitions.xml");
                if (inputFile != null) {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document document = builder.parse(inputFile);
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    String expression = "//platform";
                    Object result = xpath.evaluate(expression, document, XPathConstants.NODESET);
                    NodeList nodes = (NodeList)result;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        String platformName = null;
                        String launcher = null;
                        String sfx = null;
                        String extension = null;
                        NamedNodeMap attrs = nodes.item(i).getAttributes();
                        int len = attrs.getLength();
                        for (int j = 0; j < len; ++j) {
                            Attr attr = (Attr)attrs.item(j);
                            if ("name".equalsIgnoreCase(attr.getNodeName())) {
                                platformName = attr.getNodeValue();
                                continue;
                            }
                            if ("launcher".equalsIgnoreCase(attr.getNodeName())) {
                                launcher = attr.getNodeValue();
                                continue;
                            }
                            if ("sfx".equalsIgnoreCase(attr.getNodeName())) {
                                sfx = attr.getNodeValue();
                                continue;
                            }
                            if (!"extension".equalsIgnoreCase(attr.getNodeName())) continue;
                            extension = attr.getNodeValue();
                        }
                        _platforms.put(platformName, new Platform(platformName, launcher, sfx, extension));
                    }
                    break block8;
                }
                logger.error("loadPlatforms() - unable to find the platform definitions");
                return false;
            }
            catch (Exception e) {
                logger.error("loadPlatforms() - unable to process the platform file -" + e.getLocalizedMessage());
                return false;
            }
        }
        return true;
    }
}

