/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr.mapping.processors;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.util.ISUtility;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.common.client.dao.omr.mapping.ResultMapEntry;
import com.sas.svcs.common.client.dao.omr.mapping.processors.AttributeProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.ReferenceProcessor;
import java.util.Map;

public class PathProcessor
implements AttributeProcessor {
    public static final String TYPE_STRING = "ContentPath";

    @Override
    public Object getResultingObject(AttributeMapping mapping, CMetadata metadata, Map<String, ResultMapEntry> result) {
        String attribute = mapping.getMetadataAttribute();
        if (attribute != null && attribute.length() > 0) {
            ReferenceProcessor rp = new ReferenceProcessor();
            Object obj = rp.getResultingObject(mapping, metadata, result);
            if (obj == null) {
                return null;
            }
            metadata = (CMetadata)obj;
        }
        if (metadata instanceof PrimaryType) {
            try {
                MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
                MdFactory factory = store.getFactory();
                return factory.getOMIUtil().getObjectPath(store, (PrimaryType)metadata, false);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return null;
    }

    @Override
    public Object getBrowseObject(AttributeMapping mapping, BrowseMetadata bmi, Map<String, ResultMapEntry> result) {
        String attribute = mapping.getMetadataAttribute();
        if (attribute != null && attribute.length() > 0) {
            ReferenceProcessor rp = new ReferenceProcessor();
            Object obj = rp.getBrowseObject(mapping, bmi, result);
            if (obj == null) {
                return null;
            }
            bmi = (BrowseMetadata)obj;
        }
        if (bmi != null) {
            ResultMapEntry entry = result.get("authserver");
            ServerInterface server = (ServerInterface)entry.value;
            if (server != null) {
                try {
                    String key = bmi.getISEntityKey();
                    PathUrl pathUrl = ISUtility.getPathFromEntityKey((UserContextInterface)server.getUserContext(), (String)key);
                    if (pathUrl != null) {
                        return pathUrl.getDisplayPath();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    @Override
    public boolean prepareCall(Class[] args, Object[] parms, String argType, Object value) {
        args[0] = String.class;
        parms[0] = value;
        return true;
    }

    @Override
    public void setAttribute(Object o, AttributeMapping map, CMetadata metadata, Map<String, ResultMapEntry> updateMap) {
    }
}

