/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr.mapping.processors;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.common.client.dao.omr.mapping.ResultMapEntry;
import com.sas.svcs.common.client.dao.omr.mapping.processors.AttributeProcessor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ContentPropertiesProcessor
implements AttributeProcessor {
    public static final String TYPE_STRING = "ContentProperties";
    public static final String SP_SOURCE_DIRECTORY = "SPSourceCodeRepository";

    @Override
    public Object getBrowseObject(AttributeMapping mapping, BrowseMetadata bmi, Map<String, ResultMapEntry> result) {
        Properties value = new Properties();
        List propertyList = (List)bmi.get("Properties");
        if (propertyList != null && propertyList.size() > 0) {
            for (BrowseMetadata nextProperty : propertyList) {
                String defaultValue;
                String propertyName = (String)nextProperty.get("PropertyName");
                if (propertyName == null || propertyName.length() == 0) {
                    propertyName = nextProperty.getName();
                }
                if ((defaultValue = (String)nextProperty.get("DefaultValue")) == null || defaultValue.length() == 0) {
                    defaultValue = (String)nextProperty.get("PropertyRole");
                }
                value.setProperty(propertyName, defaultValue);
            }
            return value;
        }
        return null;
    }

    @Override
    public Object getResultingObject(AttributeMapping mapping, CMetadata metadata, Map<String, ResultMapEntry> result) {
        Properties value = new Properties();
        try {
            AssociationList properties = ((Root)metadata).getProperties();
            for (Property prop : properties) {
                String defaultValue;
                String propertyName = prop.getPropertyName();
                if (propertyName == null || propertyName.length() == 0) {
                    propertyName = prop.getName();
                }
                if ((defaultValue = prop.getDefaultValue()) == null || defaultValue.length() == 0) {
                    defaultValue = prop.getPropertyRole();
                }
                value.setProperty(propertyName, defaultValue);
            }
            return value;
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (MdException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean prepareCall(Class[] args, Object[] parms, String argType, Object value) {
        Properties realValue = (Properties)value;
        args[0] = Properties.class;
        parms[0] = realValue;
        return true;
    }

    @Override
    public void setAttribute(Object o, AttributeMapping map, CMetadata metadata, Map<String, ResultMapEntry> updateMap) {
        Properties keyList = new Properties();
        if (o != null) {
            keyList.putAll((Map<?, ?>)((Properties)o));
        }
        Set<Object> propertyList = null;
        propertyList = o != null ? ((Properties)o).keySet() : new HashSet<Object>();
        try {
            AssociationList currentProperties = ((Root)metadata).getProperties();
            ArrayList properties = new ArrayList(((Root)metadata).getProperties());
            for (String string : propertyList) {
                String propertyValue = keyList.getProperty(string);
                for (Property nextProperty : currentProperties) {
                    if (!nextProperty.getName().equals(string) && !nextProperty.getPropertyName().equals(string)) continue;
                    if (nextProperty.getDefaultValue() == null || nextProperty.getDefaultValue().length() == 0) {
                        if (!nextProperty.getPropertyRole().equals(propertyValue)) {
                            nextProperty.setPropertyRole(propertyValue);
                        }
                    } else if (!nextProperty.getDefaultValue().equals(propertyValue)) {
                        nextProperty.setDefaultValue(propertyValue);
                    }
                    keyList.remove(string);
                    properties.remove(nextProperty);
                }
            }
            Set<Object> set = keyList.keySet();
            Iterator<Object> it = set.iterator();
            while (it.hasNext()) {
                String nextKey;
                String propertyName = nextKey = (String)it.next();
                String propertyValue = ((Properties)o).getProperty(nextKey);
                Property property = null;
                if (properties.size() > 0) {
                    property = (Property)properties.get(0);
                    properties.remove(0);
                } else {
                    MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
                    MdFactory factory = store.getFactory();
                    property = (Property)factory.createComplexMetadataObject(store, null, propertyName, "Property", metadata.getRepositoryID());
                }
                property.setName(propertyName);
                if (propertyValue.equals(SP_SOURCE_DIRECTORY)) {
                    property.setPropertyRole(propertyValue);
                } else {
                    property.setPropertyName(propertyName);
                    property.setDefaultValue(propertyValue);
                }
                property.setAssociatedObject((Root)metadata);
            }
            for (Property property : properties) {
                property.delete();
            }
        }
        catch (MdException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

