/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr.mapping;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.common.client.dao.omr.AbstractOmrDAO;
import com.sas.svcs.common.client.dao.omr.mapping.ContentMappingDefinition;
import com.sas.svcs.common.client.dao.omr.mapping.DAOUtil;
import com.sas.svcs.common.client.dao.omr.mapping.ObjectMapping;
import com.sas.svcs.common.client.dao.omr.mapping.RB;
import com.sas.svcs.common.client.dao.omr.mapping.ResultMapEntry;
import com.sas.svcs.common.client.dao.omr.mapping.processors.ObjectIdentityListProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.ObjectIdentityProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.SubObjectNameListProcessor;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectModifiedException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class BaseOMRMappingDAO
extends AbstractOmrDAO {
    protected ContentMappingDefinition mappingDefinition;
    private ObjectIdentityProcessor objectIdentityProcessor = null;
    private ObjectIdentityListProcessor objectIdentityListProcessor = null;
    protected DAOUtil daoUtil = null;

    public void delete(ObjectIdentity identity) throws ObjectNotFoundException {
        MetadataInterface mi = super.getMetadataObjectById(identity.getId());
        if (mi == null) {
            throw new ObjectNotFoundException(Message.format((ResourceBundle)RB.getResources(), (String)"BaseOMRMappingDAO.objectnotfound.fmt.txt", (Object)identity.getId()), identity.getId());
        }
        try {
            mi.delete();
            mi.update();
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected String getTemplate() {
        return null;
    }

    protected long getInternalVersion(BrowseMetadata bm) {
        long version = -1L;
        Date modifyDate = bm.getModifyDateAsDate();
        version = modifyDate.getTime();
        return version;
    }

    protected long getInternalVersion(MetadataInterface mi) {
        long version = -1L;
        try {
            MetadataServerInterface server = (MetadataServerInterface)mi.getRepository().getServer();
            Date modifyDate = server.getModifiedDate(mi);
            version = modifyDate.getTime();
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return version;
    }

    public ContentComponent findComponentById(ObjectIdentity identity) {
        String template = this.getTemplate();
        if (template != null) {
            BrowseMetadata bm = this.getBrowseMetadataById(identity.getId(), template);
            if (bm == null) {
                return null;
            }
            return this.makeComponentBrowse(bm);
        }
        MetadataInterface mi = this.getMetadataObjectById(identity.getId());
        if (mi == null) {
            return null;
        }
        return this.makeComponent(mi);
    }

    public BaseOMRMappingDAO(ContentMappingDefinition definition) {
        this.mappingDefinition = definition;
    }

    protected ContentComponent makeComponentBrowse(BrowseMetadata bmi) {
        ObjectMapping mapping = this.mappingDefinition.getObjectMapping();
        DAOUtil mydaoUtil = this.getDAOUtil();
        String className = mapping.contentClass;
        ContentComponent result = (ContentComponent)mydaoUtil.newInstance(className);
        result.setInternalVersion(this.getInternalVersion(bmi));
        Map<String, ResultMapEntry> resultMap = mydaoUtil.processMapBrowse(mapping, bmi);
        mydaoUtil.populateObjectFromResultMap(result, resultMap);
        return result;
    }

    protected ContentComponent makeComponent(MetadataInterface bmi) {
        try {
            ContentComponent result = this.makeComponent((Root)bmi.getRepositoryEntity());
            result.setInternalVersion(this.getInternalVersion(bmi));
            return result;
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected ContentComponent makeComponent(Root root) {
        return this.makeComponent(this.mappingDefinition, root);
    }

    protected ContentComponent makeComponent(ContentMappingDefinition definition, Root root) {
        ObjectMapping mapping = definition.getObjectMapping();
        String className = mapping.contentClass;
        DAOUtil daoUtil = this.getDAOUtil();
        ContentComponent result = (ContentComponent)daoUtil.newInstance(className);
        Map<String, ResultMapEntry> resultMap = daoUtil.processObjectMap(mapping, (CMetadata)root);
        daoUtil.populateObjectFromResultMap(result, resultMap);
        return result;
    }

    protected ContentComponent updateComponent(ContentComponent contentObject, MetadataInterface mi) throws ObjectModifiedException {
        if (contentObject.isDescriptor()) {
            throw new RuntimeException(RB.getStringResource("BaseOMRMappingDAO.descriptorupdate.ex.txt"));
        }
        try {
            long version = this.getInternalVersion(mi);
            if (version != contentObject.getInternalVersion()) {
                throw new ObjectModifiedException(Message.format((ResourceBundle)RB.getResources(), (String)"BaseOMRMappingDAO.objectmodified.fmt.txt", (Object)contentObject.getId()), contentObject.getId());
            }
            ContentComponent result = this.updateComponent(contentObject, (Root)mi.getRepositoryEntity());
            result.setInternalVersion(this.getInternalVersion(mi));
            return this.makeComponent(mi);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected ContentComponent updateComponent(ContentComponent contentObject, Root metaContext) {
        ObjectMapping mapping = this.mappingDefinition.getObjectMapping();
        try {
            DAOUtil daoUtil = this.getDAOUtil();
            Map<String, ResultMapEntry> updateMap = daoUtil.makeUpdateMap(contentObject, mapping);
            daoUtil.updateMetadataFromMap((CMetadata)metaContext, updateMap, mapping);
            metaContext.updateMetadataAll();
            contentObject.setId(metaContext.getFQID() + "/" + metaContext.getCMetadataType());
        }
        catch (MdException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return contentObject;
    }

    public ContentComponent create(ObjectIdentity parent, ContentComponent contentObject) throws ObjectNotFoundException, ObjectExistsException, ValidationException {
        this.validateName(contentObject.getName());
        UserContextInterface user = this.getUserContext();
        try {
            RepositoryInterface repository;
            MetadataInterface metadata;
            Root root;
            ServerInterface isServer = user.getAuthServer();
            FolderInterface parentFolder = null;
            if (parent != null) {
                parentFolder = (FolderInterface)this.getMetadataObjectById(parent.getId());
                if (parentFolder == null) {
                    throw new ObjectNotFoundException("Folder with identifier " + parent.getId() + " was not found.", parent.getId());
                }
                if (parentFolder.hasDuplicate(contentObject.getName(), contentObject.getObjectTypeName())) {
                    throw new ObjectExistsException("The parent folder already has a member of type " + contentObject.getObjectTypeName() + " with name " + contentObject.getName(), parent.getId());
                }
            }
            if ((root = (Root)(metadata = (repository = isServer.getFoundationRepository()).newMetadata(null, contentObject.getName(), this.mappingDefinition.getMetadataType())).getRepositoryEntity()) instanceof PrimaryType) {
                ((PrimaryType)root).setPublicType(contentObject.getObjectTypeName());
            }
            root.setUsageVersion(1000000.0);
            metadata.update();
            metadata.refresh();
            contentObject.setInternalVersion(this.getInternalVersion(metadata));
            ContentComponent result = contentObject;
            try {
                result = this.updateComponent(contentObject, metadata);
            }
            catch (ObjectModifiedException objectModifiedException) {
                // empty catch block
            }
            if (parentFolder != null) {
                parentFolder.addItem(metadata);
                metadata.update();
                result.setInternalVersion(this.getInternalVersion(metadata));
            }
            return result;
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected ContentComponent getDefault() {
        ObjectMapping mapping = this.mappingDefinition.getObjectMapping();
        DAOUtil daoUtil = this.getDAOUtil();
        ContentObject result = daoUtil.makeDefaultObject(mapping);
        return result;
    }

    public long getObjectTypeForMetadata(MetadataInterface mi) {
        ObjectTypeService typeService;
        ObjectType objectType;
        String type = null;
        try {
            PrimaryType root = (PrimaryType)mi.getRepositoryEntity();
            type = root.getPublicType();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        if (type == null || type.length() == 0) {
            try {
                type = mi.getType();
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        if (type != null && (objectType = (typeService = this.getObjectTypeService()).getTypeByName(type)) != null) {
            return objectType.getId();
        }
        return -1L;
    }

    public long getObjectTypeForRoot(PrimaryType root) {
        try {
            ObjectTypeService typeService;
            ObjectType objectType;
            String type = root.getPublicType();
            if (type != null && type.length() > 0 && (objectType = (typeService = this.getObjectTypeService()).getTypeByName(type)) != null) {
                return objectType.getId();
            }
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return -1L;
    }

    public DAOUtil getDAOUtil() {
        if (this.daoUtil == null) {
            this.daoUtil = new DAOUtil();
            this.daoUtil.setObjectTypeService(this.getObjectTypeService());
            this.daoUtil.addProcessor("SubObjectNameList", new SubObjectNameListProcessor());
            if (this.objectIdentityProcessor == null) {
                this.objectIdentityProcessor = new ObjectIdentityProcessor();
                this.objectIdentityProcessor.setObjectTypeService(this.getObjectTypeService());
            }
            if (this.objectIdentityListProcessor == null) {
                this.objectIdentityListProcessor = new ObjectIdentityListProcessor();
                this.objectIdentityListProcessor.setObjectTypeService(this.getObjectTypeService());
            }
            this.daoUtil.addProcessor("ObjectIdentityProcessor", this.objectIdentityProcessor);
            this.daoUtil.addProcessor("ObjectIdentityListProcessor", this.objectIdentityListProcessor);
        }
        try {
            UserContextInterface user = this.getUserContext();
            this.daoUtil.setServer(user.getAuthServer());
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this.daoUtil;
    }
}

