/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr.mapping;

import com.sas.metadata.remote.Root;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.svcs.common.client.dao.omr.mapping.BaseOMRMappingDAO;
import com.sas.svcs.common.client.dao.omr.mapping.ContentMappingDefinition;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectModifiedException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;

public class AbstractOMRMappingDAO<T extends ContentComponent>
extends BaseOMRMappingDAO {
    public AbstractOMRMappingDAO(ContentMappingDefinition mappingDefinition) {
        super(mappingDefinition);
    }

    public T findById(ObjectIdentity identity) {
        ContentComponent cc = this.findComponentById(identity);
        return (T)cc;
    }

    public T createObject(T contentObject) throws ValidationException {
        try {
            ContentComponent cc = this.create(null, (ContentComponent)contentObject);
            return (T)cc;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
        }
        catch (ObjectExistsException objectExistsException) {
            // empty catch block
        }
        return null;
    }

    public T makeObjectBrowse(BrowseMetadata bmi) {
        return (T)this.makeComponentBrowse(bmi);
    }

    public T makeObject(MetadataInterface mi) {
        return (T)this.makeComponent(mi);
    }

    public T makeObject(Root root) {
        return (T)this.makeComponent(root);
    }

    public T updateObject(T contentObject) throws ObjectNotFoundException, ObjectModifiedException {
        MetadataInterface mi = this.getMetadataObjectById(contentObject.getId());
        if (mi == null) {
            throw new ObjectNotFoundException("Metadata object with Id " + contentObject.getId() + " was not found in data store.", contentObject.getId());
        }
        long version = this.getInternalVersion(mi);
        if (version != contentObject.getInternalVersion()) {
            throw new ObjectModifiedException("It appears the object changed since it was read.", contentObject.getId());
        }
        return (T)super.updateComponent((ContentComponent)contentObject, mi);
    }

    public T getDefault() {
        return (T)super.getDefault();
    }
}

