/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr;

import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.PathUrl;
import com.sas.svcs.common.client.SASObjUri;
import java.rmi.RemoteException;
import java.util.List;

public class PathUtils {
    public static PathUrl makePathUrlFromSASObjUri(SASObjUri sasObjUri, ServerInterface server) {
        String name;
        StringBuffer pathBuffer = new StringBuffer("/");
        List path = sasObjUri.getPath();
        if (path != null && path.size() > 0) {
            for (String folderName : path) {
                pathBuffer.append(folderName + "/");
            }
        }
        if ((name = sasObjUri.getName()) != null) {
            pathBuffer.append(name);
        }
        pathBuffer.append("(" + sasObjUri.getType() + ")");
        String absolutePath = pathBuffer.toString();
        PathUrl pathUrl = null;
        try {
            pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)absolutePath);
        }
        catch (RemoteException remoteException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return pathUrl;
    }

    public static SASObjUri makeSASObjUriFromPathUrl(PathUrl pathUrl, String repositoryKey) {
        String pathString;
        StringBuffer buffer = new StringBuffer("sasobj:/" + repositoryKey + "/");
        String rootFolder = pathUrl.getRootTree();
        if (rootFolder != null) {
            buffer.append(rootFolder + "/");
        }
        if ((pathString = pathUrl.getPath()) != null) {
            buffer.append(pathString + "/");
        }
        buffer.append(pathUrl.getName());
        String type = pathUrl.getType();
        if (type == null) {
            throw new IllegalArgumentException("The PathUrl has no type, and cannot be made into a valid SASObjUri.");
        }
        buffer.append("?Type=\"" + type + "\"");
        SASObjUri result = new SASObjUri(buffer.toString());
        return result;
    }

    public static String pathToRoot(BrowseMetadata bmi) {
        String path = PathUtils.buildPath(bmi);
        if (path != null && !path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private static String buildPath(BrowseMetadata bmi) {
        List treeList = (List)bmi.get("ParentTree");
        if (treeList == null) {
            List scList = (List)bmi.get("SoftwareComponents");
            if (scList == null) {
                return null;
            }
            for (BrowseMetadata scBmi : scList) {
                if (!scBmi.getName().equals("BIP Service") || !scBmi.get("ClassIdentifier").equals("E5F27790-2149-11D6-8828-AA0004006D06")) continue;
                return bmi.getName();
            }
            return null;
        }
        for (BrowseMetadata nextBmi : treeList) {
            String path = PathUtils.pathToRoot(nextBmi);
            if (path == null) continue;
            return path + '/' + bmi.getName();
        }
        return null;
    }
}

