/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr;

import com.sas.services.ServiceException;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.UsersFolderNode;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import com.sas.svcs.common.client.dao.omr.MetadataContentUtils;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ExtendedContentNode;
import com.sas.svcs.content.framework.client.ExtendedContentObject;
import com.sas.svcs.content.navigation.client.ContainerNode;
import com.sas.svcs.content.navigation.client.NavigationNode;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="navigationMetadataTemplate")
public class NavigationMetadataTemplate {
    private static final Logger log = LogManager.getLogger(NavigationMetadataTemplate.class);
    private static final String BROWSETEMPLATE = "<Templates><Tree><ParentTree/><SoftwareComponents/></Tree><Root><Trees/><ResponsibleParties/><Extensions/></Root><ResponsibleParty><Persons/></ResponsibleParty></Templates>";
    private MetadataTemplate metadataTemplate;
    private MetadataContentUtils metadataUtils = new MetadataContentUtils();
    private ObjectTypeService typeService;

    @Autowired
    public void setMetadataTemplate(@Qualifier(value="currentUserMetadataTemplate") MetadataTemplate metadataTemplate) {
        this.metadataTemplate = metadataTemplate;
    }

    public void setMetadataContentUtils(MetadataContentUtils metadataUtils) {
        this.metadataUtils = metadataUtils;
    }

    @Autowired
    public void setObjectTypeService(ObjectTypeService typeService) {
        this.typeService = typeService;
    }

    public NavigationNode getNavigationNodeByPath(String path, String publicType, ObjectType objectType, Class<? extends ContentComponent> contentObjectType) {
        PublicObjectInterface poi = this.metadataTemplate.getPublicObjectByPath(path, publicType, objectType.getId());
        if (poi == null) {
            return null;
        }
        return this.getNodeFromPublicObject(poi, path, objectType, contentObjectType);
    }

    public NavigationNode getNavigationNodeByPath(String path, String publicType, long objectType, Class<? extends ContentComponent> contentObjectType) {
        PublicObjectInterface poi = this.metadataTemplate.getPublicObjectByPath(path, publicType, objectType);
        if (poi == null) {
            return null;
        }
        return this.getNodeFromPublicObject(poi, path, this.typeService.getTypeById(objectType), contentObjectType);
    }

    public NavigationNode getNavigationNodeById(ObjectIdentity objectId, String publicType, ObjectType objectType, Class<? extends ContentComponent> contentObjectType) {
        PublicObjectInterface poi = this.metadataTemplate.getPublicObjectById(objectId, publicType);
        if (poi == null) {
            return null;
        }
        return this.getNodeFromPublicObject(poi, null, objectType, contentObjectType);
    }

    public NavigationNode getNavigationNodeById(ObjectIdentity objectId, String publicType, Class<? extends ContentComponent> contentObjectType) {
        PublicObjectInterface poi = this.metadataTemplate.getPublicObjectById(objectId, publicType);
        if (poi == null) {
            return null;
        }
        return this.getNodeFromPublicObject(poi, null, this.typeService.getTypeByName(publicType), contentObjectType);
    }

    public NavigationNode getNodeFromBrowseObject(BrowseMetadata bm) {
        String typeString = this.metadataUtils.getBrowseType(bm);
        ObjectType objectType = this.typeService.getTypeByName(typeString);
        String path = this.metadataUtils.getPathFromBrowseMetadata((BrowseMetadataInterface)bm);
        boolean isContainer = objectType.isContainer();
        ContainerNode ret = isContainer ? new ContainerNode() : new NavigationNode();
        Object component = path != null ? new ExtendedContentNode() : new ExtendedContentObject();
        this.metadataUtils.populateContentComponentFromBrowseMetadata((ContentComponent)component, bm);
        component.setObjectTypeName(objectType.getName());
        component.setObjectType(objectType.getId());
        if (component instanceof ContentNode) {
            ((ContentNode)component).setPath(path);
        }
        ret.setContentObject((ContentComponent)component);
        ret.setParentId(this.getBrowseParent(bm));
        ret.setNavigationPath(path);
        return ret;
    }

    private ObjectIdentity getBrowseParent(BrowseMetadata bm) {
        ObjectIdentity result = null;
        List parentTrees = (List)bm.get("ParentTree");
        if (parentTrees == null) {
            parentTrees = (List)bm.get("Trees");
        }
        if (parentTrees != null) {
            BrowseMetadata parent = (BrowseMetadata)parentTrees.get(0);
            String typeName = this.metadataUtils.getBrowseType(bm);
            ObjectType objectType = this.typeService.getTypeByName(typeName);
            long type = objectType != null ? objectType.getId() : -1L;
            result = new ObjectIdentity(type, parent.getReposId() + "/" + parent.getNativeType());
        }
        return result;
    }

    public NavigationNode getNodeFromPublicObject(PublicObjectInterface poi, String path, ObjectType objectType, Class<? extends ContentComponent> contentObjectType) {
        boolean isContainer = objectType.isContainer();
        try {
            ContentComponent component;
            ContainerNode ret = isContainer ? new ContainerNode() : new NavigationNode();
            try {
                component = contentObjectType.newInstance();
            }
            catch (Exception e) {
                log.error("Error instantiating class: " + contentObjectType.getName(), (Throwable)e);
                throw new RuntimeException("Error instantiating class: " + contentObjectType.getName() + " - " + e.getMessage());
            }
            ret.setParentId(this.getParentId(poi, path));
            ret.setContentObject(component);
            if (component instanceof ContentNode) {
                this.metadataUtils.populateContentNodeFromPublicObject(poi, (ContentNode)component);
            } else if (component instanceof ContentObject) {
                this.metadataUtils.populateContentObjectFromPublicObject(poi, (ContentObject)component);
            } else {
                this.metadataUtils.populateContentComponentFromPublicObject(poi, component);
            }
            if (path != null) {
                ret.setNavigationPath(path);
                String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)path);
                if ("".equals(parentPath)) {
                    parentPath = "/";
                    ret.setParentId(new ObjectIdentity(29L, "ROOT_FOLDER_ID"));
                }
            } else if (poi instanceof PublicObjectNodeInterface) {
                ret.setNavigationPath(((PublicObjectNodeInterface)poi).getDisplayPath());
            }
            component.setObjectType(objectType.getId());
            if (-1L == objectType.getId()) {
                TypeDescriptorInterface tdi = poi.getTypeDescriptor();
                if (tdi != null) {
                    component.setObjectTypeName(tdi.getTypeName());
                } else {
                    component.setObjectTypeName("Unknown");
                }
            } else {
                component.setObjectTypeName(objectType.getName());
            }
            return ret;
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("Service exception - " + e.getMessage());
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("Remote exception - " + e.getMessage());
        }
    }

    public boolean isFolderType(long objectType) {
        return 28L == objectType || 30L == objectType || 76L == objectType || 77L == objectType || 75L == objectType || 78L == objectType || 85L == objectType || 104L == objectType || 105L == objectType || 167L == objectType;
    }

    private boolean isFolderTypeInternal(String objectTypeName) {
        return "Folder".equals(objectTypeName) || "Folder.Virtual".equals(objectTypeName) || "FavoritesFolder".equals(objectTypeName) || "SearchFolder".equals(objectTypeName) || "SystemFolder".equals(objectTypeName) || "FavoritesGroup".equals(objectTypeName) || "UserFolder".equals(objectTypeName) || "HistoryFolder".equals(objectTypeName) || "RepositoryRootFolder".equals(objectTypeName) || "Folder.SecuredData".equals(objectTypeName);
    }

    public long getFolderTypeFromFolderNode(FolderNodeInterface fni) {
        long objectTypeId = this.isVirtualFolder((PublicObjectNodeInterface)fni) ? 30L : (this.isUsersFolder((PublicObjectNodeInterface)fni) ? 85L : (this.isHistoryFolder((PublicObjectNodeInterface)fni) ? 104L : (this.isFavoritesFolder((PublicObjectNodeInterface)fni) ? 76L : (this.isFavoritesGroup((PublicObjectNodeInterface)fni) ? 78L : (this.isRepositoryRoot((PublicObjectNodeInterface)fni) ? 105L : (this.isSecuredDataFolder((PublicObjectNodeInterface)fni) ? 167L : (this.isSystemFolder((PublicObjectNodeInterface)fni) ? 75L : 28L)))))));
        return objectTypeId;
    }

    public boolean isRepositoryRoot(PublicObjectNodeInterface poni) {
        try {
            if (!(poni instanceof FolderNodeInterface)) {
                return false;
            }
            if (poni.getLevel() != 1) {
                return false;
            }
            PublicObjectContainerInterface container = poni.getContainer();
            TypeDescriptorInterface containerTypeDesc = container.getTypeDescriptor();
            if (containerTypeDesc != null && "RootFolder".equalsIgnoreCase(containerTypeDesc.getTypeName())) {
                String folderRepos;
                String rootFolderRepos = container.getIdentifier().substring(0, 8);
                return !rootFolderRepos.equalsIgnoreCase(folderRepos = poni.getIdentifier().substring(0, 8));
            }
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("Service exception - " + e.getMessage());
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("Remote exception - " + e.getMessage());
        }
        return false;
    }

    public boolean isHistoryFolder(PublicObjectNodeInterface node) {
        try {
            if (!"FavoritesFolder".equals(this.getPublicType(node))) {
                return false;
            }
            if (!"History".equals(node.getName())) {
                return false;
            }
            PublicObjectContainerInterface parent = node.getContainer();
            if (null == parent) {
                return false;
            }
            if (null == (parent = parent.getContainer())) {
                return false;
            }
            String path = parent.getPathUrl().getAbsolutePath();
            if (path == null) {
                return false;
            }
            FolderInterface appDataFolder = this.metadataTemplate.getServer().getHomeFolder(null, UserFolderType.APPFOLDER, null);
            if (appDataFolder == null) {
                return false;
            }
            return path.equals(appDataFolder.getPathUrl().getAbsolutePath());
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("Service exception - " + e.getMessage());
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("Remote exception - " + e.getMessage());
        }
    }

    public String getContentId(PublicObjectInterface poi) {
        try {
            TypeDescriptorInterface tdi = poi.getTypeDescriptor();
            String metadataType = tdi != null ? tdi.getMetadataType() : null;
            return poi.getIdentifier() + "/" + metadataType;
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("Service exception - " + e.getMessage());
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("Remote exception - " + e.getMessage());
        }
    }

    public ObjectIdentity getParentId(PublicObjectInterface poi, String path) {
        try {
            long objectType;
            PublicObjectContainerInterface parent = poi.getContainer();
            String typeName = parent.getTypeDescriptor().getTypeName();
            if ("RootFolder".equals(typeName)) {
                return new ObjectIdentity(29L, "ROOT_FOLDER_ID");
            }
            if (parent instanceof FolderNodeInterface || this.isFolderTypeInternal(typeName)) {
                if (parent instanceof FolderNodeInterface) {
                    boolean isMyFolder = false;
                    if (path != null) {
                        FolderInterface folder;
                        String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)path);
                        if (this.metadataTemplate.getMyFolderPath().equals(parentPath) && (folder = this.metadataTemplate.getServer().getHomeFolder(null, UserFolderType.MYFOLDER, null)).getIdentifier().equals(parent.getIdentifier())) {
                            isMyFolder = true;
                        }
                    }
                    objectType = isMyFolder ? 85L : this.getFolderTypeFromFolderNode((FolderNodeInterface)parent);
                } else {
                    objectType = this.getFolderTypeFromPublicObjectInternal((PublicObjectInterface)parent, typeName);
                }
            } else {
                if (typeName == null) {
                    return new ObjectIdentity(-1L, this.getContentId((PublicObjectInterface)parent));
                }
                objectType = this.getObjectTypeId(typeName);
            }
            return new ObjectIdentity(objectType, this.getContentId((PublicObjectInterface)parent));
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("Service exception - " + e.getMessage());
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("Remote exception - " + e.getMessage());
        }
    }

    private boolean isPublicObjectHistoryFolderInternal(PublicObjectInterface poi, String publicTypeName) {
        try {
            if (!"FavoritesFolder".equals(publicTypeName)) {
                return false;
            }
            if (!"History".equals(poi.getName())) {
                return false;
            }
            PublicObjectContainerInterface parent = poi.getContainer();
            if (null == parent) {
                return false;
            }
            if (null == (parent = parent.getContainer())) {
                return false;
            }
            String path = parent.getPathUrl().getAbsolutePath();
            if (path == null) {
                return false;
            }
            FolderInterface appDataFolder = this.metadataTemplate.getServer().getHomeFolder(null, UserFolderType.APPFOLDER, null);
            if (appDataFolder == null) {
                return false;
            }
            return path.equals(appDataFolder.getPathUrl().getAbsolutePath());
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("Service exception - " + e.getMessage());
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("Remote exception - " + e.getMessage());
        }
    }

    private long getFolderTypeFromPublicObjectInternal(PublicObjectInterface poi, String publicTypeName) {
        long objectTypeId = -1L;
        if (this.isPublicObjectHistoryFolderInternal(poi, publicTypeName)) {
            objectTypeId = 104L;
        } else if ("FavoritesFolder".equals(publicTypeName)) {
            objectTypeId = 76L;
        } else if ("FavoritesGroup".equals(publicTypeName)) {
            objectTypeId = 78L;
        }
        return objectTypeId;
    }

    public boolean isFavoritesGroup(PublicObjectNodeInterface node) {
        return "FavoritesGroup".equals(this.getPublicType(node));
    }

    public String getPublicType(PublicObjectNodeInterface node) {
        try {
            return node.getTypeDescriptor().getTypeName();
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("Service exception - " + e.getMessage());
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("Remote exception - " + e.getMessage());
        }
    }

    public boolean isFavoritesFolder(PublicObjectNodeInterface node) {
        return "FavoritesFolder".equals(this.getPublicType(node));
    }

    public boolean isUsersFolder(PublicObjectNodeInterface node) {
        return node instanceof UsersFolderNode;
    }

    public boolean isSystemFolder(PublicObjectNodeInterface node) {
        try {
            if (node instanceof FolderNodeInterface) {
                return "System".equals(((FolderNodeInterface)node).getFolderType());
            }
            return false;
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("Service exception - " + e.getMessage());
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("Remote exception - " + e.getMessage());
        }
    }

    public boolean isVirtualFolder(PublicObjectNodeInterface node) {
        return node instanceof VirtualFolderNodeInterface;
    }

    public boolean isSecuredDataFolder(PublicObjectNodeInterface node) {
        return "Folder.SecuredData".equalsIgnoreCase(this.getPublicType(node));
    }

    private long getObjectTypeId(String typeName) {
        ObjectType type = this.typeService.getTypeByName(typeName);
        return type == null ? -1L : type.getId();
    }
}

