/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.css.validation.util;

import com.sas.themeresources.css.validation.util.CompareSpecToThemeUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CompareSpecToThemeDescriptor {
    public static final String IMAGE_KEY_TABLE = "imageKeyTable";
    public static final String IMAGE_KEY_TABLE2 = "imageKeyTable2";

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.out.println("ERROR-BAD ARGUMENTS!!! Exiting.");
            System.exit(1);
        }
        String specificationDirectory = args[0];
        Map imageSpecMap = CompareSpecToThemeUtil.getImageSpecMap(specificationDirectory + "/html", false);
        LinkedHashMap imageDescriptorMap = new LinkedHashMap();
        for (int i = 1; i < args.length; ++i) {
            imageDescriptorMap.putAll(CompareSpecToThemeDescriptor.getImageDescriptorMap(args[i]));
        }
        for (String keyName : imageSpecMap.keySet()) {
            Object o = imageDescriptorMap.get(keyName);
            String keyValue = (String)imageSpecMap.get(keyName);
            if (o == null) {
                System.out.println("ERROR-Specification image key not found in theme descriptor:" + keyName);
                continue;
            }
            if (((String)o).equalsIgnoreCase(keyValue)) continue;
            System.out.println("ERROR-Image key '" + keyName + "' value (" + o + ") not equal to specification value (" + keyValue + ").");
        }
        System.exit(0);
    }

    public static Map getImageDescriptorMap(String filename) {
        LinkedHashMap<String, String> imageDescriptorMap = new LinkedHashMap<String, String>();
        File file = new File(filename);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.equals("http://www.sas.com/webapp/themes.dtd")) {
                        return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                    }
                    return null;
                }
            });
            try {
                Document themeDocument = db.parse(file);
                NodeList imageList = themeDocument.getElementsByTagName("Image");
                if (imageList != null) {
                    for (int i = 0; i < imageList.getLength(); ++i) {
                        Node filenameNode;
                        NamedNodeMap attributes = imageList.item(i).getAttributes();
                        Node imageKeyNode = attributes.getNamedItem("name");
                        if (imageKeyNode == null) {
                            System.out.println("ERROR-Image tag " + i + " has no name attribute.");
                        }
                        if ((filenameNode = attributes.getNamedItem("file")) == null) {
                            System.out.println("ERROR-Image tag " + i + " with name " + imageKeyNode.getNodeValue() + " has no file attribute.");
                        }
                        imageDescriptorMap.put(imageKeyNode.getNodeValue(), filenameNode.getNodeValue());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("ERROR-Parsing error " + file.getName() + " :" + e.getMessage());
            }
        }
        catch (Exception e) {
            System.out.println("ERROR-:" + e.getMessage());
        }
        return imageDescriptorMap;
    }
}

