/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.css.validation.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CheckForUnusedTemplateKeys {
    private static boolean verbose;

    public static void main(String[] args) {
        verbose = args[0].trim().equalsIgnoreCase("true");
        String contextFilename = args[1];
        Map contextKeys = CheckForUnusedTemplateKeys.readContextFile(new File(contextFilename));
        CheckForUnusedTemplateKeys.log("Checking for unused context keys from " + contextFilename);
        String templateContents = "";
        try {
            for (int i = 2; i < args.length; ++i) {
                CheckForUnusedTemplateKeys.log("Looking in template:" + args[i]);
                File templateFile = new File(args[i]);
                templateContents = templateContents + CheckForUnusedTemplateKeys.readFile(templateFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String contextKey : contextKeys.keySet()) {
            if (templateContents.contains("${" + contextKey + "}")) continue;
            CheckForUnusedTemplateKeys.error("WARNING: Unused context key : " + contextKey + " found in " + new File(contextFilename).getName());
        }
    }

    private static Map readContextFile(File file) {
        HashMap<Object, Object> contextMap = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream stream = new BufferedInputStream(fis);
            Properties props = new Properties();
            props.load(stream);
            contextMap = new HashMap<Object, Object>();
            contextMap.putAll(props);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contextMap;
    }

    public static String readFile(File file) throws IOException {
        String result = "";
        if (file.exists()) {
            result = CheckForUnusedTemplateKeys.readFromStream(new FileInputStream(file));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromStream(InputStream inputStream) throws IOException {
        StringBuffer result = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            char[] buffer = new char[4096];
            int charactersRead = 0;
            while ((charactersRead = reader.read(buffer)) != -1) {
                result.append(new String(buffer, 0, charactersRead));
            }
        }
        return result.toString();
    }

    private static void log(String message) {
        if (verbose) {
            System.out.println(message);
        }
    }

    private static void error(String message) {
        System.out.println(message);
    }
}

