/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.css.validation.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CheckForUnresolvedTemplateKeys {
    private static boolean verbose;

    public static void main(String[] args) {
        verbose = args[0].trim().equalsIgnoreCase("true");
        try {
            for (int i = 1; i < args.length; ++i) {
                CheckForUnresolvedTemplateKeys.log("Checking for unresolved template keys in " + args[i]);
                File resolvedFile = new File(args[i]);
                String fileContents = CheckForUnresolvedTemplateKeys.readFile(resolvedFile);
                if (fileContents.indexOf("${") != -1) {
                    CheckForUnresolvedTemplateKeys.error("ERROR: Unresolved template keys(\"${\") found in " + args[i]);
                    continue;
                }
                CheckForUnresolvedTemplateKeys.log("OK: " + args[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readFile(File file) throws IOException {
        String result = "";
        if (file.exists()) {
            result = CheckForUnresolvedTemplateKeys.readFromStream(new FileInputStream(file));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromStream(InputStream inputStream) throws IOException {
        StringBuffer result = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            char[] buffer = new char[4096];
            int charactersRead = 0;
            while ((charactersRead = reader.read(buffer)) != -1) {
                result.append(new String(buffer, 0, charactersRead));
            }
        }
        return result.toString();
    }

    private static void log(String message) {
        if (verbose) {
            System.out.println(message);
        }
    }

    private static void error(String message) {
        System.out.println(message);
    }
}

