/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.css.util;

import com.sas.themeresources.css.util.CSSParser;
import com.sas.themeresources.css.util.RTLRule;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;

class ShortCutStyleRule
extends RTLRule {
    private static String[] shortCutProperties = new String[]{"padding", "margin", "border-color", "border-width", "border-style"};
    private static Pattern whiteSpacePattern = Pattern.compile("(\\s)+", 32);

    ShortCutStyleRule() {
    }

    @Override
    String applyRule(String className, String string) {
        int firstColonIndex = string.indexOf(":");
        String propName = string.substring(0, firstColonIndex).trim();
        if (this.hasShortCutProperty(propName)) {
            String propValue = string.substring(firstColonIndex + 1, string.length());
            String[] propValueArray = whiteSpacePattern.split(propValue);
            if (propValueArray.length != 4) {
                return string;
            }
            StringBuffer sb = new StringBuffer(propName).append(":");
            sb.append(propValueArray[0]).append(" ");
            sb.append(propValueArray[3]).append(" ").append(propValueArray[2]).append(" ").append(propValueArray[1]);
            return sb.toString();
        }
        return string;
    }

    private boolean hasShortCutProperty(String propertyName) {
        propertyName = propertyName.toLowerCase();
        for (int i = 0; i < shortCutProperties.length; ++i) {
            if (!shortCutProperties[i].equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static Map loadCSSWithRules(File cssFile) throws IOException {
        String css = null;
        css = CSSParser.readFile(cssFile);
        css = CSSParser.stripComments(css);
        return CSSParser.bucketStyles(css, false);
    }
}

