/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.css.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CSSParser {
    private static final String FILE_ENCODING = "UTF-8";
    private static final int BUFFER_SIZE = 4096;

    public static void compareStylesheets(String file1Description, File file1, String file2Description, File file2) {
        Map styles1 = CSSParser.loadCSS(file1, true);
        Map styles2 = CSSParser.loadCSS(file2, true);
        CSSParser.compareStylesheets(file1Description, styles1, file2Description, styles2);
    }

    public static void compareStylesheets(String file1Description, Map styles1, String file2Description, Map styles2) {
        String key;
        System.out.println("The following style classes from " + file1Description + " are changed in " + file2Description);
        System.out.println("-------------------------------------------------------------------------------------------");
        Iterator it = styles1.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            key = (String)it.next();
            String styleContents1 = (String)styles1.get(key);
            boolean changed = false;
            if (styles2.containsKey(key)) {
                String styleContents2 = (String)styles2.get(key);
                Map style1Attributes = CSSParser.bucketStyleAttributes(styleContents1);
                Map style2Attributes = CSSParser.bucketStyleAttributes(styleContents2);
                for (String attributeName : style1Attributes.keySet()) {
                    String style1Value = (String)style1Attributes.get(attributeName);
                    if (style2Attributes.containsKey(attributeName)) {
                        String style2Value = (String)style2Attributes.get(attributeName);
                        if (style1Value.equalsIgnoreCase(style2Value)) continue;
                        ++i;
                        if (!changed) {
                            CSSParser.logStyleName(styles2, key, false);
                        }
                        changed = true;
                        System.out.println("    " + attributeName + " -> " + style1Value + "   changed to: " + style2Value);
                        continue;
                    }
                    ++i;
                    if (!changed) {
                        CSSParser.logStyleName(styles2, key, false);
                    }
                    changed = true;
                    System.out.println("    " + attributeName + " : " + style1Value + " is defined in " + file1Description + " but not in " + file2Description);
                }
                for (String attributeName : style2Attributes.keySet()) {
                    if (style1Attributes.containsKey(attributeName)) continue;
                    ++i;
                    if (!changed) {
                        CSSParser.logStyleName(styles2, key, false);
                    }
                    changed = true;
                    String style2Value = (String)style2Attributes.get(attributeName);
                    System.out.println("    " + attributeName + " : " + style2Value + " is defined in " + file2Description + " but not in " + file1Description);
                }
            }
            if (!changed) continue;
            System.out.println("");
        }
        System.out.println("Found " + i + " changed style classes.");
        System.out.println("");
        System.out.println("");
        System.out.println("The following style classes exist in " + file1Description + " but are not in " + file2Description);
        System.out.println("-------------------------------------------------------------------------------------------");
        it = styles1.keySet().iterator();
        i = 0;
        while (it.hasNext()) {
            key = (String)it.next();
            if (styles2.containsKey(key)) continue;
            ++i;
            CSSParser.logStyleName(styles1, key);
        }
        System.out.println("Found " + i + " missing style classes in " + file2Description);
        System.out.println("");
        System.out.println("");
        System.out.println("The following style classes exist in " + file2Description + " but are not in " + file1Description);
        System.out.println("-------------------------------------------------------------------------------------------");
        it = styles2.keySet().iterator();
        i = 0;
        while (it.hasNext()) {
            key = (String)it.next();
            if (styles1.containsKey(key)) continue;
            ++i;
            CSSParser.logStyleName(styles1, key);
        }
        System.out.println("Found " + i + " missing style classes in " + file1Description);
    }

    public static Map loadCSS(File cssFile) {
        return CSSParser.loadCSS(cssFile, false, null);
    }

    public static Map loadCSS(File cssFile, boolean individateStyleClasses) {
        return CSSParser.loadCSS(cssFile, individateStyleClasses, null);
    }

    public static Map loadCSS(File cssFile, boolean individuateStyleClasses, String[] killPatterns) {
        String css = null;
        try {
            css = CSSParser.readFile(cssFile);
            css = CSSParser.stripKillPatternMatches(css, killPatterns);
            css = CSSParser.stripComments(css);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CSSParser.bucketStyles(css, individuateStyleClasses);
    }

    public static String stripKillPatternMatches(String css, String[] killPatterns) {
        if (killPatterns == null || killPatterns.length == 0) {
            return css;
        }
        StringBuffer strippedCSS = new StringBuffer(css);
        int endOfLinePosition = CSSParser.getNextNewLine(strippedCSS.toString(), 0);
        int lineStartPosition = 0;
        while (endOfLinePosition != -1) {
            String line = strippedCSS.substring(lineStartPosition, endOfLinePosition);
            boolean lineDeleted = false;
            for (int i = 0; i < killPatterns.length; ++i) {
                if (!line.contains(killPatterns[i])) continue;
                strippedCSS.delete(lineStartPosition, endOfLinePosition + 1);
                lineDeleted = true;
                break;
            }
            if (!lineDeleted) {
                lineStartPosition = endOfLinePosition + 1;
                endOfLinePosition = CSSParser.getNextNewLine(strippedCSS.toString(), endOfLinePosition + 1);
                continue;
            }
            endOfLinePosition = CSSParser.getNextNewLine(strippedCSS.toString(), lineStartPosition);
        }
        return strippedCSS.toString();
    }

    private static int getNextNewLine(String css, int startPosition) {
        int newLinePosition = -1;
        newLinePosition = css.indexOf("\r\n", startPosition);
        if (newLinePosition == -1) {
            newLinePosition = css.indexOf("\n", startPosition);
        }
        return newLinePosition;
    }

    public static String stripComments(String css) {
        StringBuffer strippedCSS = new StringBuffer(css);
        int startPosition = css.indexOf("/*");
        int endPosition = css.indexOf("*/");
        while (startPosition != -1) {
            strippedCSS.delete(startPosition, endPosition + 2);
            startPosition = strippedCSS.toString().indexOf("/*");
            endPosition = strippedCSS.toString().indexOf("*/");
        }
        return strippedCSS.toString();
    }

    public static Map bucketStyleAttributes(String cssBlock) {
        LinkedHashMap<String, String> styleAttributes = new LinkedHashMap<String, String>();
        String temp = cssBlock.substring(cssBlock.indexOf("{") + 1);
        temp = temp.substring(0, temp.lastIndexOf("}"));
        StringBuffer styleContent = new StringBuffer(temp);
        int colonPosition = styleContent.indexOf(":");
        int eolPosition = styleContent.indexOf("\n", colonPosition + 1);
        int semiColonPosition = styleContent.indexOf(";", colonPosition + 1);
        if (semiColonPosition > eolPosition) {
            semiColonPosition = eolPosition;
        }
        while (colonPosition != -1) {
            if ((semiColonPosition > eolPosition || semiColonPosition == -1) && (semiColonPosition = eolPosition) == -1) {
                semiColonPosition = styleContent.length();
            }
            String attributeName = styleContent.substring(0, colonPosition).trim();
            String attributeValue = styleContent.substring(colonPosition + 1, semiColonPosition).trim();
            styleAttributes.put(attributeName, attributeValue);
            styleContent.delete(0, semiColonPosition + 1);
            colonPosition = styleContent.indexOf(":");
            eolPosition = styleContent.indexOf("\n", colonPosition + 1);
            semiColonPosition = styleContent.indexOf(";", colonPosition + 1);
        }
        return styleAttributes;
    }

    public static Map bucketStyles(String css, boolean individuateStyleClasses) {
        LinkedHashMap<String, String> styles = new LinkedHashMap<String, String>();
        StringBuffer strippedCSS = new StringBuffer(css);
        int startPosition = css.indexOf("{");
        int endPosition = CSSParser.getMatchingEndBracePosition(strippedCSS.toString(), startPosition);
        while (startPosition != -1) {
            String classNames = strippedCSS.substring(0, startPosition).trim();
            String styleDefinition = strippedCSS.substring(startPosition, endPosition + 1);
            if (individuateStyleClasses) {
                String[] styleclasses = classNames.split(",");
                for (int i = 0; i < styleclasses.length; ++i) {
                    styles.put(styleclasses[i].trim(), styleDefinition);
                }
            } else {
                styles.put(classNames, styleDefinition);
            }
            strippedCSS.delete(0, endPosition + 1);
            startPosition = strippedCSS.toString().indexOf("{");
            endPosition = CSSParser.getMatchingEndBracePosition(strippedCSS.toString(), startPosition);
        }
        return styles;
    }

    public static void logStyleName(Map styleBuckets, String key) {
        CSSParser.logStyleName(styleBuckets, key, false);
    }

    public static void logStyleName(Map styleBuckets, String key, boolean detailed) {
        System.out.println("-------> " + key);
        if (detailed) {
            System.out.println((String)styleBuckets.get(key));
        }
    }

    public static int getMatchingEndBracePosition(String css, int startBracePosition) {
        int endBracePosition = css.indexOf("}", startBracePosition);
        int nextOpenBracePosition = css.indexOf("{", startBracePosition + 1);
        if (nextOpenBracePosition != -1 && nextOpenBracePosition < endBracePosition) {
            endBracePosition = CSSParser.getMatchingEndBracePosition(css, endBracePosition + 1);
        }
        return endBracePosition;
    }

    public static String readFile(File file) throws IOException {
        String result = "";
        if (file.exists()) {
            result = CSSParser.readFromStream(new FileInputStream(file));
        } else {
            System.out.println("Unable to locate file: " + file);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromStream(InputStream inputStream) throws IOException {
        StringBuffer result = new StringBuffer();
        try (Reader reader = CSSParser.newReader(inputStream);){
            char[] buffer = new char[4096];
            int charactersRead = 0;
            while ((charactersRead = reader.read(buffer)) != -1) {
                result.append(new String(buffer, 0, charactersRead));
            }
        }
        return result.toString();
    }

    public static Reader newReader(InputStream stream) throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(stream, FILE_ENCODING));
    }

    public static void writeFile(File file, String input) throws IOException {
        CSSParser.writeToStream(new FileOutputStream(file), input);
    }

    public static void writeToStream(OutputStream outputStream, String input) throws IOException {
        try (Writer writer = CSSParser.newWriter(outputStream);){
            writer.write(input);
        }
    }

    public static Writer newWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter(outputStream, FILE_ENCODING));
    }
}

