/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.css.util;

import com.sas.themeresources.css.util.CSSParser;
import com.sas.themeresources.css.util.RTLRule;
import com.sas.themeresources.css.util.ReplaceDirectionRule;
import com.sas.themeresources.css.util.ShortCutStyleRule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class CSS {
    private static final String SEMICOLON = ";";
    private static final String lineSeparator = System.getProperty("line.separator", "\n");
    private static String spacer = "    ";
    private static String WHITE_SPACE = " ";
    private static String IMPORT_KEYWD = "@import";
    private static String MEDIA_KEYWD = "@media";
    private static String PAGE_KEYWD = "@page";
    private static RTLRule[] rtlRules = new RTLRule[]{new ReplaceDirectionRule(), new ShortCutStyleRule()};
    private List importRules;
    private List mediaRules;
    private List pageRules;
    private DefaultStyles defaultStyles;

    CSS() {
    }

    public void addToImportRules(ImportRule ir) {
        if (this.importRules == null) {
            this.importRules = new ArrayList();
        }
        this.importRules.add(ir);
    }

    public void addToMediaRules(MediaRule mr) {
        if (this.mediaRules == null) {
            this.mediaRules = new ArrayList();
        }
        this.mediaRules.add(mr);
    }

    public void addToPageRules(PageRule pr) {
        if (this.pageRules == null) {
            this.pageRules = new ArrayList();
        }
        this.pageRules.add(pr);
    }

    private String list2String(List list) {
        if (list == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i).toString()).append(lineSeparator);
        }
        return sb.toString();
    }

    public static CSS parse(File cssFile) throws IOException {
        System.out.println("Loading the CSS file...");
        String cssFileAsString = CSSParser.readFile(cssFile);
        cssFileAsString = CSSParser.stripComments(cssFileAsString);
        StringBuffer cssFileSb = new StringBuffer(cssFileAsString);
        CSS cssObj = new CSS();
        while (true) {
            int importIndex;
            if ((importIndex = cssFileSb.indexOf(IMPORT_KEYWD)) == -1) {
                importIndex = cssFileSb.indexOf(IMPORT_KEYWD.toUpperCase());
            }
            if (importIndex == -1) break;
            int importValueIndex = cssFileSb.indexOf(SEMICOLON, importIndex + 1);
            String importKeyword = cssFileSb.substring(importIndex, importIndex + IMPORT_KEYWD.length()).trim();
            String importValue = cssFileSb.substring(importIndex + IMPORT_KEYWD.length(), importValueIndex).trim();
            cssFileSb.delete(importIndex, importValueIndex + 1);
            CSS cSS = cssObj;
            Objects.requireNonNull(cSS);
            cssObj.addToImportRules(cSS.new ImportRule(importKeyword, importValue));
        }
        while (true) {
            int mediaIndex;
            if ((mediaIndex = cssFileSb.indexOf(MEDIA_KEYWD)) == -1) {
                mediaIndex = cssFileSb.indexOf(MEDIA_KEYWD.toUpperCase());
            }
            if (mediaIndex == -1) break;
            int mediaBraceStartPos = cssFileSb.indexOf("{", mediaIndex + 1);
            String mediaKW = cssFileSb.substring(mediaIndex, mediaIndex + MEDIA_KEYWD.length()).trim();
            String mediaType = cssFileSb.substring(mediaIndex + MEDIA_KEYWD.length(), mediaBraceStartPos).trim();
            int mediaBraceEndPos = CSSParser.getMatchingEndBracePosition(cssFileSb.toString(), mediaBraceStartPos);
            String mediaCSS = cssFileSb.substring(mediaBraceStartPos + 1, mediaBraceEndPos).trim();
            cssFileSb.delete(mediaIndex, mediaBraceEndPos + 1);
            CSS cSS = cssObj;
            Objects.requireNonNull(cSS);
            cssObj.addToMediaRules(cSS.new MediaRule(mediaKW, mediaType, mediaCSS));
        }
        while (true) {
            int pageIndex;
            if ((pageIndex = cssFileSb.indexOf(PAGE_KEYWD)) == -1) {
                pageIndex = cssFileSb.indexOf(PAGE_KEYWD.toUpperCase());
            }
            if (pageIndex == -1) break;
            int pageBraceStartPos = cssFileSb.indexOf("{", pageIndex + 1);
            String pageKW = cssFileSb.substring(pageIndex, pageIndex + PAGE_KEYWD.length()).trim();
            String pageSelector = cssFileSb.substring(pageIndex + PAGE_KEYWD.length(), pageBraceStartPos).trim();
            int pageBraceEndPos = CSSParser.getMatchingEndBracePosition(cssFileSb.toString(), pageBraceStartPos);
            String pageCSS = new StringBuffer("{").append(cssFileSb.substring(pageBraceStartPos + 1, pageBraceEndPos).trim()).append("}").toString();
            cssFileSb.delete(pageIndex, pageBraceEndPos + 1);
            CSS cSS = cssObj;
            Objects.requireNonNull(cSS);
            cssObj.addToPageRules(cSS.new PageRule(pageKW, pageSelector, pageCSS));
        }
        CSS cSS = cssObj;
        Objects.requireNonNull(cSS);
        cssObj.defaultStyles = cSS.new DefaultStyles(cssFileSb.toString());
        return cssObj;
    }

    public void transformToRTL() {
        if (this.mediaRules != null) {
            for (int i = 0; i < this.mediaRules.size(); ++i) {
                this.transformToRTL(((MediaRule)this.mediaRules.get(i)).getStyleClasses());
            }
        }
        if (this.defaultStyles != null) {
            this.transformToRTL(this.defaultStyles.getStyleClasses());
        }
    }

    private void transformToRTL(Map css) {
        Iterator classNamesItr = css.keySet().iterator();
        StringBuffer classDetails = new StringBuffer();
        while (classNamesItr.hasNext()) {
            String className = classNamesItr.next().toString();
            Map cssAttributes = CSSParser.bucketStyleAttributes(css.get(className).toString());
            classDetails.append(" {").append(lineSeparator);
            Iterator propertyNamesItr = cssAttributes.keySet().iterator();
            while (propertyNamesItr.hasNext()) {
                String propertyName = propertyNamesItr.next().toString();
                String property = new StringBuffer(propertyName).append(":").append(cssAttributes.get(propertyName).toString()).toString();
                for (int i = 0; i < rtlRules.length; ++i) {
                    property = rtlRules[i].applyRule(className, property);
                }
                classDetails.append(spacer).append(property);
                classDetails.append(SEMICOLON).append(lineSeparator);
            }
            classDetails.append("}" + lineSeparator);
            css.put(className, classDetails.toString());
            classDetails.delete(0, classDetails.length());
        }
    }

    private static String writeToString(Map css) {
        Iterator classNamesItr = css.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        while (classNamesItr.hasNext()) {
            String className = classNamesItr.next().toString();
            sb.append(className);
            sb.append(css.get(className).toString()).append(lineSeparator);
        }
        return sb.toString();
    }

    public void writeToFile(File file) throws IOException {
        System.out.println("Writing  to RTL CSS file...");
        StringBuffer sb = new StringBuffer("/* This is auto generated file. Kindly avoid making changes directly in this file.*/");
        sb.append(this.list2String(this.importRules)).append(lineSeparator);
        sb.append(this.list2String(this.pageRules)).append(lineSeparator);
        sb.append(this.list2String(this.mediaRules)).append(lineSeparator);
        sb.append(this.defaultStyles.toString()).append(lineSeparator);
        CSSParser.writeFile(file, sb.toString());
    }

    private class ImportRule {
        String keyword;
        String value;

        public ImportRule(String ruleName, String value) {
            this.keyword = ruleName;
            this.value = value;
        }

        public String toString() {
            return new StringBuffer(this.keyword).append(WHITE_SPACE).append(this.value).append(CSS.SEMICOLON).toString();
        }
    }

    private class MediaRule {
        String keyword;
        String mediaType;
        String mediaStyles;
        Map styleClasses;

        public MediaRule(String ruleName, String mediaType, String mediaStyles) {
            this.keyword = ruleName;
            this.mediaType = mediaType;
            this.mediaStyles = mediaStyles;
            this.styleClasses = CSSParser.bucketStyles(mediaStyles, false);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.keyword);
            sb.append(WHITE_SPACE).append(this.mediaType).append(WHITE_SPACE).append(" {").append(lineSeparator);
            sb.append(CSS.writeToString(this.styleClasses)).append(lineSeparator).append("}");
            return sb.toString();
        }

        public Map getStyleClasses() {
            return this.styleClasses;
        }
    }

    private class PageRule {
        String keyword;
        String pageSelector;
        String pageStyles;
        Map styleClasses;

        public PageRule(String keyword, String pageSelector, String pageStyles) {
            this.keyword = keyword;
            this.pageSelector = pageSelector;
            this.pageStyles = pageStyles;
            this.styleClasses = CSSParser.bucketStyleAttributes(pageStyles);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.keyword);
            sb.append(WHITE_SPACE).append(this.pageSelector).append(WHITE_SPACE).append(" {").append(lineSeparator);
            Iterator itr = this.styleClasses.keySet().iterator();
            while (itr.hasNext()) {
                String propName = itr.next().toString();
                String propVal = this.styleClasses.get(propName).toString();
                sb.append(spacer).append(propName).append(":").append(propVal).append(lineSeparator);
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private class DefaultStyles {
        String stylesString;
        Map styleClasses;

        public DefaultStyles(String styles) {
            this.stylesString = styles;
            this.styleClasses = CSSParser.bucketStyles(styles, false);
        }

        public String toString() {
            return CSS.writeToString(this.styleClasses);
        }

        public Map getStyleClasses() {
            return this.styleClasses;
        }
    }
}

