/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.security.wss4j;

import com.sas.svcs.commons.webservice.impl.security.wss4j.SASUsernameTokenProcessor;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.callback.CallbackLookup;
import org.apache.wss4j.dom.callback.DOMCallbackLookup;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.saml.DOMSAMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SASWSSecurityEngine
extends WSSecurityEngine {
    private static final Logger LOG = LogManager.getLogger(SASWSSecurityEngine.class);

    public WSHandlerResult processSecurityHeader(Element securityHeader, RequestData requestData) throws WSSecurityException {
        if (securityHeader == null) {
            List results = Collections.emptyList();
            Map actionResults = Collections.emptyMap();
            return new WSHandlerResult(null, results, actionResults);
        }
        if (requestData.getWssConfig() == null) {
            requestData.setWssConfig(this.getWssConfig());
        }
        WSDocInfo wsDocInfo = new WSDocInfo(securityHeader.getOwnerDocument());
        CallbackLookup callbackLookupToUse = this.getCallbackLookup();
        if (callbackLookupToUse == null) {
            callbackLookupToUse = new DOMCallbackLookup(securityHeader.getOwnerDocument());
        }
        wsDocInfo.setCallbackLookup(callbackLookupToUse);
        wsDocInfo.setCrypto(requestData.getSigVerCrypto());
        wsDocInfo.setSecurityHeader(securityHeader);
        requestData.setWsDocInfo(wsDocInfo);
        WSSConfig cfg = this.getWssConfig();
        Node node = securityHeader.getFirstChild();
        LinkedList returnResults = new LinkedList();
        boolean foundTimestamp = false;
        while (node != null) {
            Node nextSibling = node.getNextSibling();
            if (1 == node.getNodeType()) {
                QName el = new QName(node.getNamespaceURI(), node.getLocalName());
                if (foundTimestamp && el.equals(WSConstants.TIMESTAMP)) {
                    requestData.getBSPEnforcer().handleBSPRule(BSPRule.R3227);
                } else if (el.equals(WSConstants.TIMESTAMP)) {
                    foundTimestamp = true;
                }
                Processor p = cfg.getProcessor(el);
                if (WSConstants.USERNAME_TOKEN.equals(el)) {
                    p = new SASUsernameTokenProcessor();
                }
                if (p != null) {
                    List results = p.handleToken((Element)node, requestData);
                    if (!results.isEmpty()) {
                        returnResults.addAll(0, results);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Unknown Element: " + node.getLocalName() + " " + node.getNamespaceURI());
                }
            }
            if (node.getNextSibling() == null && nextSibling != null && nextSibling.getParentNode() != null) {
                node = nextSibling;
                continue;
            }
            node = node.getNextSibling();
        }
        WSHandlerResult handlerResult = new WSHandlerResult(requestData.getActor(), returnResults, wsDocInfo.getActionResults());
        if (requestData.isValidateSamlSubjectConfirmation()) {
            Element bodyElement = callbackLookupToUse.getSOAPBody();
            DOMSAMLUtil.validateSAMLResults((WSHandlerResult)handlerResult, (Certificate[])requestData.getTlsCerts(), (Element)bodyElement);
        }
        wsDocInfo.clear();
        return handlerResult;
    }
}

