/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.security.wss4j;

import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.SoapEndpointInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Deprecated
public class SASDigestAndPlainTextUsernameTokenSecurityInterceptor
implements SoapEndpointInterceptor,
InitializingBean {
    private static final Logger logger = LogManager.getLogger(SASDigestAndPlainTextUsernameTokenSecurityInterceptor.class);
    private static final String WSSE_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSSE_SECURITY_ELEMENT = "Security";
    private static final String WSSE_USERNAMETOKEN_ELEMENT = "UsernameToken";
    private static final String WSSE_PASSWORD_ELEMENT = "Password";
    private static final String WSSE_PASSWORD_TYPE_ATTR = "Type";
    private static final String WSSE_PASSWORD_DIGEST_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
    private static final String SECURITY_TYPE_PROPERTY = "SecurityTypeProperty";
    private static final int SECURITY_TYPE_NONE = 0;
    private static final int SECURITY_TYPE_PASSWORDTEXT = 1;
    private static final int SECURITY_TYPE_PASSWORDDIGEST = 2;
    private DocumentBuilderFactory _docBuilderFactory = DocumentBuilderFactory.newInstance();
    private TransformerFactory _transformerFactory = TransformerFactory.newInstance();
    private SoapEndpointInterceptor _passwordDigestInterceptor;
    private SoapEndpointInterceptor _passwordTextInterceptor;

    public void setPasswordDigestInterceptor(SoapEndpointInterceptor passwordDigestInterceptor) {
        this._passwordDigestInterceptor = passwordDigestInterceptor;
    }

    public void setPasswordTextInterceptor(SoapEndpointInterceptor passwordTextInterceptor) {
        this._passwordTextInterceptor = passwordTextInterceptor;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this._passwordDigestInterceptor, (String)"passwordDigestInterceptor is required");
        Assert.notNull((Object)this._passwordTextInterceptor, (String)"passwordTextInterceptor is required");
        logger.warn("Use of deprecated class " + SASDigestAndPlainTextUsernameTokenSecurityInterceptor.class.getName());
    }

    public boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        int securityType = this.getSecurityType(messageContext);
        messageContext.setProperty(SECURITY_TYPE_PROPERTY, (Object)new Integer(securityType));
        if (securityType == 2) {
            if (logger.isInfoEnabled()) {
                logger.info("PasswordDigest username security token found.");
            }
            return this._passwordDigestInterceptor.handleRequest(messageContext, endpoint);
        }
        if (securityType == 1) {
            if (logger.isInfoEnabled()) {
                logger.info("PasswordText username security token found.");
            }
            return this._passwordTextInterceptor.handleRequest(messageContext, endpoint);
        }
        if (logger.isInfoEnabled()) {
            logger.info("No security token found.");
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        int securityType = (Integer)messageContext.getProperty(SECURITY_TYPE_PROPERTY);
        if (securityType == 2) {
            if (logger.isInfoEnabled()) {
                logger.info("PasswordDigest username security token found.");
            }
            return this._passwordDigestInterceptor.handleResponse(messageContext, endpoint);
        }
        if (securityType == 1) {
            if (logger.isInfoEnabled()) {
                logger.info("PasswordText username security token found.");
            }
            return this._passwordTextInterceptor.handleResponse(messageContext, endpoint);
        }
        if (logger.isInfoEnabled()) {
            logger.info("No security token found.");
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        int securityType = (Integer)messageContext.getProperty(SECURITY_TYPE_PROPERTY);
        if (securityType == 2) {
            if (logger.isInfoEnabled()) {
                logger.info("PasswordDigest username security token found.");
            }
            return this._passwordDigestInterceptor.handleFault(messageContext, endpoint);
        }
        if (securityType == 1) {
            if (logger.isInfoEnabled()) {
                logger.info("PasswordText username security token found.");
            }
            return this._passwordTextInterceptor.handleFault(messageContext, endpoint);
        }
        if (logger.isInfoEnabled()) {
            logger.info("No security token found.");
        }
        return true;
    }

    public boolean understands(SoapHeaderElement header) {
        return this._passwordTextInterceptor.understands(header);
    }

    private int getSecurityType(MessageContext messageContext) throws Exception {
        int securityType = 0;
        SoapMessage soapMessage = (SoapMessage)messageContext.getRequest();
        SoapHeader header = soapMessage.getSoapHeader();
        if (header == null) {
            return securityType;
        }
        Iterator iter = header.examineAllHeaderElements();
        while (iter.hasNext()) {
            Element usernameTokenElem;
            Element securityElem;
            SoapHeaderElement headerElement = (SoapHeaderElement)iter.next();
            Source source = headerElement.getSource();
            Document doc = this._docBuilderFactory.newDocumentBuilder().newDocument();
            DOMResult domResult = new DOMResult(doc);
            this._transformerFactory.newTransformer().transform(source, domResult);
            NodeList nodeList = doc.getElementsByTagNameNS(WSSE_NS, WSSE_SECURITY_ELEMENT);
            if (nodeList == null || nodeList.getLength() != 1 || (nodeList = (securityElem = (Element)nodeList.item(0)).getElementsByTagNameNS(WSSE_NS, WSSE_USERNAMETOKEN_ELEMENT)) == null || nodeList.getLength() != 1 || (nodeList = (usernameTokenElem = (Element)nodeList.item(0)).getElementsByTagNameNS(WSSE_NS, WSSE_PASSWORD_ELEMENT)) == null || nodeList.getLength() != 1) continue;
            Element passwordElem = (Element)nodeList.item(0);
            String passwordTypeAttr = passwordElem.getAttribute(WSSE_PASSWORD_TYPE_ATTR);
            if (passwordTypeAttr != null && passwordTypeAttr.equals(WSSE_PASSWORD_DIGEST_TYPE)) {
                securityType = 2;
                break;
            }
            securityType = 1;
            break;
        }
        return securityType;
    }

    public void afterCompletion(MessageContext messageContext, Object endpoint, Exception ex) throws Exception {
    }
}

