/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.security.wss4j;

import com.sas.svcs.security.authentication.web.RevokableAuthentication;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.web.authentication.ServiceAuthenticationDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.wss4j2.callback.AbstractWsPasswordCallbackHandler;
import org.springframework.ws.soap.security.wss4j2.callback.UsernameTokenPrincipalCallback;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.http.HttpServletConnection;

public class PlainTextPasswordValidationCallbackHandler
extends AbstractWsPasswordCallbackHandler {
    private static final Logger logger = LogManager.getLogger(PlainTextPasswordValidationCallbackHandler.class);
    private AuthenticationManager authenticationManager;
    @Autowired
    private AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource;
    private boolean ignoreFailure = false;
    private Map<String, String> tokenStore;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager is required");
    }

    public void setSecurityTokenStore(Map<String, String> tokenStore) {
        this.tokenStore = tokenStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCleanup(CleanupCallback callback) throws IOException, UnsupportedCallbackException {
        try {
            RevokableAuthentication revokableAuthentication;
            SecurityContext context = SecurityContextHolder.getContext();
            if (null != context && context.getAuthentication() instanceof RevokableAuthentication && (revokableAuthentication = (RevokableAuthentication)context.getAuthentication()).isStateless()) {
                revokableAuthentication.revoke();
            }
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    protected void setDetails(AbstractAuthenticationToken auth) {
        WebServiceConnection wsc;
        TransportContext tc = TransportContextHolder.getTransportContext();
        if (null != tc && (wsc = tc.getConnection()) instanceof HttpServletConnection) {
            auth.setDetails(this.authenticationDetailsSource.buildDetails((Object)((HttpServletConnection)wsc).getHttpServletRequest()));
        }
    }

    protected void handleUsernameToken(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(callback.getType())) {
            this.handleUsernameTokenUnknown(callback);
            return;
        }
        if (null == this.tokenStore) {
            throw new UnsupportedCallbackException((Callback)callback, WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE.toString() + " Security token store not configured");
        }
        String identifier = callback.getIdentifier();
        String token = this.tokenStore.get(identifier);
        if (null == token) {
            throw new UnsupportedCallbackException((Callback)callback, WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN.toString());
        }
        callback.setPassword(token);
    }

    protected void handleUsernameTokenPrincipal(UsernameTokenPrincipalCallback callback) throws IOException, UnsupportedCallbackException {
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(callback.getPrincipal().getPasswordType()) && null != this.tokenStore) {
            WSUsernameTokenPrincipalImpl principal = callback.getPrincipal();
            if (null == principal) {
                throw new UnsupportedCallbackException((Callback)callback, WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN.toString());
            }
            String principalName = principal.getName();
            if (!StringUtils.hasText((String)principalName)) {
                throw new UnsupportedCallbackException((Callback)callback, WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN.toString());
            }
            String token = this.tokenStore.get(principalName);
            if (null != token) {
                try {
                    this.authenticate(principalName, token);
                }
                catch (WSSecurityException failed) {
                    throw new UnsupportedCallbackException((Callback)callback, failed.getMessage());
                }
            }
        }
    }

    protected void authenticate(String principal, String credential) throws WSSecurityException {
        block4: {
            try {
                UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)principal, (Object)credential);
                this.setDetails((AbstractAuthenticationToken)token);
                Authentication authResult = this.authenticationManager.authenticate((Authentication)token);
                if (logger.isDebugEnabled()) {
                    logger.debug("Authentication success: " + authResult.toString());
                }
                SecurityContextHolder.getContext().setAuthentication(authResult);
            }
            catch (AuthenticationException failed) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Authentication request for user '" + principal + "' failed: " + failed.toString());
                }
                SecurityContextHolder.clearContext();
                if (this.ignoreFailure) break block4;
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, (Exception)((Object)failed));
            }
        }
    }

    protected void handleUsernameTokenUnknown(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        try {
            String identifier = callback.getIdentifier();
            this.authenticate(identifier, callback.getPassword());
        }
        catch (WSSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UnsupportedCallbackException((Callback)callback, e.getMessage());
        }
    }
}

