/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.security;

import com.sas.svcs.commons.webservice.impl.security.SecurityUtils;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.SoapEndpointInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Deprecated
public class SASSsoAndPlainTextSecurityInterceptor
implements SoapEndpointInterceptor,
InitializingBean {
    private static final Logger logger = LogManager.getLogger(SASSsoAndPlainTextSecurityInterceptor.class);
    private static final String WSSE_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSSE_SECURITY_ELEMENT = "Security";
    private static final String WSSE_USERNAMETOKEN_ELEMENT = "UsernameToken";
    private static final String WSSE_PASSWORD_ELEMENT = "Password";
    private static final String WSSE_PASSWORD_TYPE_ATTR = "Type";
    private static final String WSSE_PASSWORD_TEXT_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    private static final String SAS_NS = "http://www.sas.com";
    private static final String SAS_TICKET_ELEMENT = "CasTicket";
    private static final String SECURITY_TYPE_PROPERTY = "SecurityTypeProperty";
    private static final int SECURITY_TYPE_NONE = 0;
    private static final int SECURITY_TYPE_PASSWORDTEXT = 1;
    private static final int SECURITY_TYPE_SSO = 2;
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private SoapEndpointInterceptor ssoInterceptor;
    private SoapEndpointInterceptor passwordTextInterceptor;
    protected boolean securityOptional;

    public SASSsoAndPlainTextSecurityInterceptor() {
        logger.warn("Use of deprecated class " + SASSsoAndPlainTextSecurityInterceptor.class.getName());
        this.docBuilderFactory.setValidating(false);
        this.docBuilderFactory.setNamespaceAware(true);
    }

    public void setSsoInterceptor(SoapEndpointInterceptor ssoInterceptor) {
        this.ssoInterceptor = ssoInterceptor;
    }

    public void setPasswordTextInterceptor(SoapEndpointInterceptor passwordTextInterceptor) {
        this.passwordTextInterceptor = passwordTextInterceptor;
    }

    public void setSecurityOptional(boolean securityOptional) {
        this.securityOptional = securityOptional;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.ssoInterceptor != null || this.passwordTextInterceptor != null ? 1 : 0) != 0, (String)"");
    }

    public boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        int securityType = this.getSecurityType(messageContext);
        messageContext.setProperty(SECURITY_TYPE_PROPERTY, (Object)new Integer(securityType));
        if (securityType == 2) {
            if (logger.isInfoEnabled()) {
                logger.info("SSO Security Ticket found");
            }
            return this.ssoInterceptor.handleRequest(messageContext, endpoint);
        }
        if (securityType == 1) {
            if (logger.isInfoEnabled()) {
                logger.info("PlainText username/password Security Token found");
            }
            return this.passwordTextInterceptor.handleRequest(messageContext, endpoint);
        }
        if (logger.isInfoEnabled()) {
            logger.info("No security token found.");
        }
        if (this.securityOptional) {
            return true;
        }
        return null != SecurityUtils.getRemoteUser();
    }

    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        int securityType = (Integer)messageContext.getProperty(SECURITY_TYPE_PROPERTY);
        if (securityType == 2) {
            if (logger.isInfoEnabled()) {
                logger.info("SSO Security Ticket found");
            }
            return this.ssoInterceptor.handleResponse(messageContext, endpoint);
        }
        if (securityType == 1) {
            if (logger.isInfoEnabled()) {
                logger.info("PlainText username/password Security Token found");
            }
            return this.passwordTextInterceptor.handleResponse(messageContext, endpoint);
        }
        if (logger.isInfoEnabled()) {
            logger.info("No security token found.");
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        int securityType = (Integer)messageContext.getProperty(SECURITY_TYPE_PROPERTY);
        if (securityType == 2) {
            if (logger.isInfoEnabled()) {
                logger.info("SSO Security Ticket found");
            }
            return this.ssoInterceptor.handleFault(messageContext, endpoint);
        }
        if (securityType == 1) {
            if (logger.isInfoEnabled()) {
                logger.info("PlainText username/password Security Token found");
            }
            return this.passwordTextInterceptor.handleFault(messageContext, endpoint);
        }
        if (logger.isInfoEnabled()) {
            logger.info("No security token found.");
        }
        return true;
    }

    public boolean understands(SoapHeaderElement header) {
        if (null != this.passwordTextInterceptor) {
            return this.passwordTextInterceptor.understands(header);
        }
        if (null != this.ssoInterceptor) {
            return this.ssoInterceptor.understands(header);
        }
        return false;
    }

    private int getSecurityType(MessageContext messageContext) throws Exception {
        int securityType = 0;
        SoapMessage soapMessage = (SoapMessage)messageContext.getRequest();
        SoapHeader header = soapMessage.getSoapHeader();
        if (header == null) {
            return securityType;
        }
        Iterator iter = header.examineAllHeaderElements();
        while (iter.hasNext()) {
            Element usernameTokenElem;
            SoapHeaderElement headerElement = (SoapHeaderElement)iter.next();
            Source source = headerElement.getSource();
            Document doc = this.docBuilderFactory.newDocumentBuilder().newDocument();
            DOMResult domResult = new DOMResult(doc);
            this.transformerFactory.newTransformer().transform(source, domResult);
            NodeList nodeList = doc.getElementsByTagNameNS(WSSE_NS, WSSE_SECURITY_ELEMENT);
            if (nodeList == null || nodeList.getLength() != 1) continue;
            Element securityElem = (Element)nodeList.item(0);
            if ((nodeList = securityElem.getElementsByTagNameNS(WSSE_NS, WSSE_USERNAMETOKEN_ELEMENT)) != null && nodeList.getLength() == 1 && (nodeList = (usernameTokenElem = (Element)nodeList.item(0)).getElementsByTagNameNS(WSSE_NS, WSSE_PASSWORD_ELEMENT)) != null && nodeList.getLength() == 1) {
                Element passwordElem = (Element)nodeList.item(0);
                String passwordTypeAttr = passwordElem.getAttribute(WSSE_PASSWORD_TYPE_ATTR);
                if (passwordTypeAttr == null || !passwordTypeAttr.equals(WSSE_PASSWORD_TEXT_TYPE)) break;
                securityType = 1;
                break;
            }
            nodeList = securityElem.getElementsByTagNameNS(SAS_NS, SAS_TICKET_ELEMENT);
            if (nodeList == null || nodeList.getLength() != 1) continue;
            Element ticketElem = (Element)nodeList.item(0);
            securityType = 2;
            messageContext.setProperty(SAS_TICKET_ELEMENT, (Object)ticketElem.getTextContent());
            break;
        }
        return securityType;
    }

    public void afterCompletion(MessageContext messageContext, Object endpoint, Exception ex) throws Exception {
    }
}

