/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.security;

import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.SoapEndpointInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Deprecated
public class SASDigestAndPlainTextSecurityInterceptor
implements SoapEndpointInterceptor,
InitializingBean {
    private static final Logger logger = LogManager.getLogger(SASDigestAndPlainTextSecurityInterceptor.class);
    private static final String WSSE_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSSE_SECURITY_ELEMENT = "Security";
    private static final String WSSE_USERNAMETOKEN_ELEMENT = "UsernameToken";
    private static final String WSSE_PASSWORD_ELEMENT = "Password";
    private static final String WSSE_PASSWORD_TYPE_ATTR = "Type";
    private static final String WSSE_PASSWORD_DIGEST_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
    private static final String SECURITY_TYPE_PROPERTY = "SecurityTypeProperty";
    private static final int SECURITY_TYPE_NONE = 0;
    private static final int SECURITY_TYPE_PASSWORDTEXT = 1;
    private static final int SECURITY_TYPE_PASSWORDDIGEST = 2;
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private SoapEndpointInterceptor passwordDigestInterceptor;
    private SoapEndpointInterceptor passwordTextInterceptor;
    protected boolean securityOptional;

    public SASDigestAndPlainTextSecurityInterceptor() {
        logger.warn("Use of deprecated class " + SASDigestAndPlainTextSecurityInterceptor.class.getName());
        this.docBuilderFactory.setValidating(false);
        this.docBuilderFactory.setNamespaceAware(true);
    }

    public void setPasswordDigestInterceptor(SoapEndpointInterceptor passwordDigestInterceptor) {
        this.passwordDigestInterceptor = passwordDigestInterceptor;
    }

    public void setPasswordTextInterceptor(SoapEndpointInterceptor passwordTextInterceptor) {
        this.passwordTextInterceptor = passwordTextInterceptor;
    }

    public void setSecurityOptional(boolean securityOptional) {
        this.securityOptional = securityOptional;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.passwordDigestInterceptor != null || this.passwordTextInterceptor != null ? 1 : 0) != 0, (String)"");
    }

    public boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        int securityType = this.getSecurityType(messageContext);
        messageContext.setProperty(SECURITY_TYPE_PROPERTY, (Object)new Integer(securityType));
        if (securityType == 2) {
            if (logger.isInfoEnabled()) {
                logger.info("PasswordDigest Security Token found");
            }
            return this.passwordDigestInterceptor.handleRequest(messageContext, endpoint);
        }
        if (securityType == 1) {
            if (logger.isInfoEnabled()) {
                logger.info("PlainText username/password Security Token found");
            }
            return this.passwordTextInterceptor.handleRequest(messageContext, endpoint);
        }
        if (logger.isInfoEnabled()) {
            logger.info("No security token found.");
        }
        return this.securityOptional;
    }

    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        int securityType = (Integer)messageContext.getProperty(SECURITY_TYPE_PROPERTY);
        if (securityType == 2) {
            if (logger.isInfoEnabled()) {
                logger.info("PasswordDigest Security Token found");
            }
            return this.passwordDigestInterceptor.handleResponse(messageContext, endpoint);
        }
        if (securityType == 1) {
            if (logger.isInfoEnabled()) {
                logger.info("PlainText username/password Security Token found");
            }
            return this.passwordTextInterceptor.handleResponse(messageContext, endpoint);
        }
        if (logger.isInfoEnabled()) {
            logger.info("No security token found.");
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        int securityType = (Integer)messageContext.getProperty(SECURITY_TYPE_PROPERTY);
        if (securityType == 2) {
            if (logger.isInfoEnabled()) {
                logger.info("PasswordDigest Security Token found");
            }
            return this.passwordDigestInterceptor.handleFault(messageContext, endpoint);
        }
        if (securityType == 1) {
            if (logger.isInfoEnabled()) {
                logger.info("PlainText username/password Security Token found");
            }
            return this.passwordTextInterceptor.handleFault(messageContext, endpoint);
        }
        if (logger.isInfoEnabled()) {
            logger.info("No security token found.");
        }
        return true;
    }

    public boolean understands(SoapHeaderElement header) {
        if (this.passwordDigestInterceptor != null) {
            return this.passwordDigestInterceptor.understands(header);
        }
        return this.passwordTextInterceptor.understands(header);
    }

    private int getSecurityType(MessageContext messageContext) throws Exception {
        int securityType = 0;
        SoapMessage soapMessage = (SoapMessage)messageContext.getRequest();
        SoapHeader header = soapMessage.getSoapHeader();
        if (header == null) {
            return securityType;
        }
        Iterator iter = header.examineAllHeaderElements();
        while (iter.hasNext()) {
            Element usernameTokenElem;
            Element securityElem;
            SoapHeaderElement headerElement = (SoapHeaderElement)iter.next();
            Source source = headerElement.getSource();
            Document doc = this.docBuilderFactory.newDocumentBuilder().newDocument();
            DOMResult domResult = new DOMResult(doc);
            this.transformerFactory.newTransformer().transform(source, domResult);
            NodeList nodeList = doc.getElementsByTagNameNS(WSSE_NS, WSSE_SECURITY_ELEMENT);
            if (nodeList == null || nodeList.getLength() != 1 || (nodeList = (securityElem = (Element)nodeList.item(0)).getElementsByTagNameNS(WSSE_NS, WSSE_USERNAMETOKEN_ELEMENT)) == null || nodeList.getLength() != 1 || (nodeList = (usernameTokenElem = (Element)nodeList.item(0)).getElementsByTagNameNS(WSSE_NS, WSSE_PASSWORD_ELEMENT)) == null || nodeList.getLength() != 1) continue;
            Element passwordElem = (Element)nodeList.item(0);
            String passwordTypeAttr = passwordElem.getAttribute(WSSE_PASSWORD_TYPE_ATTR);
            if (passwordTypeAttr != null && passwordTypeAttr.equals(WSSE_PASSWORD_DIGEST_TYPE)) {
                securityType = 2;
                break;
            }
            securityType = 1;
            break;
        }
        return securityType;
    }

    public void afterCompletion(MessageContext messageContext, Object endpoint, Exception exception) throws Exception {
    }
}

