/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.impl.httpclient4;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.mime.Header;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.AxisRequestEntity;
import org.apache.axis2.transport.http.HTTPAuthenticator;
import org.apache.axis2.transport.http.Request;
import org.apache.axis2.transport.http.impl.httpclient4.AxisRequestEntityImpl;
import org.apache.axis2.transport.http.impl.httpclient4.HTTPProxyConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.params.AuthPolicy;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

final class RequestImpl
implements Request {
    private static final String[] COOKIE_HEADER_NAMES = new String[]{"Set-Cookie", "Set-Cookie2"};
    private static final Log log = LogFactory.getLog(RequestImpl.class);
    private final HttpClient httpClient;
    private final MessageContext msgContext;
    private final URL url;
    private final HttpRequestBase method;
    private final HttpHost httpHost;
    private final RequestConfig.Builder requestConfig = RequestConfig.custom();
    private final HttpClientContext clientContext = HttpClientContext.create();
    private HttpResponse response;

    RequestImpl(HttpClient httpClient, MessageContext msgContext, final String methodName, URL url, AxisRequestEntity requestEntity) throws AxisFault {
        this.httpClient = httpClient;
        this.msgContext = msgContext;
        this.url = url;
        if (requestEntity == null) {
            this.method = new HttpRequestBase(){

                public String getMethod() {
                    return methodName;
                }
            };
        } else {
            HttpEntityEnclosingRequestBase entityEnclosingRequest = new HttpEntityEnclosingRequestBase(){

                public String getMethod() {
                    return methodName;
                }
            };
            entityEnclosingRequest.setEntity((HttpEntity)new AxisRequestEntityImpl(requestEntity));
            this.method = entityEnclosingRequest;
        }
        try {
            this.method.setURI(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw AxisFault.makeFault((Throwable)ex);
        }
        int port = url.getPort();
        String protocol = url.getProtocol();
        if (port == -1) {
            if ("http".equals(protocol)) {
                port = 80;
            } else if ("https".equals(protocol)) {
                port = 443;
            }
        }
        this.httpHost = new HttpHost(url.getHost(), port, url.getProtocol());
    }

    @Override
    public void enableHTTP10() {
        this.method.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
    }

    @Override
    public void setHeader(String name, String value) {
        this.method.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.method.addHeader(name, value);
    }

    private static Header[] convertHeaders(org.apache.http.Header[] headers) {
        Header[] result = new Header[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            result[i] = new Header(headers[i].getName(), headers[i].getValue());
        }
        return result;
    }

    @Override
    public Header[] getRequestHeaders() {
        return RequestImpl.convertHeaders(this.method.getAllHeaders());
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.requestConfig.setConnectTimeout(timeout);
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.requestConfig.setSocketTimeout(timeout);
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    @Override
    public String getResponseHeader(String name) {
        org.apache.http.Header header = this.response.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    @Override
    public Header[] getResponseHeaders() {
        return RequestImpl.convertHeaders(this.response.getAllHeaders());
    }

    @Override
    public Map<String, String> getCookies() {
        HashMap<String, String> cookies = null;
        for (String name : COOKIE_HEADER_NAMES) {
            for (org.apache.http.Header header : this.response.getHeaders(name)) {
                for (HeaderElement element : header.getElements()) {
                    if (cookies == null) {
                        cookies = new HashMap<String, String>();
                    }
                    cookies.put(element.getName(), element.getValue());
                }
            }
        }
        return cookies;
    }

    @Override
    public InputStream getResponseContent() throws IOException {
        HttpEntity entity = this.response.getEntity();
        return entity == null ? null : entity.getContent();
    }

    @Override
    public void execute() throws IOException {
        String cookiePolicy;
        this.populateHostConfiguration();
        if (this.msgContext.isPropertyTrue("transport.http.acceptGzip")) {
            this.method.addHeader("Accept-Encoding", "gzip");
        }
        if ((cookiePolicy = (String)this.msgContext.getProperty("COOKIE_POLICY")) != null) {
            this.requestConfig.setCookieSpec(cookiePolicy);
        }
        this.method.setConfig(this.requestConfig.build());
        this.response = this.httpClient.execute(this.httpHost, (HttpRequest)this.method, (HttpContext)this.clientContext);
    }

    @Override
    public void releaseConnection() {
        log.trace((Object)("Cleaning response : " + this.response));
        HttpEntity entity = this.response.getEntity();
        if (entity != null) {
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException e) {
                log.error((Object)("Error while cleaning response : " + this.response), (Throwable)e);
            }
        }
    }

    private void populateHostConfiguration() throws AxisFault {
        if (HTTPProxyConfigurator.isProxyEnabled(this.msgContext, this.url)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Configuring HTTP proxy.");
            }
            HTTPProxyConfigurator.configure(this.msgContext, this.requestConfig, this.clientContext);
        }
    }

    @Override
    public void enableAuthentication(HTTPAuthenticator authenticator) {
        this.requestConfig.setAuthenticationEnabled(true);
        String username = authenticator.getUsername();
        String password = authenticator.getPassword();
        String host = authenticator.getHost();
        String domain = authenticator.getDomain();
        int port = authenticator.getPort();
        String realm = authenticator.getRealm();
        CredentialsProvider credsProvider = this.clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            credsProvider = new BasicCredentialsProvider();
            this.clientContext.setCredentialsProvider(credsProvider);
        }
        if (host != null) {
            creds = domain != null ? new NTCredentials(username, password, host, domain) : new UsernamePasswordCredentials(username, password);
            credsProvider.setCredentials(new AuthScope(host, port, realm), (Credentials)creds);
        } else if (domain != null) {
            creds = new NTCredentials(username, password, AuthScope.ANY_HOST, domain);
            credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, port, realm), (Credentials)creds);
        } else {
            creds = new UsernamePasswordCredentials(username, password);
            credsProvider.setCredentials(new AuthScope(AuthScope.ANY), (Credentials)creds);
        }
        List schemes = authenticator.getAuthSchemes();
        if (schemes != null && schemes.size() > 0) {
            ArrayList<Object> authPrefs = new ArrayList<Object>(3);
            for (int i = 0; i < schemes.size(); ++i) {
                if (schemes.get(i) instanceof AuthPolicy) {
                    authPrefs.add(schemes.get(i));
                    continue;
                }
                String scheme = (String)schemes.get(i);
                authPrefs.add(authenticator.getAuthPolicyPref(scheme));
            }
            this.requestConfig.setTargetPreferredAuthSchemes(authPrefs);
        }
    }
}

