/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.WarBasedAxisConfigurator;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.kernel.RequestResponseTransport;
import org.apache.axis2.kernel.TransportListener;
import org.apache.axis2.kernel.TransportUtils;
import org.apache.axis2.kernel.http.HTTPConstants;
import org.apache.axis2.kernel.http.util.QueryStringParser;
import org.apache.axis2.transport.http.AxisServletListener;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.transport.http.TransportHeaders;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.OnDemandLogger;

public class AxisServlet
extends HttpServlet {
    private static final long serialVersionUID = 3105135058353738906L;
    static final OnDemandLogger log = new OnDemandLogger(AxisServlet.class);
    public static final String CONFIGURATION_CONTEXT = "CONFIGURATION_CONTEXT";
    public static final String SESSION_ID = "SessionId";
    private static final Set<String> metadataQueryParamNames;
    protected transient ConfigurationContext configContext;
    protected transient AxisConfiguration axisConfiguration;
    protected transient ServletConfig servletConfig;
    protected transient ListingAgent agent;
    protected transient String contextRoot = null;
    protected boolean disableREST = false;
    private static final String LIST_SERVICES_SUFFIX = "/services/listServices";
    private static final String LIST_FAULTY_SERVICES_SUFFIX = "/services/ListFaultyServices";
    private boolean closeReader = true;
    private static final int BUFFER_SIZE = 8192;
    private boolean initCalled = false;
    private transient AxisServletListener httpListener;
    private transient AxisServletListener httpsListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setBufferSize(8192);
        this.preprocessRequest(request);
        ServletOutputStream out = response.getOutputStream();
        String contentType = request.getContentType();
        if (!HTTPTransportUtils.isRESTRequest(contentType)) {
            MessageContext msgContext = this.createMessageContext(request, response);
            msgContext.setProperty("ContentType", (Object)contentType);
            try {
                String url = request.getRequestURL().toString();
                BufferedOutputStream bufferedOut = new BufferedOutputStream((OutputStream)out);
                Handler.InvocationResponse pi = HTTPTransportUtils.processHTTPPostRequest(msgContext, new BufferedInputStream((InputStream)request.getInputStream()), bufferedOut, contentType, request.getHeader("SOAPAction"), url);
                Boolean holdResponse = (Boolean)msgContext.getProperty("HoldResponse");
                if (pi.equals((Object)Handler.InvocationResponse.SUSPEND) || holdResponse != null && Boolean.TRUE.equals(holdResponse)) {
                    ((RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl")).awaitResponse();
                }
                if (!TransportUtils.isResponseWritten((MessageContext)msgContext) && ((RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl")).getStatus() != RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED) {
                    response.setStatus(202);
                    log.debug((Object)("Response not written. Setting response contentType to text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING")));
                    response.setContentType("text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING"));
                }
                ((OutputStream)bufferedOut).flush();
            }
            catch (AxisFault e) {
                this.setResponseState(msgContext, response);
                log.debug((Object)e);
                if (msgContext != null) {
                    this.processAxisFault(msgContext, response, (OutputStream)out, e);
                }
                throw new ServletException((Throwable)e);
            }
            catch (Throwable t) {
                log.error((Object)t.getMessage(), t);
                try {
                    if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                        response.setStatus(202);
                    } else {
                        Integer code;
                        AxisBindingMessage axisBindingMessage;
                        response.setStatus(500);
                        AxisBindingOperation axisBindingOperation = (AxisBindingOperation)msgContext.getProperty("AxisBindingOperation");
                        if (axisBindingOperation != null && (axisBindingMessage = axisBindingOperation.getFault((String)msgContext.getProperty("faultName"))) != null && (code = (Integer)axisBindingMessage.getProperty("whttp:code")) != null) {
                            response.setStatus(code.intValue());
                        }
                    }
                    this.handleFault(msgContext, (OutputStream)out, new AxisFault(t.toString(), t));
                }
                catch (AxisFault e2) {
                    log.info((Object)e2);
                    throw new ServletException((Throwable)e2);
                }
            }
            finally {
                this.closeStaxBuilder(msgContext);
                TransportUtils.deleteAttachments((MessageContext)msgContext);
            }
        } else if (!this.disableREST) {
            new RestRequestProcessor("POST", request, response).processXMLRequest();
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.preprocessRequest(request);
        String requestURI = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null && new QueryStringParser(query).search(metadataQueryParamNames)) {
            this.agent.processListService(request, response);
        } else if (HttpUtils.endsWithIgnoreCase(requestURI, ".xsd") || HttpUtils.endsWithIgnoreCase(requestURI, ".wsdl")) {
            this.agent.processExplicitSchemaAndWSDL(request, response);
        } else if (requestURI.endsWith(LIST_SERVICES_SUFFIX) || requestURI.endsWith(LIST_FAULTY_SERVICES_SUFFIX)) {
            try {
                this.agent.handle(request, response);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else if (!this.disableREST) {
            new RestRequestProcessor("GET", request, response).processURLRequest();
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.preprocessRequest(request);
        if (!this.disableREST) {
            new RestRequestProcessor("DELETE", request, response).processURLRequest();
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.preprocessRequest(request);
        if (!this.disableREST) {
            new RestRequestProcessor("PUT", request, response).processXMLRequest();
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }

    protected void showRestDisabledErrorMessage(HttpServletResponse response) throws IOException {
        PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());
        writer.println("<html><body><h2>Please enable REST support in WEB-INF/conf/axis2.xml and WEB-INF/web.xml</h2></body></html>");
        writer.flush();
        response.setStatus(202);
    }

    void closeStaxBuilder(MessageContext messageContext) throws ServletException {
        if (this.closeReader && messageContext != null) {
            try {
                OMXMLParserWrapper builder;
                SOAPEnvelope envelope = messageContext.getEnvelope();
                if (envelope != null && (builder = envelope.getBuilder()) != null) {
                    builder.close();
                }
            }
            catch (Exception e) {
                log.debug((Object)e.toString(), (Throwable)e);
            }
        }
    }

    void processAxisFault(MessageContext msgContext, HttpServletResponse res, OutputStream out, AxisFault e) {
        try {
            if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                res.setStatus(202);
            } else {
                Integer code;
                AxisBindingMessage fault;
                String status = (String)msgContext.getProperty("axis2.http.response.state");
                if (status != null) {
                    log.error((Object)("processAxisFault() found an HTTP status from the MessageContext instance, setting HttpServletResponse status to: " + status));
                    res.setStatus(Integer.parseInt(status));
                    return;
                }
                log.error((Object)"processAxisFault() found a null HTTP status from the MessageContext instance, setting HttpServletResponse status to: axis2.http.response.state");
                res.setStatus(500);
                AxisBindingOperation axisBindingOperation = (AxisBindingOperation)msgContext.getProperty("AxisBindingOperation");
                if (axisBindingOperation != null && (fault = axisBindingOperation.getFault((String)msgContext.getProperty("faultName"))) != null && (code = (Integer)fault.getProperty("whttp:code")) != null) {
                    res.setStatus(code.intValue());
                }
            }
            this.handleFault(msgContext, out, e);
        }
        catch (AxisFault e2) {
            log.info((Object)e2);
        }
    }

    protected void handleFault(MessageContext msgContext, OutputStream out, AxisFault e) throws AxisFault {
        msgContext.setProperty("TRANSPORT_OUT", (Object)out);
        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
        HttpServletResponse response = (HttpServletResponse)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        if (response != null) {
            SOAPFaultCode code = faultContext.getEnvelope().getBody().getFault().getCode();
            OMElement valueElement = null;
            if (code != null) {
                valueElement = code.getFirstChildWithName(new QName("http://www.w3.org/2003/05/soap-envelope", "Value"));
            }
            if (valueElement != null && "Sender".equals(valueElement.getTextAsQName().getLocalPart()) && !msgContext.isDoingREST()) {
                response.setStatus(400);
            }
        }
        AxisEngine.sendFault((MessageContext)faultContext);
    }

    public void init(ServletConfig config) throws ServletException {
        this.initCalled = true;
        super.init(config);
        try {
            this.servletConfig = config;
            ServletContext servletContext = this.servletConfig.getServletContext();
            this.configContext = (ConfigurationContext)servletContext.getAttribute(CONFIGURATION_CONTEXT);
            if (this.configContext == null) {
                this.configContext = this.initConfigContext(config);
                config.getServletContext().setAttribute(CONFIGURATION_CONTEXT, (Object)this.configContext);
            }
            this.axisConfiguration = this.configContext.getAxisConfiguration();
            this.initTransports();
            this.initGetRequestProcessors(config);
            this.initParams();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void initGetRequestProcessors(ServletConfig config) {
        this.agent = new ListingAgent(this.configContext);
    }

    protected void initTransports() throws AxisFault {
        this.httpListener = this.getAxisServletListener("http");
        this.httpsListener = this.getAxisServletListener("https");
        if (this.httpListener == null && this.httpsListener == null) {
            log.warn((Object)("No transportReceiver for " + AxisServletListener.class.getName() + " found. An instance for HTTP will be configured automatically. Please update your axis2.xml file!"));
            this.httpListener = new AxisServletListener();
            TransportInDescription transportInDescription = new TransportInDescription("http");
            transportInDescription.setReceiver((TransportListener)this.httpListener);
            this.axisConfiguration.addTransportIn(transportInDescription);
        } else if (this.httpListener != null && this.httpsListener != null && this.httpListener.getPort() == -1 && this.httpsListener.getPort() == -1) {
            log.warn((Object)("If more than one transportReceiver for " + AxisServletListener.class.getName() + " exists, then all instances must be configured with a port number. WSDL generation will be unreliable."));
        }
        if (this.configContext.getListenerManager() == null) {
            ListenerManager listenerManager = new ListenerManager();
            listenerManager.init(this.configContext);
            listenerManager.start();
        }
    }

    private AxisServletListener getAxisServletListener(String name) {
        TransportInDescription desc = this.axisConfiguration.getTransportIn(name);
        if (desc == null) {
            return null;
        }
        TransportListener receiver = desc.getReceiver();
        if (receiver instanceof AxisServletListener) {
            return (AxisServletListener)receiver;
        }
        return null;
    }

    public void destroy() {
        try {
            if (this.configContext != null) {
                this.configContext.terminate();
            }
        }
        catch (AxisFault axisFault) {
            log.info((Object)axisFault.getMessage());
        }
        try {
            super.destroy();
        }
        catch (Exception e) {
            log.info((Object)e.getMessage());
        }
        String clientVersion = this.getHTTPClientVersion();
        if (clientVersion == null || !"http.client.version.4x".equals(clientVersion)) {
            try {
                Class.forName("org.apache.commons.httpclient.MultiThreadedHttpConnectionManager").getMethod("shutdownAll", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to shut down MultiThreadedHttpConnectionManager", (Throwable)ex);
            }
        }
    }

    private String getHTTPClientVersion() {
        Object version = this.configContext.getProperty("http.client.version");
        if (version != null) {
            return String.valueOf(version);
        }
        return null;
    }

    protected void initParams() {
        Parameter parameter = this.axisConfiguration.getParameter("disableREST");
        if (parameter != null) {
            boolean bl = this.disableREST = !JavaUtils.isFalseExplicitly((Object)parameter.getValue());
        }
        if ((parameter = this.axisConfiguration.getParameter("axis2.close.reader")) != null) {
            this.closeReader = JavaUtils.isTrueExplicitly((Object)parameter.getValue());
        }
    }

    public void init() throws ServletException {
        if (this.servletConfig != null && !this.initCalled) {
            this.init(this.servletConfig);
        }
    }

    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        try {
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)new WarBasedAxisConfigurator(config));
            configContext.setProperty("ContainerManaged", (Object)"true");
            return configContext;
        }
        catch (Exception e) {
            log.info((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void initContextRoot(HttpServletRequest req) {
        if (this.contextRoot != null && this.contextRoot.trim().length() != 0) {
            return;
        }
        String contextPath = req.getContextPath();
        if (contextPath != null && contextPath.length() == 0) {
            contextPath = "/";
        }
        this.contextRoot = contextPath;
        this.configContext.setContextRoot(this.contextRoot);
    }

    private void preprocessRequest(HttpServletRequest req) throws ServletException {
        AxisServletListener listner;
        TransportInDescription transportInDescription;
        this.initContextRoot(req);
        TransportInDescription transportInDescription2 = transportInDescription = req.isSecure() ? this.axisConfiguration.getTransportIn("https") : this.axisConfiguration.getTransportIn("http");
        if (transportInDescription == null) {
            throw new ServletException(req.getScheme() + " is forbidden");
        }
        if (transportInDescription.getReceiver() instanceof AxisServletListener && (listner = (AxisServletListener)transportInDescription.getReceiver()).getPort() == -1) {
            listner.setPort(req.getServerPort());
        }
    }

    protected Map<String, String> getTransportHeaders(HttpServletRequest req) {
        return new TransportHeaders(req);
    }

    protected MessageContext createMessageContext(HttpServletRequest request, HttpServletResponse response, boolean invocationType) throws IOException {
        String query;
        MessageContext msgContext = this.configContext.createMessageContext();
        Object requestURI = request.getRequestURI();
        String trsPrefix = request.getRequestURL().toString();
        int sepindex = trsPrefix.indexOf(58);
        if (sepindex > -1) {
            trsPrefix = trsPrefix.substring(0, sepindex);
            msgContext.setIncomingTransportName(trsPrefix);
        } else {
            msgContext.setIncomingTransportName("http");
            trsPrefix = "http";
        }
        TransportInDescription transportIn = this.axisConfiguration.getTransportIn(msgContext.getIncomingTransportName());
        TransportOutDescription transportOut = this.axisConfiguration.getTransportOut(trsPrefix);
        if (transportOut == null) {
            transportOut = this.axisConfiguration.getTransportOut("http");
        }
        msgContext.setTransportIn(transportIn);
        msgContext.setTransportOut(transportOut);
        msgContext.setServerSide(true);
        if (!invocationType && (query = request.getQueryString()) != null) {
            requestURI = (String)requestURI + "?" + query;
        }
        msgContext.setTo(new EndpointReference((String)requestURI));
        msgContext.setFrom(new EndpointReference(request.getRemoteAddr()));
        msgContext.setProperty("REMOTE_ADDR", (Object)request.getRemoteAddr());
        msgContext.setProperty("OutTransportInfo", (Object)new ServletBasedOutTransportInfo(response));
        msgContext.setProperty("TRANSPORT_HEADERS", this.getTransportHeaders(request));
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, (Object)request);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, (Object)response);
        ServletContext context = this.getServletContext();
        if (context != null) {
            msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT, (Object)context);
        }
        msgContext.setProperty("RequestResponseTransportControl", (Object)new ServletRequestResponseTransport());
        return msgContext;
    }

    protected MessageContext createMessageContext(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        return this.createMessageContext(req, resp, true);
    }

    void setResponseState(MessageContext messageContext, HttpServletResponse response) {
        int stateInt;
        String state = (String)messageContext.getProperty("axis2.http.response.state");
        if (state != null && (stateInt = Integer.parseInt(state)) == 401) {
            String realm = (String)messageContext.getProperty("axis2.authentication.realm");
            response.addHeader("WWW-Authenticate", "basic realm=\"" + realm + "\"");
        }
    }

    static {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                String string1 = (String)o1;
                String string2 = (String)o2;
                return string1.compareToIgnoreCase(string2);
            }
        };
        metadataQueryParamNames = new TreeSet<String>(comparator);
        metadataQueryParamNames.add("wsdl2");
        metadataQueryParamNames.add("wsdl");
        metadataQueryParamNames.add("xsd");
        metadataQueryParamNames.add("policy");
    }

    protected class RestRequestProcessor {
        protected MessageContext messageContext;
        private HttpServletRequest request;
        private HttpServletResponse response;

        public RestRequestProcessor(String httpMethodString, HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.request = request;
            this.response = response;
            this.messageContext = AxisServlet.this.createMessageContext(this.request, this.response, false);
            this.messageContext.setProperty("HTTP_METHOD_OBJECT", (Object)httpMethodString);
        }

        public void processXMLRequest() throws IOException, ServletException {
            try {
                RESTUtil.processXMLRequest(this.messageContext, (InputStream)this.request.getInputStream(), (OutputStream)this.response.getOutputStream(), this.request.getContentType());
                this.checkResponseWritten();
            }
            catch (AxisFault axisFault) {
                this.processFault(axisFault);
            }
            AxisServlet.this.closeStaxBuilder(this.messageContext);
        }

        public void processURLRequest() throws IOException, ServletException {
            try {
                RESTUtil.processURLRequest(this.messageContext, (OutputStream)this.response.getOutputStream(), this.request.getContentType());
                this.checkResponseWritten();
            }
            catch (AxisFault e) {
                AxisServlet.this.setResponseState(this.messageContext, this.response);
                this.processFault(e);
            }
            AxisServlet.this.closeStaxBuilder(this.messageContext);
        }

        private void checkResponseWritten() {
            if (!TransportUtils.isResponseWritten((MessageContext)this.messageContext)) {
                this.response.setStatus(202);
            }
        }

        private void processFault(AxisFault e) throws ServletException, IOException {
            log.debug((Object)e);
            if (this.messageContext == null) {
                throw new ServletException((Throwable)e);
            }
            AxisServlet.this.processAxisFault(this.messageContext, this.response, (OutputStream)this.response.getOutputStream(), e);
        }
    }

    protected class ServletRequestResponseTransport
    implements RequestResponseTransport {
        private boolean responseWritten = false;
        private CountDownLatch responseReadySignal = new CountDownLatch(1);
        private RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
        AxisFault faultToBeThrownOut = null;

        protected ServletRequestResponseTransport() {
        }

        public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            this.responseReadySignal.countDown();
        }

        public void awaitResponse() throws InterruptedException, AxisFault {
            log.debug((Object)"Blocking servlet thread -- awaiting response");
            this.responseReadySignal.await();
            if (this.faultToBeThrownOut != null) {
                throw this.faultToBeThrownOut;
            }
        }

        public void signalResponseReady() {
            log.debug((Object)"Signalling response available");
            this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
            this.responseReadySignal.countDown();
        }

        public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
            return this.status;
        }

        public void signalFaultReady(AxisFault fault) {
            this.faultToBeThrownOut = fault;
            this.signalResponseReady();
        }

        public boolean isResponseWritten() {
            return this.responseWritten;
        }

        public void setResponseWritten(boolean responseWritten) {
            this.responseWritten = responseWritten;
        }
    }
}

