/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.rest;

import MITI.sf.client.axis.gen.DeleteTemporaryDirectoryRequest;
import MITI.sf.client.axis.gen.DeleteTemporaryDirectoryResponse;
import MITI.sf.client.axis.gen.DeleteTemporaryFileRequest;
import MITI.sf.client.axis.gen.DeleteTemporaryFileResponse;
import MITI.sf.client.axis.gen.DownloadTemporaryFileRequest;
import MITI.sf.client.axis.gen.DownloadTemporaryFileResponse;
import MITI.sf.client.axis.gen.FileAccess;
import MITI.sf.client.axis.gen.FileItemType;
import MITI.sf.client.axis.gen.FileItemTypeDirectoryContent;
import MITI.sf.client.axis.gen.GenerateTemporaryDirectoryRequest;
import MITI.sf.client.axis.gen.GenerateTemporaryDirectoryResponse;
import MITI.sf.client.axis.gen.GenerateTemporaryFileRequest;
import MITI.sf.client.axis.gen.GenerateTemporaryFileResponse;
import MITI.sf.client.axis.gen.ListTemporaryFilesRequest;
import MITI.sf.client.axis.gen.ListTemporaryFilesResponse;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.OEMLicenseToken;
import MITI.sf.client.axis.gen.UploadTemporaryFileRequest;
import MITI.sf.client.axis.gen.UploadTemporaryFileResponse;
import MITI.sf.client.rest.Service;
import MITI.util.XmlUtil;
import MITI.util.rest.RestUtil;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class FileAccessRest
extends Service
implements FileAccess {
    public FileAccessRest(URL uRL) {
        super(uRL);
    }

    private static String createRequestXml(GenerateTemporaryFileRequest generateTemporaryFileRequest) {
        StringBuffer stringBuffer = FileAccessRest.createXml();
        stringBuffer.append("<GenerateTemporaryFileRequest");
        if (generateTemporaryFileRequest.getFileNameSuffix() != null) {
            stringBuffer.append(" fileNameSuffix=\"" + FileAccessRest.escapeXml(generateTemporaryFileRequest.getFileNameSuffix()) + "\"");
        }
        if (generateTemporaryFileRequest.getParentDirectoryHandle() != null) {
            stringBuffer.append(" parentDirectoryHandle=\"" + FileAccessRest.escapeXml(generateTemporaryFileRequest.getParentDirectoryHandle()) + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseGenerateTemporaryFileResponse(Element element, GenerateTemporaryFileResponse generateTemporaryFileResponse) {
        generateTemporaryFileResponse.setFileHandle(element.getAttribute("fileHandle"));
        generateTemporaryFileResponse.setFilePath(element.getAttribute("filePath"));
    }

    @Override
    public GenerateTemporaryFileResponse generateTemporaryFile(GenerateTemporaryFileRequest generateTemporaryFileRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(generateTemporaryFileRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "GenerateTemporaryFileResponse")) {
            GenerateTemporaryFileResponse generateTemporaryFileResponse = new GenerateTemporaryFileResponse();
            FileAccessRest.parseGenerateTemporaryFileResponse(element, generateTemporaryFileResponse);
            return generateTemporaryFileResponse;
        }
        return null;
    }

    private static String createRequestXml(GenerateTemporaryDirectoryRequest generateTemporaryDirectoryRequest) {
        StringBuffer stringBuffer = FileAccessRest.createXml();
        stringBuffer.append("<GenerateTemporaryDirectoryRequest");
        if (generateTemporaryDirectoryRequest.getDirectoryName() != null) {
            stringBuffer.append(" directoryName=\"" + FileAccessRest.escapeXml(generateTemporaryDirectoryRequest.getDirectoryName()) + "\"");
        }
        if (generateTemporaryDirectoryRequest.getParentDirectoryHandle() != null) {
            stringBuffer.append(" parentDirectoryHandle=\"" + FileAccessRest.escapeXml(generateTemporaryDirectoryRequest.getParentDirectoryHandle()) + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseGenerateTemporaryDirectoryResponse(Element element, GenerateTemporaryDirectoryResponse generateTemporaryDirectoryResponse) {
        generateTemporaryDirectoryResponse.setFileHandle(element.getAttribute("fileHandle"));
        generateTemporaryDirectoryResponse.setFilePath(element.getAttribute("filePath"));
    }

    @Override
    public GenerateTemporaryDirectoryResponse generateTemporaryDirectory(GenerateTemporaryDirectoryRequest generateTemporaryDirectoryRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(generateTemporaryDirectoryRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "GenerateTemporaryDirectoryResponse")) {
            GenerateTemporaryDirectoryResponse generateTemporaryDirectoryResponse = new GenerateTemporaryDirectoryResponse();
            FileAccessRest.parseGenerateTemporaryDirectoryResponse(element, generateTemporaryDirectoryResponse);
            return generateTemporaryDirectoryResponse;
        }
        return null;
    }

    private static String createRequestXml(DeleteTemporaryFileRequest deleteTemporaryFileRequest) {
        StringBuffer stringBuffer = FileAccessRest.createXml();
        stringBuffer.append("<DeleteTemporaryFileRequest");
        stringBuffer.append(" fileHandle=\"" + FileAccessRest.escapeXml(deleteTemporaryFileRequest.getFileHandle()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseDeleteTemporaryFileResponse(Element element, DeleteTemporaryFileResponse deleteTemporaryFileResponse) {
    }

    @Override
    public DeleteTemporaryFileResponse deleteTemporaryFile(DeleteTemporaryFileRequest deleteTemporaryFileRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(deleteTemporaryFileRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "DeleteTemporaryFileResponse")) {
            DeleteTemporaryFileResponse deleteTemporaryFileResponse = new DeleteTemporaryFileResponse();
            FileAccessRest.parseDeleteTemporaryFileResponse(element, deleteTemporaryFileResponse);
            return deleteTemporaryFileResponse;
        }
        return null;
    }

    private static String createRequestXml(DeleteTemporaryDirectoryRequest deleteTemporaryDirectoryRequest) {
        StringBuffer stringBuffer = FileAccessRest.createXml();
        stringBuffer.append("<DeleteTemporaryDirectoryRequest");
        stringBuffer.append(" fileHandle=\"" + FileAccessRest.escapeXml(deleteTemporaryDirectoryRequest.getFileHandle()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseDeleteTemporaryDirectoryResponse(Element element, DeleteTemporaryDirectoryResponse deleteTemporaryDirectoryResponse) {
    }

    @Override
    public DeleteTemporaryDirectoryResponse deleteTemporaryDirectory(DeleteTemporaryDirectoryRequest deleteTemporaryDirectoryRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(deleteTemporaryDirectoryRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "DeleteTemporaryDirectoryResponse")) {
            DeleteTemporaryDirectoryResponse deleteTemporaryDirectoryResponse = new DeleteTemporaryDirectoryResponse();
            FileAccessRest.parseDeleteTemporaryDirectoryResponse(element, deleteTemporaryDirectoryResponse);
            return deleteTemporaryDirectoryResponse;
        }
        return null;
    }

    private static String createRequestXml(DownloadTemporaryFileRequest downloadTemporaryFileRequest) {
        StringBuffer stringBuffer = FileAccessRest.createXml();
        stringBuffer.append("<DownloadTemporaryFileRequest");
        stringBuffer.append(" fileHandle=\"" + FileAccessRest.escapeXml(downloadTemporaryFileRequest.getFileHandle()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\">");
        stringBuffer.append("</UploadTemporaryFileRequest>");
        return stringBuffer.toString();
    }

    @Override
    public DownloadTemporaryFileResponse downloadTemporaryFile(DownloadTemporaryFileRequest downloadTemporaryFileRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(downloadTemporaryFileRequest);
        this.callXml(downloadTemporaryFileRequest.getFile(), string, oEMLicenseToken, new RestUtil.Parameter[0]);
        DownloadTemporaryFileResponse downloadTemporaryFileResponse = new DownloadTemporaryFileResponse();
        return downloadTemporaryFileResponse;
    }

    private static String createRequestXml(UploadTemporaryFileRequest uploadTemporaryFileRequest, boolean bl) {
        StringBuffer stringBuffer = FileAccessRest.createXml();
        stringBuffer.append("<UploadTemporaryFileRequest");
        stringBuffer.append(" fileHandle=\"" + FileAccessRest.escapeXml(uploadTemporaryFileRequest.getFileHandle()) + "\"");
        if (uploadTemporaryFileRequest.getFileLastModificationTime() != null) {
            stringBuffer.append(" fileLastModificationTime=\"" + uploadTemporaryFileRequest.getFileLastModificationTime() + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\">");
        if (bl) {
            // empty if block
        }
        stringBuffer.append("</UploadTemporaryFileRequest>");
        return stringBuffer.toString();
    }

    private static void parseUploadTemporaryFileResponse(Element element, UploadTemporaryFileResponse uploadTemporaryFileResponse) {
    }

    @Override
    public UploadTemporaryFileResponse uploadTemporaryFile(UploadTemporaryFileRequest uploadTemporaryFileRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(uploadTemporaryFileRequest, false);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.FileParameter("File", uploadTemporaryFileRequest.getFile(), null, "application/octet-stream"));
        if (XmlUtil.isElementNode(element, null, "UploadTemporaryFileResponse")) {
            UploadTemporaryFileResponse uploadTemporaryFileResponse = new UploadTemporaryFileResponse();
            FileAccessRest.parseUploadTemporaryFileResponse(element, uploadTemporaryFileResponse);
            return uploadTemporaryFileResponse;
        }
        return null;
    }

    private static String createRequestXml(ListTemporaryFilesRequest listTemporaryFilesRequest) {
        StringBuffer stringBuffer = FileAccessRest.createXml();
        stringBuffer.append("<ListTemporaryFilesRequest");
        stringBuffer.append(" fileHandle=\"" + FileAccessRest.escapeXml(listTemporaryFilesRequest.getFileHandle()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static FileItemType[] parseFileItems(List<Element> list) {
        ArrayList<FileItemType> arrayList = new ArrayList<FileItemType>();
        for (Element element : list) {
            FileItemType fileItemType = FileAccessRest.parseFileItem(element);
            arrayList.add(fileItemType);
        }
        return arrayList.toArray(new FileItemType[arrayList.size()]);
    }

    private static FileItemType parseFileItem(Element element) {
        FileItemType fileItemType = new FileItemType();
        fileItemType.setFileHandle(element.getAttribute("fileHandle"));
        fileItemType.setFilePath(element.getAttribute("filePath"));
        fileItemType.setIsDirectory(Boolean.valueOf(element.getAttribute("isDirectory")));
        fileItemType.setName(element.getAttribute("name"));
        fileItemType.setLength(element.getAttribute("fileSize"));
        fileItemType.setChecksum(element.getAttribute("fileChecksum"));
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, null, "DirectoryContent");
        for (Element element2 : arrayList) {
            FileItemTypeDirectoryContent fileItemTypeDirectoryContent = new FileItemTypeDirectoryContent();
            ArrayList<Element> arrayList2 = XmlUtil.getChildElements(element2, null, "FileItem");
            fileItemTypeDirectoryContent.setFileItem(FileAccessRest.parseFileItems(arrayList2));
            fileItemType.setDirectoryContent(fileItemTypeDirectoryContent);
        }
        return fileItemType;
    }

    private static void parseListTemporaryFilesResponse(Element element, ListTemporaryFilesResponse listTemporaryFilesResponse) {
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, null, "FileItem");
        listTemporaryFilesResponse.setFileItem(FileAccessRest.parseFileItems(arrayList));
    }

    @Override
    public ListTemporaryFilesResponse listTemporaryFiles(ListTemporaryFilesRequest listTemporaryFilesRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(listTemporaryFilesRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "ListTemporaryFilesResponse")) {
            ListTemporaryFilesResponse listTemporaryFilesResponse = new ListTemporaryFilesResponse();
            FileAccessRest.parseListTemporaryFilesResponse(element, listTemporaryFilesResponse);
            return listTemporaryFilesResponse;
        }
        return null;
    }
}

