/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.messages.MimbAxis.SFCL;
import MITI.sf.client.axis.AbstractMimbClient;
import MITI.sf.client.axis.MimbUtil;
import MITI.sf.client.axis.gen.BridgeParameterType;
import MITI.sf.client.axis.gen.DeleteTemporaryDirectoryRequest;
import MITI.sf.client.axis.gen.DeleteTemporaryFileRequest;
import MITI.sf.client.axis.gen.OEMLicenseToken;
import MITI.sf.client.axis.gen.OpenModeType;
import MITI.sf.client.axis.gen.TypeType;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;

public class RemoteFileProcessor {
    private OpenModeType openMode;
    private String handle = null;
    private TypeType parameterType;
    private BridgeParameterType parameter;
    private boolean compress = false;

    public RemoteFileProcessor(OpenModeType openModeType, TypeType typeType, BridgeParameterType bridgeParameterType, boolean bl) {
        this.openMode = openModeType;
        this.parameterType = typeType;
        this.parameter = bridgeParameterType;
        this.compress = bl;
    }

    public void preprocess(AbstractMimbClient abstractMimbClient) throws RemoteException, IOException {
        if (OpenModeType.DEFAULT.equals((Object)this.openMode)) {
            throw new IllegalStateException("Default mode must not be used in this context.");
        }
        String string = this.parameter.getClientSpecifiedText();
        if (string == null || string.length() == 0) {
            string = this.parameter.get_value();
        }
        if (OpenModeType.READ.equals((Object)this.openMode) || OpenModeType.READWRITE.equals((Object)this.openMode) && new File(string).exists()) {
            if (TypeType.FILE.equals((Object)this.parameterType)) {
                SFCL.UPLOADING_FILE.log(string);
                this.handle = MimbUtil.uploadFile(abstractMimbClient, this.parameter, this.compress);
            } else if (TypeType.DIRECTORY.equals((Object)this.parameterType)) {
                SFCL.UPLOADING_DIRECTORY.log(string);
                this.handle = MimbUtil.uploadDirectory(abstractMimbClient, this.parameter, this.compress);
            } else {
                throw new IllegalStateException("Unexpected option type: " + (Object)((Object)this.parameterType));
            }
            SFCL.UPLOADING_COMPLETED.log(new Object[0]);
        } else if (TypeType.FILE.equals((Object)this.parameterType)) {
            this.handle = MimbUtil.createTempFile(abstractMimbClient, this.parameter);
        } else if (TypeType.DIRECTORY.equals((Object)this.parameterType)) {
            this.handle = MimbUtil.createTempDir(abstractMimbClient, this.parameter);
        } else {
            throw new IllegalStateException("Unexpected option type: " + (Object)((Object)this.parameterType));
        }
    }

    public void postprocess(AbstractMimbClient abstractMimbClient, boolean bl, OEMLicenseToken oEMLicenseToken) throws IOException {
        block18: {
            if (OpenModeType.DEFAULT.equals((Object)this.openMode)) {
                throw new IllegalStateException("Default mode must not be used in this context.");
            }
            String string = this.parameter.getClientSpecifiedText();
            if (string == null || string.length() == 0) {
                string = this.parameter.get_value();
            }
            if (OpenModeType.WRITE.equals((Object)this.openMode) || OpenModeType.READWRITE.equals((Object)this.openMode)) {
                if (TypeType.FILE.equals((Object)this.parameterType)) {
                    SFCL.DOWNLOADING_FILE.log(string);
                    try {
                        MimbUtil.downloadFile(abstractMimbClient, this.parameter.getClientSpecifiedText(), this.handle, this.compress);
                        SFCL.DOWNLOADING_COMPLETED.log(new Object[0]);
                    }
                    catch (RemoteException remoteException) {
                        if (bl) {
                            throw remoteException;
                        }
                        SFCL.DOWNLOADING_FAILED.log(remoteException.getMessage());
                    }
                } else if (TypeType.DIRECTORY.equals((Object)this.parameterType)) {
                    SFCL.DOWNLOADING_DIRECTORY.log(string);
                    try {
                        MimbUtil.downloadDirectory(abstractMimbClient, this.parameter.getClientSpecifiedText(), this.handle, this.compress);
                        SFCL.DOWNLOADING_COMPLETED.log(new Object[0]);
                    }
                    catch (RemoteException remoteException) {
                        if (bl) {
                            throw remoteException;
                        }
                        SFCL.DOWNLOADING_FAILED.log(remoteException.getMessage());
                    }
                } else {
                    throw new IllegalStateException("Unexpected option type: " + (Object)((Object)this.parameterType));
                }
            }
            try {
                SFCL.MSG_DELETING_REMOTE_FILE.log(this.handle);
                if (TypeType.FILE.equals((Object)this.parameterType)) {
                    abstractMimbClient.getFileaccess().deleteTemporaryFile(new DeleteTemporaryFileRequest(this.handle), oEMLicenseToken);
                    break block18;
                }
                if (TypeType.DIRECTORY.equals((Object)this.parameterType)) {
                    abstractMimbClient.getFileaccess().deleteTemporaryDirectory(new DeleteTemporaryDirectoryRequest(this.handle), oEMLicenseToken);
                    break block18;
                }
                throw new IllegalStateException("Unexpected option type: " + (Object)((Object)this.parameterType));
            }
            catch (RemoteException remoteException) {
                if (bl) {
                    throw remoteException;
                }
                SFCL.DELETING_REMOTE_FILE_FAILED.log(remoteException.getMessage());
            }
        }
    }
}

