/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.sf.client.axis.AbstractMimbClient;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusRequest;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusResponse;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.OEMLicenseToken;
import MITI.sf.client.axis.gen.StopMimbExecutionRequest;
import java.rmi.RemoteException;

public abstract class Process<E> {
    protected AbstractMimbClient mimbClient;
    protected OEMLicenseToken oemLicenseToken;
    protected String mimbProcessId;
    protected boolean isMimbRunning;
    protected boolean mimbResult;

    protected Process(AbstractMimbClient abstractMimbClient, OEMLicenseToken oEMLicenseToken) {
        this.mimbClient = abstractMimbClient;
        this.oemLicenseToken = oEMLicenseToken;
    }

    protected abstract E getResult();

    protected void start(String string) {
        this.mimbProcessId = string;
        this.isMimbRunning = true;
    }

    protected void check(Log log, int n) throws MimbAgentFault, RemoteException {
        if (this.isMimbRunning) {
            GetMimbExecutionStatusRequest getMimbExecutionStatusRequest = new GetMimbExecutionStatusRequest(this.mimbProcessId, 1000, n);
            GetMimbExecutionStatusResponse getMimbExecutionStatusResponse = this.mimbClient.getMimb().getMimbExecutionStatus(getMimbExecutionStatusRequest, this.oemLicenseToken);
            this.isMimbRunning = getMimbExecutionStatusResponse.isIsRunning() || getMimbExecutionStatusResponse.getLog().isHasMoreLines();
            this.mimbResult = getMimbExecutionStatusResponse.isIsSuccessful();
            log.printMimbLog(getMimbExecutionStatusResponse.getLog());
        }
    }

    protected boolean isRunning() {
        return this.isMimbRunning;
    }

    protected void stop() throws MimbAgentFault, RemoteException {
        if (this.isMimbRunning) {
            this.mimbClient.getMimb().stopMimbExecution(new StopMimbExecutionRequest(this.mimbProcessId));
            this.isMimbRunning = false;
        }
    }

    protected String getMimbProcessId() {
        return this.mimbProcessId;
    }
}

