/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.messages.MimbAxis.SFCL;
import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.MimbStatus;
import MITI.sf.client.mimb.InterruptibleEnvironment;
import MITI.sf.client.mimb.MimbDriver;

public class MimbProcessMonitor
extends Thread {
    private MimbDriver driver;
    private MITI.mimb.driver.MimbDriver internalDriver;
    private MimbSession session;
    private int refreshInterval;
    private int maxWaitTime;

    public MimbProcessMonitor(MimbDriver mimbDriver, MITI.mimb.driver.MimbDriver mimbDriver2, MimbSession mimbSession, int n, int n2) {
        this.driver = mimbDriver;
        this.internalDriver = mimbDriver2;
        this.session = mimbSession;
        this.refreshInterval = n;
        this.maxWaitTime = n2;
    }

    @Override
    public void run() {
        long l = System.currentTimeMillis();
        try {
            while (true) {
                Thread.sleep((long)this.refreshInterval * 1000L);
                MimbStatus mimbStatus = this.internalDriver.getStatus(this.session);
                if (mimbStatus == MimbStatus.INVALID) continue;
                if (mimbStatus == MimbStatus.RUNNING) {
                    InterruptibleEnvironment interruptibleEnvironment = this.driver.getEnvironment();
                    if (interruptibleEnvironment != null && interruptibleEnvironment.isAbortRequested()) {
                        SFCL.DBG_ABORT_REQUESTED.log(new Object[0]);
                        this.internalDriver.stop(this.session);
                    } else {
                        if (this.maxWaitTime <= 0 || System.currentTimeMillis() - l <= (long)this.maxWaitTime * 1000L) continue;
                        this.internalDriver.stop(this.session);
                    }
                    break;
                }
                if (mimbStatus == MimbStatus.ERROR || mimbStatus == MimbStatus.SUCCESS) break;
            }
        }
        catch (DriverError driverError) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

