/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.mimb.log.MimbLog;
import MITI.mimb.log.MimbLogEvent;
import MITI.mimb.log.MimbLogLevel;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.gen.LogType;
import MITI.sf.client.axis.gen.MessageLevel;
import MITI.sf.client.axis.gen.MessageType;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Queue;

public class MimbDriverLogAdapter
implements MimbLog {
    private Log log;
    private MimbLogLevel logLevel;
    private Queue<MessageType> messageQueue;

    public MimbDriverLogAdapter(Log log, int n) {
        this.log = log;
        this.logLevel = MimbLogLevel.get((int)n);
        this.messageQueue = new LinkedList<MessageType>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printEvent(MimbLogEvent mimbLogEvent) {
        MessageType messageType = new MessageType();
        messageType.setCode(mimbLogEvent.getCode());
        messageType.setThreadId(mimbLogEvent.getThreadId());
        MessageLevel messageLevel = MessageLevel.fromString(mimbLogEvent.getLevel().getName());
        messageType.setType(messageLevel);
        messageType.setStackTrace(mimbLogEvent.getStackTrace());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(mimbLogEvent.getTime());
        messageType.setTimestamp(gregorianCalendar);
        messageType.set_value(mimbLogEvent.getText());
        if (this.log != null) {
            LogType logType = new LogType();
            logType.setHasMoreLines(true);
            logType.setMessage(new MessageType[]{messageType});
            this.log.printMimbLog(logType);
        } else {
            Queue<MessageType> queue = this.messageQueue;
            synchronized (queue) {
                this.messageQueue.add(messageType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogType getLogEvents(int n) {
        LogType logType = new LogType();
        Queue<MessageType> queue = this.messageQueue;
        synchronized (queue) {
            int n2;
            int n3 = Math.min(n, this.messageQueue.size());
            MessageType[] messageTypeArray = new MessageType[n3];
            for (n2 = 0; n2 < n3; n2 += 1) {
                messageTypeArray[n2] = this.messageQueue.remove();
            }
            logType.setMessage(messageTypeArray);
            n2 = this.messageQueue.size() > 0 ? 1 : 0;
            logType.setHasMoreLines(n2 != 0);
        }
        return logType;
    }

    public MimbLogLevel getLevel() {
        return this.logLevel;
    }

    public int getLineCount() {
        return 100;
    }
}

