/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.axis;

import MITI.client.oem.OemTokenChallenge;
import MITI.messages.MimbAxis.SFCL;
import MITI.sf.client.axis.AbstractMimbClient;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.MimbClient;
import MITI.sf.client.axis.gen.BridgeParameterType;
import MITI.sf.client.axis.gen.BridgeRunConfigurationType;
import MITI.sf.client.axis.gen.DirectionType;
import MITI.sf.client.axis.gen.DownloadTemporaryFileRequest;
import MITI.sf.client.axis.gen.FileItemType;
import MITI.sf.client.axis.gen.GenerateTemporaryDirectoryRequest;
import MITI.sf.client.axis.gen.GenerateTemporaryDirectoryResponse;
import MITI.sf.client.axis.gen.GenerateTemporaryFileRequest;
import MITI.sf.client.axis.gen.GenerateTemporaryFileResponse;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusRequest;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusResponse;
import MITI.sf.client.axis.gen.GetOemLicenseTokenChallengeRequest;
import MITI.sf.client.axis.gen.GetOemLicenseTokenRequest;
import MITI.sf.client.axis.gen.ListTemporaryFilesRequest;
import MITI.sf.client.axis.gen.MimbErrorResponse;
import MITI.sf.client.axis.gen.OEMLicenseToken;
import MITI.sf.client.axis.gen.RunMimbType;
import MITI.sf.client.axis.gen.StartMimbRequest;
import MITI.sf.client.axis.gen.StartMimbResponse;
import MITI.sf.client.axis.gen.StartTestRequest;
import MITI.sf.client.axis.gen.StopMimbExecutionRequest;
import MITI.sf.client.axis.gen.TestType;
import MITI.sf.client.axis.gen.UploadTemporaryFileRequest;
import MITI.sf.client.axis.gen.ValidationLevelType;
import MITI.sf.client.rest.MimbRest;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;

public class MimbUtil {
    public static final int BUF_SIZE = 0xA00000;
    public static final int RESILIENCE_RETRY_COUNT = 3;
    public static final long RESILIENCE_RETRY_TIMEOUT = 30000L;

    public static OEMLicenseToken getOemLicenseToken(AbstractMimbClient abstractMimbClient, String string) throws RemoteException {
        String string2 = abstractMimbClient.getLicense().getOemLicenseTokenChallenge(new GetOemLicenseTokenChallengeRequest(string)).getChallenge();
        String string3 = OemTokenChallenge.generateOemTokenChallengeResponse(string, string2);
        String string4 = abstractMimbClient.getLicense().getOemLicenseToken(new GetOemLicenseTokenRequest(string, string3)).getTemporaryLicenseToken();
        OEMLicenseToken oEMLicenseToken = new OEMLicenseToken();
        oEMLicenseToken.setOemPartnerToken(string);
        oEMLicenseToken.setTemporaryLicenseToken(string4);
        abstractMimbClient.setOemLicenseToken(oEMLicenseToken);
        return oEMLicenseToken;
    }

    public static final GenerateTemporaryFileResponse createTempFile(AbstractMimbClient abstractMimbClient, String string, String string2) throws RemoteException {
        String string3 = new File(string2).getName();
        GenerateTemporaryFileResponse generateTemporaryFileResponse = abstractMimbClient.getFileaccess().generateTemporaryFile(new GenerateTemporaryFileRequest(string3, string), abstractMimbClient.getOemLicenseToken());
        return generateTemporaryFileResponse;
    }

    public static final String createTempFile(AbstractMimbClient abstractMimbClient, BridgeParameterType bridgeParameterType) throws RemoteException {
        GenerateTemporaryFileResponse generateTemporaryFileResponse = MimbUtil.createTempFile(abstractMimbClient, null, bridgeParameterType.get_value());
        bridgeParameterType.setClientSpecifiedText(bridgeParameterType.get_value());
        bridgeParameterType.set_value(generateTemporaryFileResponse.getFilePath());
        return generateTemporaryFileResponse.getFileHandle();
    }

    public static final String createTempDir(AbstractMimbClient abstractMimbClient, BridgeParameterType bridgeParameterType) throws RemoteException {
        GenerateTemporaryDirectoryResponse generateTemporaryDirectoryResponse = abstractMimbClient.getFileaccess().generateTemporaryDirectory(new GenerateTemporaryDirectoryRequest(null, new File(bridgeParameterType.get_value()).getName()), abstractMimbClient.getOemLicenseToken());
        bridgeParameterType.setClientSpecifiedText(bridgeParameterType.get_value());
        bridgeParameterType.set_value(generateTemporaryDirectoryResponse.getFilePath());
        return generateTemporaryDirectoryResponse.getFileHandle();
    }

    public static final void uploadFile(AbstractMimbClient abstractMimbClient, String string, String string2) throws RemoteException, IOException {
        MimbUtil.uploadFile(abstractMimbClient, string, string2, false);
    }

    public static final void uploadFile(AbstractMimbClient abstractMimbClient, String string, String string2, boolean bl) throws RemoteException, IOException {
        File file = new File(string);
        UploadTemporaryFileRequest uploadTemporaryFileRequest = new UploadTemporaryFileRequest();
        uploadTemporaryFileRequest.setFileHandle(string2);
        uploadTemporaryFileRequest.setFile(file);
        uploadTemporaryFileRequest.setFileLastModificationTime(file.lastModified());
        abstractMimbClient.getFileaccess().uploadTemporaryFile(uploadTemporaryFileRequest, abstractMimbClient.getOemLicenseToken());
    }

    public static final String uploadFile(AbstractMimbClient abstractMimbClient, BridgeParameterType bridgeParameterType) throws RemoteException, IOException {
        return MimbUtil.uploadFile(abstractMimbClient, bridgeParameterType, false);
    }

    public static final String uploadFile(AbstractMimbClient abstractMimbClient, BridgeParameterType bridgeParameterType, boolean bl) throws RemoteException, IOException {
        String string = MimbUtil.createTempFile(abstractMimbClient, bridgeParameterType);
        MimbUtil.uploadFile(abstractMimbClient, bridgeParameterType.getClientSpecifiedText(), string, bl);
        return string;
    }

    public static final String uploadDirectory(AbstractMimbClient abstractMimbClient, BridgeParameterType bridgeParameterType) throws RemoteException, IOException {
        return MimbUtil.uploadDirectory(abstractMimbClient, bridgeParameterType, false);
    }

    public static final String uploadDirectory(AbstractMimbClient abstractMimbClient, BridgeParameterType bridgeParameterType, boolean bl) throws RemoteException, IOException {
        String string = MimbUtil.createTempDir(abstractMimbClient, bridgeParameterType);
        File file = new File(bridgeParameterType.getClientSpecifiedText());
        if (!file.exists()) {
            throw new IOException(SFCL.SOURCE_PATH_DOESNT_EXIST.getMessage(file.getAbsolutePath()));
        }
        if (!file.isDirectory()) {
            throw new IOException(SFCL.SOURCE_PATH_ISNT_DIR.getMessage(file.getAbsolutePath()));
        }
        MimbUtil.uploadFiles(abstractMimbClient, file, string, bl);
        return string;
    }

    public static final void uploadFiles(AbstractMimbClient abstractMimbClient, File file, String string, boolean bl) throws RemoteException, IOException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            Object object;
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                object = abstractMimbClient.getFileaccess().generateTemporaryDirectory(new GenerateTemporaryDirectoryRequest(string, file2.getName()), abstractMimbClient.getOemLicenseToken());
                string2 = ((GenerateTemporaryDirectoryResponse)object).getFileHandle();
                MimbUtil.uploadFiles(abstractMimbClient, file2, string2, bl);
                continue;
            }
            object = MimbUtil.createTempFile(abstractMimbClient, string, file2.getName());
            string2 = ((GenerateTemporaryFileResponse)object).getFileHandle();
            MimbUtil.uploadFile(abstractMimbClient, file2.getAbsolutePath(), string2, bl);
        }
    }

    public static final void downloadFile(AbstractMimbClient abstractMimbClient, String string, String string2) throws RemoteException, IOException {
        MimbUtil.downloadFile(abstractMimbClient, string, string2, 0L, "", false);
    }

    public static final void downloadFile(AbstractMimbClient abstractMimbClient, String string, String string2, boolean bl) throws RemoteException, IOException {
        long l = 0L;
        String string3 = "";
        try {
            FileItemType[] fileItemTypeArray = abstractMimbClient.getFileaccess().listTemporaryFiles(new ListTemporaryFilesRequest(string2), abstractMimbClient.getOemLicenseToken()).getFileItem();
            if (fileItemTypeArray != null && fileItemTypeArray.length == 1) {
                l = fileItemTypeArray[0].getLength();
                string3 = fileItemTypeArray[0].getChecksum();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        MimbUtil.downloadFile(abstractMimbClient, string, string2, l, string3, bl);
    }

    private static final void downloadFile(AbstractMimbClient abstractMimbClient, String string, String string2, long l, String string3, boolean bl) throws RemoteException, IOException {
        File file = new File(string);
        abstractMimbClient.getFileaccess().downloadTemporaryFile(new DownloadTemporaryFileRequest(string2, file), abstractMimbClient.getOemLicenseToken());
    }

    public static final void downloadDirectory(AbstractMimbClient abstractMimbClient, String string, String string2) throws RemoteException, IOException {
        MimbUtil.downloadDirectory(abstractMimbClient, string, string2, false);
    }

    public static final void downloadDirectory(AbstractMimbClient abstractMimbClient, String string, String string2, boolean bl) throws RemoteException, IOException {
        FileItemType[] fileItemTypeArray = abstractMimbClient.getFileaccess().listTemporaryFiles(new ListTemporaryFilesRequest(string2), abstractMimbClient.getOemLicenseToken()).getFileItem();
        MimbUtil.downloadFiles(abstractMimbClient, new File(string), fileItemTypeArray, bl);
    }

    private static final void downloadFiles(AbstractMimbClient abstractMimbClient, File file, FileItemType[] fileItemTypeArray, boolean bl) throws RemoteException, IOException {
        if (fileItemTypeArray == null) {
            return;
        }
        for (int i = 0; i < fileItemTypeArray.length; ++i) {
            File file2;
            FileItemType fileItemType = fileItemTypeArray[i];
            String string = fileItemType.getName();
            String string2 = fileItemType.getFileHandle();
            boolean bl2 = fileItemType.isIsDirectory();
            if (bl2) {
                file2 = new File(file, string);
                file2.mkdirs();
                MimbUtil.downloadFiles(abstractMimbClient, file2, fileItemType.getDirectoryContent().getFileItem(), bl);
                continue;
            }
            file2 = new File(file, string);
            MimbUtil.downloadFile(abstractMimbClient, file2.getAbsolutePath(), string2, fileItemType.getLength(), fileItemType.getChecksum(), bl);
        }
    }

    private static final void initBridgeConfig(BridgeRunConfigurationType bridgeRunConfigurationType, String string, boolean bl, BridgeParameterType[] bridgeParameterTypeArray) {
        bridgeRunConfigurationType.setBridgeIdentifier(string);
        bridgeRunConfigurationType.setDisableLog(new Boolean(bl));
        bridgeRunConfigurationType.setBridgeParameter(bridgeParameterTypeArray);
    }

    @Deprecated
    public static final boolean executeMimb(MimbClient mimbClient, ValidationLevelType validationLevelType, String string, BridgeParameterType[] bridgeParameterTypeArray, String string2, BridgeParameterType[] bridgeParameterTypeArray2, Log log, int n, int n2, OEMLicenseToken oEMLicenseToken) throws MimbErrorResponse, RemoteException {
        StartMimbResponse startMimbResponse = MimbUtil.startMimb(mimbClient, validationLevelType, string, bridgeParameterTypeArray, string2, bridgeParameterTypeArray2, oEMLicenseToken);
        String string3 = startMimbResponse.getMimbProcessId();
        boolean bl = MimbUtil.waitForMimbProcessCompletion(mimbClient, string3, log, n, n2, oEMLicenseToken);
        return bl;
    }

    @Deprecated
    public static final boolean testMimb(MimbClient mimbClient, String string, DirectionType directionType, BridgeParameterType[] bridgeParameterTypeArray, Log log, int n, int n2, OEMLicenseToken oEMLicenseToken) throws MimbErrorResponse, RemoteException {
        StartMimbResponse startMimbResponse = MimbUtil.startTest(mimbClient, string, directionType, bridgeParameterTypeArray, oEMLicenseToken);
        String string2 = startMimbResponse.getMimbProcessId();
        boolean bl = MimbUtil.waitForMimbProcessCompletion(mimbClient, string2, log, n, n2, oEMLicenseToken);
        return bl;
    }

    @Deprecated
    public static final StartMimbResponse startMimb(MimbClient mimbClient, ValidationLevelType validationLevelType, String string, BridgeParameterType[] bridgeParameterTypeArray, String string2, BridgeParameterType[] bridgeParameterTypeArray2, OEMLicenseToken oEMLicenseToken) throws MimbErrorResponse, RemoteException {
        RunMimbType runMimbType = new RunMimbType();
        BridgeRunConfigurationType bridgeRunConfigurationType = new BridgeRunConfigurationType();
        BridgeRunConfigurationType bridgeRunConfigurationType2 = new BridgeRunConfigurationType();
        MimbUtil.initBridgeConfig(bridgeRunConfigurationType, string, false, bridgeParameterTypeArray);
        runMimbType.set_import(bridgeRunConfigurationType);
        MimbUtil.initBridgeConfig(bridgeRunConfigurationType2, string2, false, bridgeParameterTypeArray2);
        runMimbType.setExport(bridgeRunConfigurationType2);
        StartMimbResponse startMimbResponse = mimbClient.getMimb().startMimb(new StartMimbRequest(runMimbType, null), oEMLicenseToken);
        return startMimbResponse;
    }

    @Deprecated
    public static final StartMimbResponse startTest(MimbClient mimbClient, String string, DirectionType directionType, BridgeParameterType[] bridgeParameterTypeArray, OEMLicenseToken oEMLicenseToken) throws MimbErrorResponse, RemoteException {
        TestType testType = new TestType();
        testType.setBridgeIdentifier(string);
        testType.setDirection(directionType);
        testType.setBridgeParameter(bridgeParameterTypeArray);
        testType.setDisableLog(Boolean.FALSE);
        StartMimbResponse startMimbResponse = mimbClient.getMimb().startTest(new StartTestRequest(testType, null), oEMLicenseToken);
        return startMimbResponse;
    }

    @Deprecated
    public static final boolean waitForMimbProcessCompletion(MimbClient mimbClient, String string, Log log, int n, int n2, OEMLicenseToken oEMLicenseToken) throws MimbErrorResponse, RemoteException {
        boolean bl;
        block1: {
            bl = false;
            long l = System.currentTimeMillis();
            do {
                GetMimbExecutionStatusResponse getMimbExecutionStatusResponse = mimbClient.getMimb().getMimbExecutionStatus(new GetMimbExecutionStatusRequest(string, new Integer(1000), new Integer(n)), oEMLicenseToken);
                boolean bl2 = getMimbExecutionStatusResponse.isIsRunning();
                boolean bl3 = getMimbExecutionStatusResponse.getLog().isHasMoreLines();
                bl = getMimbExecutionStatusResponse.isIsSuccessful();
                log.printMimbLog(getMimbExecutionStatusResponse.getLog());
                if (!bl2 && !bl3) break block1;
            } while (n2 <= 0 || System.currentTimeMillis() - l <= (long)n2 * 1000L);
            mimbClient.getMimb().stopMimbExecution(new StopMimbExecutionRequest(string));
            return false;
        }
        return bl;
    }

    public static String generateRunMimbRequestXml(RunMimbType runMimbType) {
        StringBuffer stringBuffer = new StringBuffer();
        MimbRest.appendRunMimbRequest(stringBuffer, runMimbType);
        String string = stringBuffer.toString();
        return string;
    }
}

