/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.retrieval.dao.omr;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.search.client.ContentSearchObject;
import com.sas.svcs.content.search.client.IndexDataAttribute;
import com.sas.svcs.content.search.client.IndexDataType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OMRIndexDataSupportTemplate {
    private static final String TEMPLATE_PREFIX = "<Templates><";
    private static final String TEMPLATE_BASE_ASSOCIATIONS = "<Keywords/><ResponsibleParties/><Trees/><ExternalIdentities/>";
    private static final String TEMPLATE_DEFAULT_SUBORDINATES = "<Tree><ParentTree/><SoftwareComponents/></Tree><ResponsibleParty><Persons/></ResponsibleParty>";
    protected static SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
    Logger perfLogger;
    protected static SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.ENGLISH);
    List<String> omittedAttributes;
    Map<String, String> attrNameMapping;
    private String additionalAssociations;
    private String additionalSubordinates;

    public OMRIndexDataSupportTemplate() {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        ISO8601FORMAT.setTimeZone(gmt);
        this.perfLogger = LogManager.getLogger((String)"perf.com.sas.svcs.content.search.retrieval.dao.omr.BaseOMRIndexDataDAO");
        gmt = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(gmt);
        this.omittedAttributes = new ArrayList<String>();
        this.omittedAttributes.add("ChangeState");
        this.omittedAttributes.add("isAFolder");
        this.omittedAttributes.add("smartclass");
        this.omittedAttributes.add("IsActive");
        this.omittedAttributes.add("smarttype");
        this.omittedAttributes.add("LockedBy");
        this.attrNameMapping = new HashMap<String, String>();
        this.attrNameMapping.put("Desc", "description");
        this.attrNameMapping.put("Name", "title");
        this.attrNameMapping.put("PublicType", "sastype");
        this.additionalAssociations = null;
        this.additionalSubordinates = null;
    }

    public Map<String, String> getAttributeNameMap() {
        return this.attrNameMapping;
    }

    public List<String> getOmittedAttributes() {
        return this.omittedAttributes;
    }

    public void setAdditionalAssociations(String templateAssociations) {
        this.additionalAssociations = templateAssociations;
    }

    public void setAdditionalSubordinates(String templateSubordinates) {
        this.additionalSubordinates = templateSubordinates;
    }

    public String getTemplate(String metadataType) {
        String template = TEMPLATE_PREFIX + metadataType + ">" + TEMPLATE_BASE_ASSOCIATIONS + (this.additionalAssociations == null ? "" : this.additionalAssociations) + "</" + metadataType + ">" + TEMPLATE_DEFAULT_SUBORDINATES + (this.additionalSubordinates == null ? "" : this.additionalSubordinates) + "</Templates>";
        return template;
    }

    public Filter makeFilter(String publicType, String metadataType, Date modifiedSince, List<String> ids) {
        StringBuilder sb = new StringBuilder();
        sb.append("<XMLSelect search=\"" + metadataType + "[@PublicType='" + publicType + "'");
        if (modifiedSince != null || ids != null && ids.size() > 0) {
            sb.append(" and ");
        }
        if (modifiedSince != null) {
            String dateString = sdf.format(modifiedSince);
            sb.append(" (@MetadataUpdated GT '" + dateString + "'");
        }
        if (ids != null && ids.size() > 0) {
            if (modifiedSince != null) {
                sb.append(" or ");
            }
            boolean isFirst = true;
            sb.append(" (");
            for (String nextId : ids) {
                if (!isFirst) {
                    sb.append(" or ");
                }
                sb.append("@Id='" + nextId + "'");
                isFirst = false;
            }
            sb.append(")");
        }
        if (modifiedSince != null) {
            sb.append(")");
        }
        sb.append("]\"/>");
        Filter filter = new Filter();
        filter.setExplicitSearchString("omi", sb.toString());
        filter.setOMRFlags(16);
        filter.setType(metadataType);
        String template = this.getTemplate(metadataType);
        filter.setOMRTemplate(template);
        return filter;
    }

    public Filter makeFilter(String publicType, String metadataType, Date modifiedSince) {
        Filter filter = new Filter("PublicType", 0, publicType);
        if (modifiedSince != null) {
            String dateString = sdf.format(modifiedSince);
            FilterComponent fc = new FilterComponent("MetadataUpdated", 8, dateString);
            filter.getFilterComponent().addComponent(fc);
            filter.getFilterComponent().setAggregation(0);
        }
        filter.setOMRFlags(16);
        filter.setType(metadataType);
        String template = this.getTemplate(metadataType);
        filter.setOMRTemplate(template);
        return filter;
    }

    public ContentSearchObject makeSearchObjectFromMetadata(MetadataInterface mi, long objectType) {
        try {
            List keywords;
            Date modifiedDate;
            Date createDate;
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            ObjectIdentity identity = new ObjectIdentity(objectType, mi.getReposKey());
            attributes.put("objecttype", "" + objectType);
            attributes.put("sasid", mi.getReposKey());
            attributes.put("authtype", "1");
            attributes.put("auth", mi.getReposKey());
            String guid = mi.getGUID();
            if (guid != null) {
                attributes.put("guid", guid);
            }
            attributes.put("title", mi.getName());
            String description = mi.getDescription();
            if (description != null && description.length() > 0) {
                attributes.put("description", description);
            }
            attributes.put("sastype", mi.getType());
            this.processMetaResponsibleParties(attributes, mi);
            String path = mi.getPath(null);
            if (path != null && path.length() > 0) {
                attributes.put("saspath", "/" + path);
            }
            if ((createDate = mi.getCreateDate()) != null) {
                attributes.put("creationdate", ISO8601FORMAT.format(createDate));
                attributes.put("creationdatelong", "" + createDate.getTime());
            }
            if ((modifiedDate = mi.getModifyDate()) != null) {
                attributes.put("modifieddate", ISO8601FORMAT.format(modifiedDate));
                attributes.put("modifieddatelong", "" + modifiedDate.getTime());
            }
            if ((keywords = mi.getKeywords()) != null && keywords.size() > 0) {
                attributes.put("keywords", this.makeMultiValueString(keywords));
            }
            ContentSearchObject result = new ContentSearchObject(identity, attributes);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ContentSearchObject makeSearchObjectFromBrowse(BrowseMetadata bmi, long objectType) {
        Date modifiedDate;
        Date createDate;
        String path;
        String id = bmi.getReposId() + "/" + bmi.getNativeType();
        ObjectIdentity identity = new ObjectIdentity(objectType, id);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Map bmiMap = bmi.getRawData();
        attributes.put("objecttype", "" + objectType);
        attributes.put("sasid", id);
        attributes.put("authtype", "1");
        attributes.put("auth", id);
        String guid = this.getGUID(bmi);
        if (guid != null) {
            attributes.put("guid", guid);
        }
        if ((path = this.getPath(bmi)) != null && path.length() > 0) {
            attributes.put("saspath", path);
        }
        if ((createDate = bmi.getCreateDateAsDate()) != null) {
            attributes.put("creationdate", ISO8601FORMAT.format(createDate));
            attributes.put("creationdatelong", "" + createDate.getTime());
        }
        if ((modifiedDate = bmi.getModifyDateAsDate()) != null) {
            attributes.put("modifieddate", ISO8601FORMAT.format(modifiedDate));
            attributes.put("modifieddatelong", "" + modifiedDate.getTime());
        }
        for (Map.Entry entry : bmiMap.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (this.omittedAttributes.contains(name)) continue;
            if ("ResponsibleParties".equals(name)) {
                this.processResponsibleParties(attributes, (List)value);
                continue;
            }
            if ("Keywords".equals(name)) {
                this.processKeywords(attributes, (List)value);
                continue;
            }
            String mappedName = this.attrNameMapping.get(name);
            if (mappedName == null || value == null || ((String)value).length() <= 0) continue;
            attributes.put(mappedName, (String)value);
        }
        ContentSearchObject result = new ContentSearchObject(identity, attributes);
        return result;
    }

    public String getGUID(BrowseMetadata bmi) {
        List externalIdentities = (List)bmi.get("ExternalIdentities");
        if (externalIdentities != null) {
            for (BrowseMetadata fm : externalIdentities) {
                if (!"guid".equalsIgnoreCase((String)fm.get("Name"))) continue;
                return (String)fm.get("Identifier");
            }
        }
        return null;
    }

    private void processKeywords(Map<String, Object> attrMap, List<FastMetadata> browseList) {
        ArrayList<String> keywordList = new ArrayList<String>();
        for (FastMetadata bmi : browseList) {
            keywordList.add((String)bmi.get((Object)"Name"));
        }
        if (keywordList.size() > 0) {
            attrMap.put("keywords", this.makeMultiValueString(keywordList));
        }
    }

    private void processMetaResponsibleParties(Map<String, Object> attrMap, MetadataInterface mi) {
        try {
            Root root = (Root)mi.getRepositoryEntity();
            AssociationList responsibleParties = root.getResponsibleParties();
            for (ResponsibleParty rp : responsibleParties) {
                String displayNameString = null;
                String nameString = null;
                String role = rp.getRole();
                AssociationList personList = rp.getPersons();
                if (personList == null || personList.size() <= 0) continue;
                Identity ident = (Identity)personList.get(0);
                displayNameString = nameString = ident.getName();
                String displayString = ident.getDisplayName();
                if (displayString != null && displayString.length() > 0) {
                    displayNameString = displayString;
                }
                if (role != null && role.equalsIgnoreCase("Modified By")) {
                    attrMap.put("lastmodifiedby", nameString);
                    attrMap.put("lastmodifiedbydisplay", displayNameString);
                    continue;
                }
                if (role == null || !role.equalsIgnoreCase("Created By")) continue;
                attrMap.put("createdby", nameString);
                attrMap.put("createdbydisplay", displayNameString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processResponsibleParties(Map<String, Object> attrMap, List<FastMetadata> browseList) {
        if (browseList == null) {
            return;
        }
        for (FastMetadata bmi : browseList) {
            List personList = (List)bmi.get((Object)"Persons");
            if (personList == null || personList.size() <= 0) continue;
            FastMetadata browsePerson = (FastMetadata)personList.get(0);
            String role = (String)bmi.get((Object)"Role");
            String nameString = (String)browsePerson.get((Object)"Name");
            String displayNameString = (String)browsePerson.get((Object)"DisplayName");
            if (displayNameString == null || displayNameString.length() == 0) {
                displayNameString = nameString;
            }
            if (role != null && role.equalsIgnoreCase("Modified By")) {
                attrMap.put("lastmodifiedby", nameString);
                attrMap.put("lastmodifiedbydisplay", displayNameString);
                continue;
            }
            if (role == null || !role.equalsIgnoreCase("Created By")) continue;
            attrMap.put("createdby", nameString);
            attrMap.put("createdbydisplay", displayNameString);
        }
    }

    public String getPath(BrowseMetadata bmi) {
        List rootList;
        ArrayList<BrowseMetadata> pathList = new ArrayList<BrowseMetadata>();
        BrowseMetadata nextParent = null;
        List parentList = bmi.getParents();
        while (parentList != null && parentList.size() > 0) {
            nextParent = (BrowseMetadata)parentList.get(0);
            pathList.add(0, nextParent);
            parentList = nextParent.getParents();
        }
        if (pathList.size() == 0) {
            nextParent = bmi;
        }
        if ((rootList = (List)nextParent.get("SoftwareComponents")) == null || rootList.size() == 0) {
            return null;
        }
        boolean isRoot = false;
        for (BrowseMetadata nextRoot : rootList) {
            if (!nextRoot.getName().equals("BIP Service")) continue;
            isRoot = true;
        }
        if (!isRoot) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (BrowseMetadata pathElement : pathList) {
            builder.append("/");
            builder.append(pathElement.getName());
        }
        builder.append("/" + bmi.getName());
        return builder.toString();
    }

    String makeMultiValueString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String nextString : list) {
            this.addToStringBuilder(sb, nextString);
        }
        return sb.toString();
    }

    public void addToStringBuilder(StringBuilder sb, String string) {
        if (sb.length() > 0) {
            sb.append(";");
        }
        sb.append(string);
    }

    public Filter getIdsFilter(String publicType, String metadataType, Set<String> idsToRetrieve) {
        StringBuilder sb = new StringBuilder();
        sb.append("<XMLSelect search=\"" + metadataType + "[@PublicType='" + publicType + "' and (");
        boolean isFirst = true;
        for (String id : idsToRetrieve) {
            if (!isFirst) {
                sb.append(" or ");
            }
            sb.append("@Id='" + id + "'");
            isFirst = false;
        }
        sb.append(")]\"/>");
        Filter filter = new Filter();
        filter.setType(metadataType);
        filter.setExplicitSearchString("omi", sb.toString());
        String template = this.getTemplate(metadataType);
        filter.setOMRTemplate(template);
        return filter;
    }

    public Filter getGuidsFilter(String publicType, String metadataType, List<String> guidsToRetrieve) {
        StringBuilder sb = new StringBuilder();
        sb.append("<XMLSelect search=\"" + metadataType + "[@PublicType='" + publicType + "'][ExternalIdentities/ExternalIdentity[@Name='guid' and (");
        boolean isFirst = true;
        for (String guid : guidsToRetrieve) {
            if (!isFirst) {
                sb.append(" or ");
            }
            sb.append("@Identifier='" + guid + "'");
            isFirst = false;
        }
        sb.append(")]]\"/>");
        Filter filter = this.makeFilter(publicType, metadataType, null);
        filter.setExplicitSearchString("omi", sb.toString());
        return filter;
    }

    public final List<IndexDataAttribute> getDefaultFieldMetadata() {
        ArrayList<IndexDataAttribute> result = new ArrayList<IndexDataAttribute>();
        result.add(new IndexDataAttribute("auth", false, IndexDataType.STRING, "Authentication Id"));
        result.add(new IndexDataAttribute("authtype", false, IndexDataType.STRING, "Authentication Type"));
        result.add(new IndexDataAttribute("commentssubject", false, IndexDataType.STRINGLIST, "Comment Subject"));
        result.add(new IndexDataAttribute("commentscontent", false, IndexDataType.STRINGLIST, "Comment Content"));
        result.add(new IndexDataAttribute("createdby", true, IndexDataType.STRING, "Created By"));
        result.add(new IndexDataAttribute("createdbydisplay", true, IndexDataType.STRING, "Created By Display"));
        result.add(new IndexDataAttribute("creationdate", false, IndexDataType.STRING, "Creation Date"));
        result.add(new IndexDataAttribute("creationdatelong", false, IndexDataType.NUMERIC, "Creation Date Long"));
        result.add(new IndexDataAttribute("description", false, IndexDataType.STRING, "Description"));
        result.add(new IndexDataAttribute("guid", false, IndexDataType.STRING, "Guid"));
        result.add(new IndexDataAttribute("sasid", false, IndexDataType.STRING, "SAS Object Id"));
        result.add(new IndexDataAttribute("keywords", false, IndexDataType.STRINGLIST, "Keywords"));
        result.add(new IndexDataAttribute("lastmodifiedby", true, IndexDataType.STRING, "Last Modified By"));
        result.add(new IndexDataAttribute("lastmodifiedbydisplay", true, IndexDataType.STRING, "Last Modified By Display"));
        result.add(new IndexDataAttribute("modifieddate", false, IndexDataType.STRING, "Modified Date"));
        result.add(new IndexDataAttribute("modifieddatelong", false, IndexDataType.NUMERIC, "Modified Date Long"));
        result.add(new IndexDataAttribute("title", false, IndexDataType.STRING, "Title"));
        result.add(new IndexDataAttribute("objecttype", false, IndexDataType.NUMERIC, "Object Type"));
        result.add(new IndexDataAttribute("sastype", true, IndexDataType.STRING, "SAS Type"));
        result.add(new IndexDataAttribute("saspath", false, IndexDataType.STRING, "SAS Path"));
        result.add(new IndexDataAttribute("relationship.parent.name", false, IndexDataType.STRING, "Parent Relationships"));
        result.add(new IndexDataAttribute("relationship.parent.id", false, IndexDataType.STRING, "Parent Ids"));
        result.add(new IndexDataAttribute("relationship.child.name", false, IndexDataType.STRING, "Child Relationships"));
        result.add(new IndexDataAttribute("relationship.child.id", false, IndexDataType.STRING, "Child Ids"));
        result.add(new IndexDataAttribute("relationship.depends.name", false, IndexDataType.STRING, "Depends Relationships"));
        result.add(new IndexDataAttribute("relationship.depends.id", false, IndexDataType.STRING, "Depends Ids"));
        result.add(new IndexDataAttribute("relationship.depended.name", false, IndexDataType.STRING, "Dependent Relationships"));
        result.add(new IndexDataAttribute("relationship.depended.id", false, IndexDataType.STRING, "Dependent Ids"));
        result.add(new IndexDataAttribute("relationship.includes.name", false, IndexDataType.STRING, "Includes Relationships"));
        result.add(new IndexDataAttribute("relationship.includes.id", false, IndexDataType.STRING, "Includes Ids"));
        result.add(new IndexDataAttribute("relationsip.included.name", false, IndexDataType.STRING, "Included relationships"));
        result.add(new IndexDataAttribute("relationship.included.id", false, IndexDataType.STRING, "Included Ids"));
        result.add(new IndexDataAttribute("relationship.associated.name", false, IndexDataType.STRING, "Associated Relationships"));
        result.add(new IndexDataAttribute("relationship.associated.id", false, IndexDataType.STRING, "Associated Ids"));
        result.add(new IndexDataAttribute("relationship.equivalent.name", false, IndexDataType.STRING, "Equivalent relationships"));
        result.add(new IndexDataAttribute("relationship.equivalent.id", false, IndexDataType.STRING, "Equivalent Ids"));
        result.add(new IndexDataAttribute("relationship.synonymous.name", false, IndexDataType.STRING, "Synonymous relationships"));
        result.add(new IndexDataAttribute("relationship.synonymous.id", false, IndexDataType.STRING, "Synonymous Ids"));
        return result;
    }
}

