/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.Responsibility;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.content.lifecycle.client.ConnectionNotMappedException;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.ImportNode;
import com.sas.svcs.content.lifecycle.client.ImportOperation;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.client.TransportUtil;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionType;
import com.sas.svcs.content.lifecycle.dao.mapping.MappingInitialization;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractOMRConnectionMapping;
import com.sas.svcs.content.lifecycle.dao.omr.RB;
import com.sas.svcs.content.logging.client.ContentLoggingService;
import com.sas.svcs.content.logging.client.util.ContentLoggingUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ConnectionType(typeNames={"ResponsibleParty"})
@Repository
public class ResponsiblePartyMapping
extends AbstractOMRConnectionMapping
implements MappingInitialization {
    private static final String FETCH_RESPONSIBILITY_TEMPLATE = "<Templates><ResponsibleParty Name=\"\" Role=\"\"><Persons/></ResponsibleParty><Identity Name=\"\"/></Templates>";
    private static final List<AttributeMapping> mappingList = new ArrayList<AttributeMapping>(3);
    protected static final String PROPERTY_ROLE = "Role";
    protected static final String PROPERTY_USERNAME = "UserName";
    private ContentLoggingService contentLoggingService;

    @Autowired
    public void setContentLoggingService(ContentLoggingService contentLoggingService) {
        this.contentLoggingService = contentLoggingService;
    }

    @Override
    protected String getOMRTemplate() {
        return FETCH_RESPONSIBILITY_TEMPLATE;
    }

    public String getMappingName() {
        return "Responsibility";
    }

    @Override
    public List<AttributeMapping> getAttributeMapping(ConnectionPoint cp) {
        return mappingList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TransportNode> String findDefaultMapping(ConnectionPoint cp, ContentOperation<T> operation) throws ConnectionNotMappedException {
        String targetId = "";
        String role = cp.getProperty(PROPERTY_ROLE);
        if ("Created By".equalsIgnoreCase(role) || "Modified By".equalsIgnoreCase(role)) {
            return targetId;
        }
        String userName = cp.getProperty(PROPERTY_USERNAME);
        if (role == null) {
            if (operation instanceof ImportOperation) {
                String msg = Message.format((String)RB.getStringResource("ResponsiblePartyMapping.NoIdentity.fmt.txt", operation.getLocale()), (Object)cp.getName());
                ContentLoggingUtil.logMessage((ContentLoggingService)this.contentLoggingService, (String)((ImportOperation)operation).getContentLog().getId(), (String)msg, (int)500, null);
            }
            return targetId;
        }
        if (userName == null) {
            if (operation instanceof ImportOperation) {
                String msg = Message.format((String)RB.getStringResource("ResponsiblePartyMapping.NoRole.fmt.txt", operation.getLocale()), (Object)cp.getName());
                ContentLoggingUtil.logMessage((ContentLoggingService)this.contentLoggingService, (String)((ImportOperation)operation).getContentLog().getId(), (String)msg, (int)500, null);
            }
            return targetId;
        }
        MdObjectStore store = null;
        try {
            ServerInterface server = this.getMetadataTemplate().getServer();
            if (server instanceof OMIServer) {
                MdFactory factory = ((OMIServer)server).getMdFactory();
                store = factory.createObjectStore(null, "ResponsiblePartyMappingStore");
                ResponsibleParty rp = factory.getOMIUtil().getResponsibleParty(store, userName, role);
                targetId = rp.getId() + "/" + "ResponsibleParty";
            }
        }
        catch (Exception e) {
            String msg = Message.format((String)RB.getStringResource("ResponsiblePartyMapping.ResponsibilityNotSet.fmt.txt", operation.getLocale()), (Object)role, (Object)userName);
            ContentLoggingUtil.logMessage((ContentLoggingService)this.contentLoggingService, (String)((ImportOperation)operation).getContentLog().getId(), (String)msg, (int)500, null);
        }
        finally {
            if (store != null) {
                try {
                    store.dispose();
                }
                catch (Exception exception) {}
            }
        }
        return targetId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ImportOperation operation, List<ConnectionPoint> connections) {
        HashSet<ImportNode> nodes = new HashSet<ImportNode>();
        for (ConnectionPoint cp : connections) {
            List associatedNodes = cp.getAssociatedObjects();
            if (associatedNodes == null || associatedNodes.isEmpty()) continue;
            Iterator iterator = associatedNodes.iterator();
            while (iterator.hasNext()) {
                TransportNode associatedNode = (TransportNode)iterator.next();
                if (!(associatedNode instanceof ImportNode) || !TransportUtil.isOverwriting((TargetTransportNode)((ImportNode)associatedNode))) continue;
                nodes.add((ImportNode)associatedNode);
            }
        }
        if (nodes.size() > 0) {
            ChildServerInterface childServer = null;
            try {
                int count = 0;
                childServer = this.getMetadataTemplate().getServer().newChild(true);
                for (ImportNode node : nodes) {
                    ConnectionPoint createdByCP;
                    MetadataInterface mi = this.getObject(node.getTargetId(), (ServerInterface)childServer);
                    if (mi == null) continue;
                    ++count;
                    List responsibilities = mi.getResponsibleParties();
                    for (Responsibility responsibility : responsibilities) {
                        mi.removeResponsibleParty(responsibility);
                    }
                    if (count >= 50) {
                        childServer.flush();
                        count = 0;
                    }
                    if ((createdByCP = this.getCreatedByConnectionPoint(node)) == null || createdByCP.getTargetId() != null) continue;
                    this.preserveCreatedBySetting(createdByCP, (ServerInterface)childServer);
                }
                if (count > 0) {
                    childServer.flush();
                }
            }
            catch (Exception e) {
                String msg = RB.getStringResource("ResponsiblePartyMapping.UpdateError.txt", operation.getLocale());
                ContentLoggingUtil.logMessage((ContentLoggingService)this.contentLoggingService, (String)operation.getContentLog().getId(), (String)msg, (int)500, null, (Throwable)e);
            }
            finally {
                if (childServer != null) {
                    try {
                        childServer.rollback();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private ConnectionPoint getCreatedByConnectionPoint(ImportNode node) {
        List cps = node.getConnectionPoints();
        for (ConnectionPoint cp : cps) {
            String role;
            if (!"ResponsibleParty".equalsIgnoreCase(cp.getTypeName()) || !"Created By".equalsIgnoreCase(role = cp.getProperty(PROPERTY_ROLE))) continue;
            return cp;
        }
        return null;
    }

    private void preserveCreatedBySetting(ConnectionPoint createdByCP, ServerInterface server) throws ConnectionNotMappedException {
        String role = createdByCP.getProperty(PROPERTY_ROLE);
        String userName = createdByCP.getProperty(PROPERTY_USERNAME);
        Filter filter = new Filter();
        filter.setType("ResponsibleParty");
        String search = "<XMLSelect search=\"*[@Role='" + role + "'][Persons/*[@Name='" + userName + "']]\"/>";
        filter.setExplicitSearchString("omi", search);
        String targetId = this.searchForConnectionPointId((FilterInterface)filter);
        createdByCP.setTargetId(targetId);
    }

    private MetadataInterface getObject(String targetId, ServerInterface server) throws ServiceException, RemoteException {
        if (targetId != null) {
            OMRRepositoryKey key = new OMRRepositoryKey(targetId);
            String type = key.getType();
            String template = "<Templates><" + type + "><ResponsibleParties/></" + type + "></Templates>";
            Filter filter = new Filter();
            filter.setOMRTemplate(template);
            filter.setType(type);
            filter.setExplicitSearchString("omi", "<XMLSelect search = \"*[@Id='" + key.getId() + "']\"/>");
            List objects = server.search((FilterInterface)filter);
            if (objects != null && !objects.isEmpty()) {
                return (MetadataInterface)objects.get(0);
            }
        }
        return null;
    }

    static {
        mappingList.add(new AttributeMapping("User_ref", "Reference", "/Persons/Identity"));
        mappingList.add(new AttributeMapping(PROPERTY_USERNAME, "String", "&User_ref@Name"));
        mappingList.add(new AttributeMapping(PROPERTY_ROLE, "String", "@Role"));
    }
}

