/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.content.lifecycle.client.ConnectionNotMappedException;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionType;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractOMRConnectionMapping;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;

@ConnectionType(typeNames={"Login"})
@Repository
public class LoginMapping
extends AbstractOMRConnectionMapping {
    private static final List<AttributeMapping> mappingList = new ArrayList<AttributeMapping>(3);

    public String getMappingName() {
        return "Login";
    }

    @Override
    public List<AttributeMapping> getAttributeMapping(ConnectionPoint cp) {
        return mappingList;
    }

    public <T extends TransportNode> String findDefaultMapping(ConnectionPoint cp, ContentOperation<T> operation) throws ConnectionNotMappedException {
        String userid = cp.getProperty("UserID");
        String domain = cp.getProperty("Domain");
        Filter filter = new Filter();
        filter.setType("Login");
        StringBuilder sb = new StringBuilder();
        sb.append("<XMLSelect search=\"*[@UserID='" + userid + "']");
        if (domain != null && domain.length() > 0) {
            sb.append("[Domain/AuthenticationDomain[@Name='" + domain + "']]");
        }
        sb.append("\"/>");
        String search = sb.toString();
        filter.setExplicitSearchString("omi", search);
        return this.searchForConnectionPointId((FilterInterface)filter);
    }

    static {
        mappingList.add(new AttributeMapping("Domain_ref", "Reference", "/Domain/AuthenticationDomain"));
        mappingList.add(new AttributeMapping("Domain", "String", "&Domain_ref@Name"));
        mappingList.add(new AttributeMapping("UserID", "String", "@UserID"));
    }
}

