/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.services.util.XMLUtil;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.FatalContentException;
import com.sas.svcs.content.lifecycle.client.ImportNode;
import com.sas.svcs.content.lifecycle.client.ImportOperation;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TransportUtil;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractImportMetadataUtil;
import com.sas.svcs.content.lifecycle.dao.omr.DocumentTransportMetadataParser;
import com.sas.svcs.content.lifecycle.dao.omr.FinishedParsingException;
import com.sas.svcs.content.lifecycle.dao.omr.ParsingConstants;
import com.sas.svcs.content.lifecycle.dao.omr.RB;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.streaming.client.StreamService;
import com.sas.svcs.content.transport.client.ContentItem;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

public final class ImportMetadataUtil
extends AbstractImportMetadataUtil<ImportNode> {
    private static final Logger log = LogManager.getLogger(ImportMetadataUtil.class);
    private SAXParser transportMetadataParser = null;
    protected StreamService streamService;

    public ImportMetadataUtil(ImportOperation operation) {
        super(operation, operation.getTargetContainer());
    }

    public void setStreamService(StreamService streamService) {
        this.streamService = streamService;
    }

    protected Map<String, Document> getObjectDocuments(List<ImportNode> nodes, ContentItem transportContent, ObjectTypeService objectTypeService) throws ContentException {
        DocumentTransportMetadataParser transportParser = new DocumentTransportMetadataParser(nodes, objectTypeService);
        InputStream inputStream = null;
        try {
            inputStream = this.getTransportMetadataStream(transportContent);
            if (this.transportMetadataParser == null) {
                this.transportMetadataParser = XMLUtil.createSAXParser();
            }
            this.transportMetadataParser.parse(inputStream, (DefaultHandler)transportParser);
        }
        catch (FinishedParsingException e) {
        }
        catch (Exception e) {
            throw new ContentException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.warn(RB.getStringResource("ExportMetadataUtil.closingerror.txt"));
            }
        }
        Map<String, Document> map = transportParser.getDocumentMap();
        return map;
    }

    protected void importMetadata(List<ImportNode> nodes, ContentItem transportContent, ContentItem deployMapContent, boolean includeSecurity) throws ContentException {
        try {
            String inTransport = null;
            inTransport = this.containsDisabledObjects(nodes) ? this.getUpdatedTransportMetadata(transportContent, nodes) : this.getTextFromContentItem(transportContent);
            String inDeployMap = this.getTextFromContentItem(deployMapContent);
            this.importMetadata(nodes, inTransport, inDeployMap);
            inTransport = null;
            inDeployMap = null;
        }
        catch (FatalContentException fce) {
            throw fce;
        }
        catch (Exception ex) {
            throw new FatalContentException(ex.getMessage());
        }
    }

    private boolean containsDisabledObjects(List<ImportNode> nodes) {
        for (ImportNode node : nodes) {
            if (!this.isObjectDisabled(node)) continue;
            return true;
        }
        return false;
    }

    private boolean isObjectDisabled(ImportNode node) {
        return node == null ? true : TransportUtil.isDisabled((TargetTransportNode)node);
    }

    private boolean isObjectDisabled(String id, Map<String, ImportNode> importCache) {
        ImportNode node = importCache.get(id);
        return node == null ? true : TransportUtil.isDisabled((TargetTransportNode)node);
    }

    String getTextFromContentItem(ContentItem contentItem) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectIdentity identity = new ObjectIdentity(160L, contentItem.getId());
        this.streamService.getStreamContents(identity, (OutputStream)baos);
        return baos.toString("UTF-8");
    }

    private InputStream getTransportMetadataStream(ContentItem contentItem) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectIdentity identity = new ObjectIdentity(160L, contentItem.getId());
        this.streamService.getStreamContents(identity, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return new BufferedInputStream(bais);
    }

    String getUpdatedTransportMetadata(ContentItem contentItem, List<ImportNode> nodes) throws ContentException {
        if (log.isDebugEnabled()) {
            log.debug(RB.getStringResource("ImportMetadataUtil.updatingmetadata.txt"));
        }
        InputStream inStream = null;
        XMLEventReader eventReader = null;
        try {
            HashMap<String, ImportNode> importCache = new HashMap<String, ImportNode>(nodes.size());
            for (ImportNode node : nodes) {
                OMRRepositoryKey key = new OMRRepositoryKey(node.getId());
                importCache.put(key.getId(), node);
            }
            StringWriter sw = new StringWriter();
            XMLEventWriter writer = this.outputFactory.createXMLEventWriter(sw);
            inStream = this.getTransportMetadataStream(contentItem);
            eventReader = this.inputFactory.createXMLEventReader(inStream, "UTF-8");
            int currentLevel = 0;
            boolean skipCurrentObject = false;
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                switch (e.getEventType()) {
                    case 7: {
                        writer.add(this.eventFactory.createStartDocument());
                        break;
                    }
                    case 1: {
                        StartElement se = e.asStartElement();
                        if (currentLevel == 1) {
                            skipCurrentObject = false;
                            Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
                            if (idAttr != null && this.isObjectDisabled(idAttr.getValue(), importCache)) {
                                skipCurrentObject = true;
                            }
                        }
                        if (!skipCurrentObject) {
                            writer.add(this.eventFactory.createStartElement(se.getName(), se.getAttributes(), se.getNamespaces()));
                        }
                        ++currentLevel;
                        break;
                    }
                    case 2: {
                        --currentLevel;
                        if (skipCurrentObject) break;
                        EndElement ee = e.asEndElement();
                        writer.add(this.eventFactory.createEndElement(ee.getName(), ee.getNamespaces()));
                        break;
                    }
                    case 8: {
                        writer.add(this.eventFactory.createEndDocument());
                    }
                }
            }
            writer.flush();
            writer.close();
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            throw new ContentException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (eventReader != null) {
                    eventReader.close();
                }
            }
            catch (Exception e) {
                log.debug(RB.getStringResource("ExportMetadataUtil.closingerror.txt"));
            }
        }
    }
}

