/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.services.util.XMLUtil;
import com.sas.svcs.common.client.dao.ContentValidationDAO;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.InvalidLengthException;
import com.sas.svcs.content.framework.client.InvalidNameException;
import com.sas.svcs.content.framework.client.InvalidParentException;
import com.sas.svcs.content.framework.client.NameInUseException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.rmi.RemoteException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository(value="DefaultOMRContentValidationDAO")
public class DefaultOMRContentValidationDAO
implements ContentValidationDAO {
    protected static final int NAME_MIN_LENGTH = 1;
    protected static final int NAME_MAX_LENGTH = 60;
    protected static final char INVALID_CHARACTER_BACKSLASH = '\\';
    protected static final char INVALID_CHARACTER_FORWARDSLASH = '/';
    protected static final char[] INVALID_CHARACTERS = new char[]{'\\', '/'};
    protected MetadataTemplate metadataTemplate;
    protected ObjectTypeService objectTypeService;

    @Autowired
    public void setMetadataTemplate(@Qualifier(value="currentUserMetadataTemplate") MetadataTemplate metadataTemplate) {
        this.metadataTemplate = metadataTemplate;
    }

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    public boolean canCreate(String name, long objectType, ObjectIdentity parent) throws ValidationException {
        boolean response = this.validateName(name);
        if (response) {
            response = this.validateContainer(name, objectType, parent);
        }
        return response;
    }

    protected boolean validateName(String name) throws ValidationException {
        Assert.notNull((Object)name, (String)"[Assertion failed] - this argument is required; it must not be null");
        if (name.length() < 1 || name.length() > 60) {
            throw new InvalidLengthException(name, 1, 60);
        }
        int start = 0;
        int end = name.length() - 1;
        int len = name.length();
        for (int index = 0; index < len; ++index) {
            char c = name.charAt(index);
            if (index == start && Character.isSpaceChar(c)) {
                InvalidNameException ex = this.createInvalidNameException("Name may not contain leading spaces.", name);
                ex.setContainsLeadingTrailingSpaces(true);
                throw ex;
            }
            if (index == end && Character.isSpaceChar(c)) {
                InvalidNameException ex = this.createInvalidNameException("Name may not contain trailing spaces.", name);
                ex.setContainsLeadingTrailingSpaces(true);
                throw ex;
            }
            if (c == '\\') {
                throw this.createInvalidNameException("Name may not contain '\\' characters.", name);
            }
            if (c == '/') {
                throw this.createInvalidNameException("Name may not contain '/' characters.", name);
            }
            if (!Character.isISOControl(c)) continue;
            throw this.createInvalidNameException("Name may not contain control characters.", name);
        }
        return true;
    }

    private InvalidNameException createInvalidNameException(String msg, String name) {
        InvalidNameException e = new InvalidNameException(msg, name);
        e.setIllegalChars(INVALID_CHARACTERS);
        return e;
    }

    protected boolean validateContainer(String name, long objectType, ObjectIdentity parent) throws ValidationException {
        if (parent == null) {
            return true;
        }
        try {
            ObjectType childObjectType = this.objectTypeService.getTypeById(objectType);
            if (childObjectType == null) {
                return false;
            }
            ObjectType parentObjectType = this.objectTypeService.getTypeById(parent.getObjectType());
            if (parentObjectType == null) {
                return false;
            }
            if (this.isProcessingContainerValidation(childObjectType)) {
                if (!this.isValidContainer(childObjectType, parentObjectType)) {
                    throw new InvalidParentException(name, objectType, parent.getObjectType());
                }
                if (this.doesObjectExist(name, childObjectType, parent)) {
                    throw new NameInUseException(name, objectType, parent.getObjectType());
                }
            }
            return true;
        }
        catch (ServiceException e) {
            throw new ValidationException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    private boolean isProcessingContainerValidation(ObjectType childType) throws RemoteException, ServiceException {
        TypeDescriptorInterface childTypeDesc = this.getTypeDescriptor(childType);
        if (childTypeDesc == null) {
            return false;
        }
        String containerType = childTypeDesc.getContainerType();
        return this.isOMRFolderType(containerType) || this.isVirtualFolderType(containerType);
    }

    protected boolean isValidContainer(ObjectType childType, ObjectType parentType) throws RemoteException, ServiceException {
        long parentTypeId = parentType.getId();
        if (this.isRootFolderType(parentTypeId)) {
            long childTypeId = childType.getId();
            return childTypeId == 28L || childTypeId == 75L || childTypeId == 105L;
        }
        TypeDescriptorInterface childTypeDesc = this.getTypeDescriptor(childType);
        TypeDescriptorInterface parentTypeDesc = this.getTypeDescriptor(parentType);
        if (childTypeDesc == null || parentTypeDesc == null) {
            return false;
        }
        String containerType = childTypeDesc.getContainerType();
        return containerType == null ? false : containerType.equalsIgnoreCase(parentTypeDesc.getTypeName());
    }

    protected final TypeDescriptorInterface getTypeDescriptor(ObjectType objectType) throws RemoteException, ServiceException {
        if (objectType != null) {
            String publicType = this.isOMRFolderType(objectType.getId()) ? "Folder" : objectType.getName();
            ServerInterface server = this.metadataTemplate.getServer();
            return server.getTypeDescriptor(publicType);
        }
        return null;
    }

    protected final TypeDescriptorInterface getTypeDescriptor(long objectTypeId) throws RemoteException, ServiceException {
        ObjectType objectType = this.objectTypeService.getTypeById(objectTypeId);
        return this.getTypeDescriptor(objectType);
    }

    protected boolean doesObjectExist(String name, ObjectType objectType, ObjectIdentity parent) throws ServiceException, RemoteException {
        long parentTypeId = parent.getObjectType();
        if (this.isOMRFolderType(parentTypeId) || this.isRootFolderType(parentTypeId)) {
            int objectCount = this.searchForObject(name, objectType, parent);
            return objectCount > 0;
        }
        return false;
    }

    private int searchForObject(String name, ObjectType objectType, ObjectIdentity parent) throws ServiceException, RemoteException {
        ServerInterface server;
        FilterInterface filter = null;
        filter = this.isOMRFolderType(objectType.getId()) ? this.createFolderSearchFilter(name, objectType, parent) : this.createObjectSearchFilter(name, objectType, parent);
        if (filter != null && (server = this.metadataTemplate.getServer()) instanceof MetadataServerInterface) {
            return ((MetadataServerInterface)server).getCountNoSecurity((Filter)filter, null);
        }
        return 0;
    }

    private FilterInterface createFolderSearchFilter(String name, ObjectType objectType, ObjectIdentity parent) throws ServiceException, RemoteException {
        TypeDescriptorInterface typeDesc = this.getTypeDescriptor(objectType);
        if (typeDesc == null) {
            return null;
        }
        String id = null;
        StringBuilder sb = new StringBuilder(150);
        sb.append("<XMLSelect search=\"*[@Name='");
        sb.append(XMLUtil.normalize((String)name));
        sb.append("' and ");
        sb.append(this.buildPublicTypeXMLSelect(typeDesc.getTypeName()));
        sb.append("]");
        if (parent.getObjectType() == 29L) {
            id = this.getRootFolderId();
            sb.append("[SoftwareComponents/SoftwareComponent[@Id='" + id + "']]");
        } else {
            OMRRepositoryKey key = new OMRRepositoryKey(parent.getId());
            id = key.getId();
            sb.append("[ParentTree/Tree[@Id='" + key.getId() + "']]");
        }
        sb.append("\"/>");
        String reposId = "A0000001." + id.substring(0, 8);
        return this.createFilter(typeDesc.getMetadataType(), reposId, sb.toString());
    }

    private String getRootFolderId() throws ServiceException, RemoteException {
        MetadataInterface mi = this.metadataTemplate.getMetadataObjectByPath("/");
        if (mi == null) {
            throw new RuntimeException("Cannot find root folder");
        }
        return mi.getIdentifier();
    }

    private FilterInterface createObjectSearchFilter(String name, ObjectType objectType, ObjectIdentity parent) throws ServiceException, RemoteException {
        OMRRepositoryKey key = new OMRRepositoryKey(parent.getId());
        StringBuilder sb = new StringBuilder(150);
        sb.append("<XMLSelect search=\"*[@Name='");
        sb.append(XMLUtil.normalize((String)name));
        sb.append("' and ");
        sb.append(this.buildPublicTypeXMLSelect(objectType.getName()));
        sb.append("][");
        sb.append("Trees/Tree[@Id='" + key.getId() + "']]\"/>");
        String reposId = "A0000001." + key.getId().substring(0, 8);
        TypeDescriptorInterface typeDesc = this.getTypeDescriptor(objectType);
        return typeDesc == null ? null : this.createFilter(typeDesc.getMetadataType(), reposId, sb.toString());
    }

    private String buildPublicTypeXMLSelect(String publicType) {
        if (publicType == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(55);
        int index = publicType.indexOf(46);
        if (index > -1) {
            sb.append("@PublicType=:'").append(publicType.substring(0, index)).append("'");
        } else {
            sb.append("(@PublicType='").append(publicType).append("' OR @PublicType=:'").append(publicType).append(".')");
        }
        return sb.toString();
    }

    private FilterInterface createFilter(String metadataType, String reposID, String xmlSelect) throws ServiceException, RemoteException {
        if (xmlSelect == null || xmlSelect.length() == 0) {
            return null;
        }
        Filter filter = new Filter();
        if (reposID != null) {
            filter.setOMRRepository(reposID);
        }
        filter.setType(metadataType);
        filter.setExplicitSearchString("omi", xmlSelect);
        return filter;
    }

    private boolean isOMRFolderType(long objectType) {
        return objectType == 28L || objectType == 75L || objectType == 105L || objectType == 85L;
    }

    private boolean isOMRFolderType(String objectTypeName) {
        return "Folder".equalsIgnoreCase(objectTypeName) || "SystemFolder".equalsIgnoreCase(objectTypeName) || "RepositoryRootFolder".equalsIgnoreCase(objectTypeName) || "UserFolder".equalsIgnoreCase(objectTypeName);
    }

    private boolean isVirtualFolderType(long objectType) {
        return objectType == 30L;
    }

    private boolean isVirtualFolderType(String objectTypeName) {
        return "Folder.Virtual".equalsIgnoreCase(objectTypeName);
    }

    private boolean isRootFolderType(long objectType) {
        return objectType == 29L;
    }
}

